/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ResearchElementType {
    POPULATION,
    EXPOSURE,
    OUTCOME,
    NULL;


    public static ResearchElementType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("population".equals(codeString)) {
            return POPULATION;
        }
        if ("exposure".equals(codeString)) {
            return EXPOSURE;
        }
        if ("outcome".equals(codeString)) {
            return OUTCOME;
        }
        throw new FHIRException("Unknown ResearchElementType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case POPULATION: {
                return "population";
            }
            case EXPOSURE: {
                return "exposure";
            }
            case OUTCOME: {
                return "outcome";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/research-element-type";
    }

    public String getDefinition() {
        switch (this) {
            case POPULATION: {
                return "The element defines the population that forms the basis for research.";
            }
            case EXPOSURE: {
                return "The element defines an exposure within the population that is being researched.";
            }
            case OUTCOME: {
                return "The element defines an outcome within the population that is being researched.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case POPULATION: {
                return "Population";
            }
            case EXPOSURE: {
                return "Exposure";
            }
            case OUTCOME: {
                return "Outcome";
            }
        }
        return "?";
    }
}

