/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.rdf;

import java.util.HashSet;
import java.util.LinkedList;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;

public class StreamRDFDedup
implements StreamRDF {
    private final StreamRDF wrapped;
    private final int windowSize;
    private final HashSet<Object> tripleAndQuadCache;
    private final LinkedList<Object> tripleAndQuadList = new LinkedList();

    public StreamRDFDedup(StreamRDF wrapped) {
        this(wrapped, 10000);
    }

    public StreamRDFDedup(StreamRDF wrapped, int windowSize) {
        this.wrapped = wrapped;
        this.windowSize = windowSize;
        this.tripleAndQuadCache = new HashSet(windowSize * 3 / 2);
    }

    public void start() {
        this.wrapped.start();
    }

    public void triple(Triple triple) {
        if (!this.seen(triple)) {
            this.wrapped.triple(triple);
        }
    }

    public void quad(Quad quad) {
        if (!this.seen(quad)) {
            this.wrapped.quad(quad);
        }
    }

    public void base(String base) {
        this.wrapped.base(base);
    }

    public void prefix(String prefix, String iri) {
        this.wrapped.prefix(prefix, iri);
    }

    public void finish() {
        this.wrapped.finish();
    }

    private boolean seen(Object tuple) {
        if (this.tripleAndQuadCache.contains(tuple)) {
            return true;
        }
        this.tripleAndQuadCache.add(tuple);
        this.tripleAndQuadList.add(tuple);
        if (this.tripleAndQuadList.size() > this.windowSize) {
            this.forgetOldest();
        }
        return false;
    }

    private void forgetOldest() {
        this.tripleAndQuadCache.remove(this.tripleAndQuadList.removeFirst());
    }
}

