/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.InboxResponseList;
import facebook4j.Message;
import facebook4j.PagableList;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CommentJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.InboxResponseListImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MessageJSONImpl
extends FacebookResponseImpl
implements Message,
Serializable {
    private static final long serialVersionUID = -2666008917993827020L;
    private String id;
    private IdNameEntity from;
    private List<IdNameEntity> to;
    private PagableList<Message.Attachment> attachments;
    private String message;
    private Date createdTime;
    private Date updatedTime;
    private PagableList<Comment> comments;
    private Integer unread;
    private Integer unseen;
    private String sticker;

    MessageJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    MessageJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            int i;
            int size;
            JSONArray list;
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            }
            if (!json.isNull("to")) {
                JSONObject toJSONObject = json.getJSONObject("to");
                JSONArray toJSONArray = toJSONObject.getJSONArray("data");
                this.to = new ArrayList<IdNameEntity>();
                for (int i2 = 0; i2 < toJSONArray.length(); ++i2) {
                    this.to.add(new IdNameEntityJSONImpl(toJSONArray.getJSONObject(i2)));
                }
            } else {
                this.to = Collections.emptyList();
            }
            this.sticker = z_F4JInternalParseUtil.getRawString("sticker", json);
            this.message = z_F4JInternalParseUtil.getRawString("message", json);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            if (!json.isNull("comments")) {
                JSONObject commentsJSONObject = json.getJSONObject("comments");
                if (!commentsJSONObject.isNull("data")) {
                    list = commentsJSONObject.getJSONArray("data");
                    size = list.length();
                    this.comments = new PagableListImpl<Comment>(size, commentsJSONObject, new Comment[0]);
                    for (i = 0; i < size; ++i) {
                        CommentJSONImpl comment = new CommentJSONImpl(list.getJSONObject(i));
                        this.comments.add(comment);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, commentsJSONObject, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
            if (!json.isNull("attachments")) {
                JSONObject attachmentsJSONObject = json.getJSONObject("attachments");
                if (!attachmentsJSONObject.isNull("data")) {
                    list = attachmentsJSONObject.getJSONArray("data");
                    size = list.length();
                    this.attachments = new PagableListImpl<Message.Attachment>(size, attachmentsJSONObject, new Message.Attachment[0]);
                    for (i = 0; i < size; ++i) {
                        AttachmentJSONImpl attachment = new AttachmentJSONImpl(list.getJSONObject(i));
                        this.attachments.add(attachment);
                    }
                } else {
                    this.attachments = new PagableListImpl<Message.Attachment>(1, attachmentsJSONObject, new Message.Attachment[0]);
                }
            } else {
                this.attachments = new PagableListImpl<Message.Attachment>(0);
            }
            if (!json.isNull("unread")) {
                this.unread = z_F4JInternalParseUtil.getPrimitiveInt("unread", json);
            }
            if (!json.isNull("unseen")) {
                this.unseen = z_F4JInternalParseUtil.getPrimitiveInt("unseen", json);
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public List<IdNameEntity> getTo() {
        return this.to;
    }

    public PagableList<Message.Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public Integer getUnread() {
        return this.unread;
    }

    @Override
    public Integer getUnseen() {
        return this.unseen;
    }

    @Override
    public String getSticker() {
        return this.sticker;
    }

    static ResponseList<Message> createMessageList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Message> messages = new ResponseListImpl<Message>(size, json, new Message[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject messageJSONObject = list.getJSONObject(i);
                MessageJSONImpl message = new MessageJSONImpl(messageJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(message, messageJSONObject);
                }
                messages.add(message);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(messages, list);
            }
            return messages;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    static InboxResponseList<Message> createInboxMessageList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            InboxResponseListImpl<Message> messages = new InboxResponseListImpl<Message>(size, json, new Message[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject messageJSONObject = list.getJSONObject(i);
                MessageJSONImpl message = new MessageJSONImpl(messageJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(message, messageJSONObject);
                }
                messages.add(message);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(messages, list);
            }
            return messages;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageJSONImpl other = (MessageJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "MessageJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", to=" + this.to + ", message='" + this.message + '\'' + ", attachments='" + this.attachments + '\'' + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", comments=" + this.comments + ", unread=" + this.unread + ", unseen=" + this.unseen + '}';
    }

    private final class AttachmentJSONImpl
    implements Message.Attachment,
    Serializable {
        private static final long serialVersionUID = 2383005779931406513L;
        private String id;
        private String name;
        private String mime_type;
        private String url;
        private String preview_url;

        AttachmentJSONImpl(JSONObject json) throws FacebookException {
            try {
                this.id = z_F4JInternalParseUtil.getRawString("id", json);
                JSONObject mediaJson = null;
                if (!json.isNull("video_data")) {
                    mediaJson = json.getJSONObject("video_data");
                } else if (!json.isNull("image_data")) {
                    mediaJson = json.getJSONObject("image_data");
                }
                if (mediaJson != null) {
                    this.url = z_F4JInternalParseUtil.getRawString("url", mediaJson);
                    this.preview_url = z_F4JInternalParseUtil.getRawString("preview_url", mediaJson);
                } else {
                    this.url = z_F4JInternalParseUtil.getRawString("file_url", json);
                }
                this.name = z_F4JInternalParseUtil.getRawString("name", json);
                this.mime_type = z_F4JInternalParseUtil.getRawString("mime_type", json);
            }
            catch (JSONException jsone) {
                throw new FacebookException(jsone.getMessage(), jsone);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getMimeType() {
            return this.mime_type;
        }

        public String getUrl() {
            return this.url;
        }

        public String getPreviewUrl() {
            return this.preview_url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttachmentJSONImpl that = (AttachmentJSONImpl)o;
            return !(this.id == null ? that.id != null : !this.id.equals(that.id));
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }

        public String toString() {
            return "AttachmentJSONImpl{, id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", mime_type='" + this.mime_type + '\'' + ", url='" + this.url + '\'' + ", preview_url='" + this.preview_url + '\'' + '}';
        }
    }
}

