/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Category;
import facebook4j.FacebookException;
import facebook4j.Photo;
import facebook4j.Post;
import facebook4j.Privacy;
import facebook4j.ResponseList;
import facebook4j.Tag;
import facebook4j.Tagged;
import facebook4j.Video;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.PhotoJSONImpl;
import facebook4j.internal.json.PostJSONImpl;
import facebook4j.internal.json.PrivacyJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.json.TagJSONImpl;
import facebook4j.internal.json.VideoJSONImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedJSONImpl
extends FacebookResponseImpl
implements Tagged,
Serializable {
    private static final long serialVersionUID = -6025394310112011794L;
    private String id;
    private String type;
    private Post post;
    private Photo photo;
    private Video video;
    private String message;
    private Map<String, Tag[]> messageTags;
    private String objectId;
    private Privacy privacy;
    private List<Category> to;
    private Date updatedTime;

    TaggedJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    TaggedJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            this.type = z_F4JInternalParseUtil.getRawString("type", json);
            if (this.type.equals("photo")) {
                this.photo = new PhotoJSONImpl(json);
            } else if (this.type.equals("video")) {
                this.video = new VideoJSONImpl(json);
            } else {
                this.post = new PostJSONImpl(json);
            }
            if (!json.isNull("message")) {
                this.message = z_F4JInternalParseUtil.getRawString("message", json);
            }
            if (!json.isNull("message_tags")) {
                JSONObject messageTagsJSONObject = json.getJSONObject("message_tags");
                this.messageTags = new HashMap<String, Tag[]>();
                Iterator keys = messageTagsJSONObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONArray messageTagsJSONArray = messageTagsJSONObject.getJSONArray(key);
                    Tag[] tags = new Tag[messageTagsJSONArray.length()];
                    for (int i = 0; i < messageTagsJSONArray.length(); ++i) {
                        JSONObject tag = messageTagsJSONArray.getJSONObject(i);
                        tags[i] = new TagJSONImpl(tag);
                    }
                    this.messageTags.put(key, tags);
                }
            } else {
                this.messageTags = Collections.emptyMap();
            }
            if (!json.isNull("object_id")) {
                this.objectId = z_F4JInternalParseUtil.getRawString("object_id", json);
            }
            this.privacy = new PrivacyJSONImpl(json.getJSONObject("privacy"));
            if (!json.isNull("to")) {
                JSONArray toJSONArray = json.getJSONObject("to").getJSONArray("data");
                this.to = new ArrayList<Category>();
                for (int i = 0; i < toJSONArray.length(); ++i) {
                    JSONObject toJSONObject = toJSONArray.getJSONObject(i);
                    this.to.add(new CategoryJSONImpl(toJSONObject));
                }
            } else {
                this.to = Collections.emptyList();
            }
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Post getPost() {
        return this.post;
    }

    @Override
    public Photo getPhoto() {
        return this.photo;
    }

    @Override
    public Video getVideo() {
        return this.video;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Map<String, Tag[]> getMessageTags() {
        return this.messageTags;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public Privacy getPrivacy() {
        return this.privacy;
    }

    @Override
    public List<Category> getTo() {
        return this.to;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    static ResponseList<Tagged> createTaggedList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Tagged> taggeds = new ResponseListImpl<Tagged>(size, json, new Tagged[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject taggedJSONObject = list.getJSONObject(i);
                TaggedJSONImpl tagged = new TaggedJSONImpl(taggedJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(tagged, taggedJSONObject);
                }
                taggeds.add(tagged);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(taggeds, list);
            }
            return taggeds;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaggedJSONImpl)) {
            return false;
        }
        TaggedJSONImpl that = (TaggedJSONImpl)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "TaggedJSONImpl{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", post=" + this.post + ", photo=" + this.photo + ", video=" + this.video + ", message='" + this.message + '\'' + ", messageTags=" + this.messageTags + ", objectId='" + this.objectId + '\'' + ", privacy=" + this.privacy + ", to=" + this.to + ", updatedTime=" + this.updatedTime + '}';
    }
}

