/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.etcd.AbstractEtcdPollingConsumer;
import org.apache.camel.component.etcd.EtcdStatsEndpoint;

public class EtcdStatsConsumer
extends AbstractEtcdPollingConsumer {
    public EtcdStatsConsumer(EtcdStatsEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public EtcdStatsEndpoint getEndpoint() {
        return (EtcdStatsEndpoint)super.getEndpoint();
    }

    protected int poll() throws Exception {
        EtcdStatsEndpoint endpoint = this.getEndpoint();
        Object answer = endpoint.getStats(this.getClient());
        if (answer != null) {
            Exchange exchange = this.createExchange(true);
            exchange.getIn().setHeader("CamelEtcdNamespace", (Object)"stats");
            exchange.getIn().setHeader("CamelEtcdPath", (Object)endpoint.getPath());
            exchange.getIn().setBody(answer);
            this.getProcessor().process(exchange);
            return 1;
        }
        return 0;
    }
}

