/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class ApiVersionsResponse
extends AbstractResponse {
    public static final long UNKNOWN_FINALIZED_FEATURES_EPOCH = -1L;
    public static final ApiVersionsResponse DEFAULT_API_VERSIONS_RESPONSE = ApiVersionsResponse.createApiVersionsResponse(0, (byte)2, Features.emptySupportedFeatures(), Features.emptyFinalizedFeatures(), -1L);
    public final ApiVersionsResponseData data;

    public ApiVersionsResponse(ApiVersionsResponseData data) {
        this.data = data;
    }

    public ApiVersionsResponse(Struct struct) {
        this(new ApiVersionsResponseData(struct, (short)(ApiVersionsResponseData.SCHEMAS.length - 1)));
    }

    public ApiVersionsResponse(Struct struct, short version) {
        this(new ApiVersionsResponseData(struct, version));
    }

    public ApiVersionsResponseData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public ApiVersionsResponseData.ApiVersionsResponseKey apiVersion(short apiKey) {
        return this.data.apiKeys().find(apiKey);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    public static ApiVersionsResponse parse(ByteBuffer buffer, short version) {
        int prev = buffer.position();
        try {
            return new ApiVersionsResponse(new ApiVersionsResponseData(new ByteBufferAccessor(buffer), version));
        }
        catch (RuntimeException e) {
            buffer.position(prev);
            if (version != 0) {
                return new ApiVersionsResponse(new ApiVersionsResponseData(new ByteBufferAccessor(buffer), 0));
            }
            throw e;
        }
    }

    public static ApiVersionsResponse fromStruct(Struct struct, short version) {
        try {
            return new ApiVersionsResponse(struct, version);
        }
        catch (SchemaException e) {
            if (version != 0) {
                return new ApiVersionsResponse(struct, 0);
            }
            throw e;
        }
    }

    public static ApiVersionsResponse apiVersionsResponse(int throttleTimeMs, byte maxMagic, Features<SupportedVersionRange> latestSupportedFeatures) {
        return ApiVersionsResponse.apiVersionsResponse(throttleTimeMs, maxMagic, latestSupportedFeatures, Features.emptyFinalizedFeatures(), -1L);
    }

    public static ApiVersionsResponse apiVersionsResponse(int throttleTimeMs, byte maxMagic, Features<SupportedVersionRange> latestSupportedFeatures, Features<FinalizedVersionRange> finalizedFeatures, long finalizedFeaturesEpoch) {
        if (maxMagic == 2 && throttleTimeMs == 0) {
            return new ApiVersionsResponse(ApiVersionsResponse.createApiVersionsResponseData(DEFAULT_API_VERSIONS_RESPONSE.throttleTimeMs(), Errors.forCode(DEFAULT_API_VERSIONS_RESPONSE.data().errorCode()), DEFAULT_API_VERSIONS_RESPONSE.data().apiKeys(), latestSupportedFeatures, finalizedFeatures, finalizedFeaturesEpoch));
        }
        return ApiVersionsResponse.createApiVersionsResponse(throttleTimeMs, maxMagic, latestSupportedFeatures, finalizedFeatures, finalizedFeaturesEpoch);
    }

    public static ApiVersionsResponse createApiVersionsResponse(int throttleTimeMs, byte minMagic) {
        return ApiVersionsResponse.createApiVersionsResponse(throttleTimeMs, minMagic, Features.emptySupportedFeatures(), Features.emptyFinalizedFeatures(), -1L);
    }

    private static ApiVersionsResponse createApiVersionsResponse(int throttleTimeMs, byte minMagic, Features<SupportedVersionRange> latestSupportedFeatures, Features<FinalizedVersionRange> finalizedFeatures, long finalizedFeaturesEpoch) {
        ApiVersionsResponseData.ApiVersionsResponseKeyCollection apiKeys = new ApiVersionsResponseData.ApiVersionsResponseKeyCollection();
        for (ApiKeys apiKey : ApiKeys.enabledApis()) {
            if (apiKey.minRequiredInterBrokerMagic > minMagic) continue;
            apiKeys.add(new ApiVersionsResponseData.ApiVersionsResponseKey().setApiKey(apiKey.id).setMinVersion(apiKey.oldestVersion()).setMaxVersion(apiKey.latestVersion()));
        }
        return new ApiVersionsResponse(ApiVersionsResponse.createApiVersionsResponseData(throttleTimeMs, Errors.NONE, apiKeys, latestSupportedFeatures, finalizedFeatures, finalizedFeaturesEpoch));
    }

    public static ApiVersionsResponseData createApiVersionsResponseData(int throttleTimeMs, Errors error, ApiVersionsResponseData.ApiVersionsResponseKeyCollection apiKeys, Features<SupportedVersionRange> latestSupportedFeatures, Features<FinalizedVersionRange> finalizedFeatures, long finalizedFeaturesEpoch) {
        ApiVersionsResponseData data = new ApiVersionsResponseData();
        data.setThrottleTimeMs(throttleTimeMs);
        data.setErrorCode(error.code());
        data.setApiKeys(apiKeys);
        data.setSupportedFeatures(ApiVersionsResponse.createSupportedFeatureKeys(latestSupportedFeatures));
        data.setFinalizedFeatures(ApiVersionsResponse.createFinalizedFeatureKeys(finalizedFeatures));
        data.setFinalizedFeaturesEpoch(finalizedFeaturesEpoch);
        return data;
    }

    private static ApiVersionsResponseData.SupportedFeatureKeyCollection createSupportedFeatureKeys(Features<SupportedVersionRange> latestSupportedFeatures) {
        ApiVersionsResponseData.SupportedFeatureKeyCollection converted = new ApiVersionsResponseData.SupportedFeatureKeyCollection();
        for (Map.Entry<String, SupportedVersionRange> feature : latestSupportedFeatures.features().entrySet()) {
            ApiVersionsResponseData.SupportedFeatureKey key = new ApiVersionsResponseData.SupportedFeatureKey();
            SupportedVersionRange versionRange = feature.getValue();
            key.setName(feature.getKey());
            key.setMinVersion(versionRange.min());
            key.setMaxVersion(versionRange.max());
            converted.add(key);
        }
        return converted;
    }

    private static ApiVersionsResponseData.FinalizedFeatureKeyCollection createFinalizedFeatureKeys(Features<FinalizedVersionRange> finalizedFeatures) {
        ApiVersionsResponseData.FinalizedFeatureKeyCollection converted = new ApiVersionsResponseData.FinalizedFeatureKeyCollection();
        for (Map.Entry<String, FinalizedVersionRange> feature : finalizedFeatures.features().entrySet()) {
            ApiVersionsResponseData.FinalizedFeatureKey key = new ApiVersionsResponseData.FinalizedFeatureKey();
            FinalizedVersionRange versionLevelRange = feature.getValue();
            key.setName(feature.getKey());
            key.setMinVersionLevel(versionLevelRange.min());
            key.setMaxVersionLevel(versionLevelRange.max());
            converted.add(key);
        }
        return converted;
    }
}

