/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gssapi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.credential.GSSKerberosCredential;
import org.wildfly.security.manager.action.SetContextClassLoaderAction;
import org.wildfly.security.manager.action.SetContextClassLoaderFromClassAction;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism.gssapi.GSSCredentialSecurityFactory;
import org.wildfly.security.sasl.gssapi.AbstractGssapiMechanism;

final class GssapiClient
extends AbstractGssapiMechanism
implements SaslClient {
    private static final int INITIAL_CHALLENGE_STATE = 1;
    private static final int CHALLENGE_RESPONSE_STATE = 2;
    private static final int SECURITY_LAYER_NEGOTIATION_STATE = 3;
    private final String authorizationId;

    GssapiClient(String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler, String authorizationId) throws SaslException {
        super("GSSAPI", protocol, serverName, props, callbackHandler);
        GSSContext gssContext;
        GSSName acceptorName;
        this.authorizationId = authorizationId;
        GSSManager manager = GSSManager.getInstance();
        String acceptorNameString = protocol + "@" + serverName;
        ElytronMessages.saslGssapi.tracef("Acceptor Name '%s'", (Object)acceptorNameString);
        try {
            acceptorName = manager.createName(acceptorNameString, GSSName.NT_HOSTBASED_SERVICE, GSSCredentialSecurityFactory.KERBEROS_V5);
        }
        catch (GSSException e) {
            throw ElytronMessages.saslGssapi.mechUnableToCreateNameForAcceptor(e).toSaslException();
        }
        GSSCredential credential = null;
        Object credObj = props.get("javax.security.sasl.credentials");
        if (credObj instanceof GSSCredential) {
            ElytronMessages.saslGssapi.trace("Using GSSCredential supplied in properties.");
            credential = (GSSCredential)credObj;
        } else if (credObj instanceof GSSKerberosCredential) {
            ElytronMessages.saslGssapi.trace("Using GSSCredential supplied in properties.");
            credential = ((GSSKerberosCredential)credObj).getGssCredential();
        }
        if (credential == null) {
            CredentialCallback callback = new CredentialCallback(GSSKerberosCredential.class);
            try {
                this.tryHandleCallbacks(callback);
                GSSKerberosCredential kerberosCredential = callback.getCredential(GSSKerberosCredential.class);
                if (kerberosCredential != null) {
                    credential = kerberosCredential.getGssCredential();
                }
            }
            catch (UnsupportedCallbackException e) {
                ElytronMessages.saslGssapi.trace("CallbackHandler does not support CredentialCallback", e);
            }
        }
        try {
            gssContext = manager.createContext(acceptorName, GSSCredentialSecurityFactory.KERBEROS_V5, credential, Integer.MAX_VALUE);
        }
        catch (GSSException e) {
            throw ElytronMessages.saslGssapi.mechUnableToCreateGssContext(e).toSaslException();
        }
        try {
            boolean delegate;
            boolean bl = delegate = credential != null;
            if (props.containsKey("wildfly.sasl.gssapi.client.delegate-credential")) {
                delegate = Boolean.parseBoolean((String)props.get("wildfly.sasl.gssapi.client.delegate-credential"));
            }
            ElytronMessages.saslGssapi.tracef("Delegating credential = %b", (Object)delegate);
            if (delegate) {
                gssContext.requestCredDeleg(true);
            }
            gssContext.requestInteg(true);
            boolean serverAuth = false;
            if (props.containsKey("javax.security.sasl.server.authentication")) {
                serverAuth = Boolean.parseBoolean((String)props.get("javax.security.sasl.server.authentication"));
            }
            boolean mayRequireSecurityLayer = this.mayRequireSecurityLater(this.orderedQops);
            boolean requestMutualAuth = serverAuth || mayRequireSecurityLayer;
            ElytronMessages.saslGssapi.tracef("Setting requering mutual authentication to %b", (Object)requestMutualAuth);
            gssContext.requestMutualAuth(requestMutualAuth);
            if (mayRequireSecurityLayer) {
                ElytronMessages.saslGssapi.trace("Requesting sequence detection.");
                gssContext.requestSequenceDet(true);
            }
            for (AbstractGssapiMechanism.QOP current : this.orderedQops) {
                if (current != AbstractGssapiMechanism.QOP.AUTH_CONF) continue;
                ElytronMessages.saslGssapi.trace("Requesting confidentiality");
                gssContext.requestConf(true);
                break;
            }
        }
        catch (GSSException e) {
            throw ElytronMessages.saslGssapi.mechUnableToSetGssContextRequestFlags(e).toSaslException();
        }
        this.gssContext = gssContext;
    }

    private boolean mayRequireSecurityLater(AbstractGssapiMechanism.QOP[] preferredQop) {
        for (AbstractGssapiMechanism.QOP current : preferredQop) {
            if (current != AbstractGssapiMechanism.QOP.AUTH_INT && current != AbstractGssapiMechanism.QOP.AUTH_CONF) continue;
            return true;
        }
        return false;
    }

    private AbstractGssapiMechanism.QOP findAgreeableQop(byte securityLayer) throws SaslException {
        for (AbstractGssapiMechanism.QOP current : this.orderedQops) {
            if (!current.includedBy(securityLayer) || !this.isCompatibleWithGssContext(current)) continue;
            return current;
        }
        throw ElytronMessages.saslGssapi.mechInsufficientQopsAvailable().toSaslException();
    }

    private boolean isCompatibleWithGssContext(AbstractGssapiMechanism.QOP qop) {
        switch (qop) {
            case AUTH_INT: {
                return this.gssContext.getIntegState();
            }
            case AUTH_CONF: {
                return this.gssContext.getIntegState() && this.gssContext.getConfState();
            }
        }
        return true;
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        return this.evaluateMessage(challenge);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                assert (!this.gssContext.isEstablished());
                if (message.length > 0) {
                    throw ElytronMessages.saslGssapi.mechInitialChallengeMustBeEmpty().toSaslException();
                }
                try {
                    byte[] response = GssapiClient.initSecContext(this.gssContext, NO_BYTES, 0, 0);
                    if (this.gssContext.isEstablished()) {
                        ElytronMessages.saslGssapi.trace("GSSContext established, transitioning to negotiate security layer.");
                        this.setNegotiationState(3);
                    } else {
                        ElytronMessages.saslGssapi.trace("GSSContext not established, expecting subsequent exchanges.");
                        this.setNegotiationState(2);
                    }
                    return response;
                }
                catch (GSSException e) {
                    throw ElytronMessages.saslGssapi.mechUnableToCreateResponseToken(e).toSaslException();
                }
            }
            case 2: {
                assert (!this.gssContext.isEstablished());
                try {
                    byte[] response = GssapiClient.initSecContext(this.gssContext, message, 0, message.length);
                    if (this.gssContext.isEstablished()) {
                        ElytronMessages.saslGssapi.trace("GSSContext established, transitioning to negotiate security layer.");
                        this.setNegotiationState(3);
                        if (response == null) {
                            response = NO_BYTES;
                        }
                    } else {
                        ElytronMessages.saslGssapi.trace("GSSContext not established, expecting subsequent exchanges.");
                    }
                    return response;
                }
                catch (GSSException e) {
                    throw ElytronMessages.saslGssapi.mechUnableToHandleResponseFromServer(e).toSaslException();
                }
            }
            case 3: {
                assert (this.gssContext.isEstablished());
                MessageProp msgProp = new MessageProp(0, false);
                try {
                    byte[] unwrapped = this.gssContext.unwrap(message, 0, message.length, msgProp);
                    if (unwrapped.length != 4) {
                        throw ElytronMessages.saslGssapi.mechBadLengthOfMessageForNegotiatingSecurityLayer().toSaslException();
                    }
                    byte qopByte = unwrapped[0];
                    this.selectedQop = this.findAgreeableQop(qopByte);
                    this.maxBuffer = this.networkOrderBytesToInt(unwrapped, 1, 3);
                    ElytronMessages.saslGssapi.tracef("Selected QOP=%s, maxBuffer=%d", (Object)this.selectedQop, (Object)this.maxBuffer);
                    if (!this.relaxComplianceChecks && this.maxBuffer > 0 && (qopByte & AbstractGssapiMechanism.QOP.AUTH_INT.getValue()) == 0 && (qopByte & AbstractGssapiMechanism.QOP.AUTH_CONF.getValue()) == 0) {
                        throw ElytronMessages.saslGssapi.mechReceivedMaxMessageSizeWhenNoSecurityLayer(this.maxBuffer).toSaslException();
                    }
                    this.maxBuffer = this.gssContext.getWrapSizeLimit(0, this.selectedQop == AbstractGssapiMechanism.QOP.AUTH_CONF, this.maxBuffer);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    baos.write(this.selectedQop.getValue());
                    if (this.selectedQop == AbstractGssapiMechanism.QOP.AUTH) {
                        baos.write(new byte[]{0, 0, 0});
                    } else {
                        this.actualMaxReceiveBuffer = this.configuredMaxReceiveBuffer != 0 ? this.configuredMaxReceiveBuffer : this.maxBuffer;
                        ElytronMessages.saslGssapi.tracef("Out max buffer %d", this.actualMaxReceiveBuffer);
                        baos.write(this.intToNetworkOrderBytes(this.actualMaxReceiveBuffer));
                    }
                    if (this.authorizationId != null) {
                        baos.write(this.authorizationId.getBytes(StandardCharsets.UTF_8));
                    }
                    byte[] response = baos.toByteArray();
                    msgProp = new MessageProp(0, false);
                    response = this.gssContext.wrap(response, 0, response.length, msgProp);
                    if (this.selectedQop != AbstractGssapiMechanism.QOP.AUTH) {
                        ElytronMessages.saslGssapi.trace("Setting message wrapper.");
                        this.setWrapper(new AbstractGssapiMechanism.GssapiWrapper(this, this.selectedQop == AbstractGssapiMechanism.QOP.AUTH_CONF));
                    }
                    ElytronMessages.saslGssapi.trace("Negotiation Complete");
                    this.negotiationComplete();
                    return response;
                }
                catch (IOException e) {
                    throw ElytronMessages.saslGssapi.mechUnableToCreateResponseToken(e).toSaslException();
                }
                catch (GSSException e) {
                    throw ElytronMessages.saslGssapi.mechUnableToUnwrapSecurityLayerNegotiationMessage(e).toSaslException();
                }
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] initSecContext(GSSContext gssContext, byte[] inputBuf, int offset, int len) throws GSSException {
        ClassLoader old = GssapiClient.doPrivileged(new SetContextClassLoaderFromClassAction(GssapiClient.class));
        try {
            byte[] byArray = gssContext.initSecContext(inputBuf, offset, len);
            return byArray;
        }
        finally {
            GssapiClient.doPrivileged(new SetContextClassLoaderAction(old));
        }
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

