/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.common.Assert;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism.digest.DigestQuote;
import org.wildfly.security.sasl.digest.AbstractDigestMechanism;
import org.wildfly.security.sasl.digest._private.DigestUtil;

final class DigestSaslServer
extends AbstractDigestMechanism
implements SaslServer {
    private final Predicate<String> digestUriProtocolAccepted;
    private final boolean defaultRealm;
    private static final byte STEP_ONE = 1;
    private static final byte STEP_THREE = 3;
    private String[] realms;
    private String supportedCiphers;
    private int receivingMaxBuffSize = 65536;
    private String[] qops;
    private int nonceCount = -1;
    private String receivedClientUri;
    private String boundServerName = null;

    DigestSaslServer(String[] realms, boolean defaultRealm, String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, Charset charset, String[] qops, String[] ciphers, Predicate<String> digestUriProtocolAccepted, Supplier<Provider[]> providers) throws SaslException {
        super(mechanismName, protocol, serverName, callbackHandler, AbstractDigestMechanism.FORMAT.SERVER, charset, ciphers, providers);
        this.realms = realms;
        this.defaultRealm = defaultRealm;
        this.supportedCiphers = DigestSaslServer.getSupportedCiphers(ciphers);
        this.qops = qops;
        this.digestUriProtocolAccepted = digestUriProtocolAccepted;
    }

    private byte[] generateChallenge() {
        ByteStringBuilder challenge = new ByteStringBuilder();
        StringBuilder sb = new StringBuilder();
        for (String realm : this.realms) {
            sb.append("realm=\"").append(DigestQuote.quote(realm)).append("\"").append(',');
        }
        challenge.append(sb.toString().getBytes(this.getCharset()));
        assert (this.nonce == null);
        this.nonce = DigestSaslServer.generateNonce();
        challenge.append("nonce=\"");
        challenge.append(DigestQuote.quote(this.nonce));
        challenge.append("\"").append(',');
        if (this.qops != null) {
            challenge.append("qop=\"");
            boolean first = true;
            for (String qop : this.qops) {
                if (!first) {
                    challenge.append(',');
                }
                first = false;
                challenge.append(DigestQuote.quote(qop));
            }
            challenge.append("\"").append(',');
        }
        if (this.receivingMaxBuffSize != 65536) {
            challenge.append("maxbuf=");
            challenge.append(String.valueOf(this.receivingMaxBuffSize));
            challenge.append(',');
        }
        if (StandardCharsets.UTF_8.equals(this.getCharset())) {
            challenge.append("charset=");
            challenge.append("utf-8");
            challenge.append(',');
        }
        if (this.supportedCiphers != null && this.qops != null && this.arrayContains(this.qops, "auth-conf")) {
            challenge.append("cipher=\"");
            challenge.append(this.supportedCiphers);
            challenge.append("\"").append(',');
        }
        challenge.append("algorithm=md5-sess");
        return challenge.toArray();
    }

    private void noteDigestResponseData(HashMap<String, byte[]> parsedDigestResponse) {
        byte[] data = parsedDigestResponse.get("nc");
        this.nonceCount = data != null ? Integer.parseInt(new String(data, StandardCharsets.UTF_8)) : -1;
        data = parsedDigestResponse.get("cipher");
        this.cipher = data != null ? new String(data, StandardCharsets.UTF_8) : "";
        data = parsedDigestResponse.get("authzid");
        this.authorizationId = data != null ? new String(data, StandardCharsets.UTF_8) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] validateDigestResponse(HashMap<String, byte[]> parsedDigestResponse) throws SaslException {
        if (this.nonceCount != 1) {
            throw ElytronMessages.saslDigest.mechNonceCountMustEqual(1, this.nonceCount).toSaslException();
        }
        Charset clientCharset = StandardCharsets.ISO_8859_1;
        if (parsedDigestResponse.get("charset") != null) {
            String cCharset = new String(parsedDigestResponse.get("charset"), StandardCharsets.UTF_8);
            if (!cCharset.equals("utf-8")) throw ElytronMessages.saslDigest.mechUnknownCharset().toSaslException();
            if (!StandardCharsets.UTF_8.equals(this.getCharset())) throw ElytronMessages.saslDigest.mechUnsupportedCharset("UTF-8").toSaslException();
            clientCharset = StandardCharsets.UTF_8;
        }
        if (parsedDigestResponse.get("username") == null) {
            throw ElytronMessages.saslDigest.mechMissingDirective("username").toSaslException();
        }
        this.username = new String(parsedDigestResponse.get("username"), clientCharset);
        this.realm = parsedDigestResponse.get("realm") != null ? new String(parsedDigestResponse.get("realm"), clientCharset) : "";
        if (!this.arrayContains(this.realms, this.realm)) {
            throw ElytronMessages.saslDigest.mechDisallowedClientRealm(this.realm).toSaslException();
        }
        if (parsedDigestResponse.get("nonce") == null) {
            throw ElytronMessages.saslDigest.mechMissingDirective("nonce").toSaslException();
        }
        byte[] nonceFromClient = parsedDigestResponse.get("nonce");
        if (!Arrays.equals(this.nonce, nonceFromClient)) {
            throw ElytronMessages.saslDigest.mechNoncesDoNotMatch().toSaslException();
        }
        if (parsedDigestResponse.get("cnonce") == null) {
            throw ElytronMessages.saslDigest.mechMissingDirective("cnonce").toSaslException();
        }
        this.cnonce = parsedDigestResponse.get("cnonce");
        if (parsedDigestResponse.get("nc") == null) {
            throw ElytronMessages.saslDigest.mechMissingDirective("nc").toSaslException();
        }
        if (parsedDigestResponse.get("digest-uri") == null) throw ElytronMessages.saslDigest.mechMissingDirective("digest-uri").toSaslException();
        this.receivedClientUri = new String(parsedDigestResponse.get("digest-uri"), clientCharset);
        String[] parts = this.receivedClientUri.split("/", 2);
        String expectedServerName = this.getServerName();
        if (!this.digestUriProtocolAccepted.test(parts[0].toLowerCase(Locale.ROOT)) || expectedServerName != null && !expectedServerName.toLowerCase(Locale.ROOT).equals(parts[1].toLowerCase(Locale.ROOT))) {
            throw ElytronMessages.saslDigest.mechMismatchedWrongDigestUri(this.receivedClientUri).toSaslException();
        }
        this.boundServerName = parts[1];
        this.qop = "auth";
        if (parsedDigestResponse.get("qop") != null) {
            this.qop = new String(parsedDigestResponse.get("qop"), clientCharset);
            if (!this.arrayContains(DigestUtil.QOP_VALUES, this.qop)) {
                throw ElytronMessages.saslDigest.mechUnexpectedQop(this.qop).toSaslException();
            }
            if (this.qop != null && !this.qop.equals("auth")) {
                this.setWrapper(new AbstractDigestMechanism.DigestWrapper(this, this.qop.equals("auth-conf")));
            }
        }
        byte[] digest_urp = this.handleUserRealmPasswordCallbacks(null, true, this.defaultRealm);
        this.hA1 = DigestUtil.H_A1(this.messageDigest, digest_urp, this.nonce, this.cnonce, this.authorizationId, clientCharset);
        byte[] expectedResponse = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, this.nonceCount, this.cnonce, this.authorizationId, this.qop, this.receivedClientUri, true);
        if (parsedDigestResponse.get("response") == null) {
            throw ElytronMessages.saslDigest.mechMissingDirective("response").toSaslException();
        }
        if (!Arrays.equals(expectedResponse, parsedDigestResponse.get("response"))) {
            throw ElytronMessages.saslDigest.mechAuthenticationRejectedInvalidProof().toSaslException();
        }
        this.createCiphersAndKeys();
        String authzid = this.authorizationId == null || this.authorizationId.isEmpty() ? this.username : this.authorizationId;
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(this.username, authzid);
        try {
            this.tryHandleCallbacks(authorizeCallback);
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.saslDigest.mechAuthorizationUnsupported(e).toSaslException();
        }
        if (!authorizeCallback.isAuthorized()) {
            throw ElytronMessages.saslDigest.mechAuthorizationFailed(this.username, authzid).toSaslException();
        }
        this.authorizationId = authorizeCallback.getAuthorizedID();
        return this.createResponseAuth(parsedDigestResponse);
    }

    private byte[] createResponseAuth(HashMap<String, byte[]> parsedDigestResponse) {
        ByteStringBuilder responseAuth = new ByteStringBuilder();
        responseAuth.append("rspauth=");
        byte[] response_value = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, this.nonceCount, this.cnonce, this.authorizationId, this.qop, this.receivedClientUri != null ? this.receivedClientUri : this.digestURI, false);
        responseAuth.append(response_value);
        return responseAuth.toArray();
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationId;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        this.assertComplete();
        if ("javax.security.sasl.bound.server.name".equals(propName)) {
            return this.boundServerName;
        }
        return null;
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.evaluateMessage(response);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                if (message != null && message.length != 0) {
                    throw ElytronMessages.saslDigest.mechInitialChallengeMustBeEmpty().toSaslException();
                }
                this.setNegotiationState(3);
                return this.generateChallenge();
            }
            case 3: {
                HashMap<String, byte[]> parsedDigestResponse;
                if (message == null || message.length == 0) {
                    throw ElytronMessages.saslDigest.mechClientRefusesToInitiateAuthentication().toSaslException();
                }
                try {
                    parsedDigestResponse = org.wildfly.security.mechanism.digest.DigestUtil.parseResponse(message, this.charset, false, ElytronMessages.saslDigest);
                }
                catch (AuthenticationMechanismException e) {
                    throw e.toSaslException();
                }
                this.noteDigestResponseData(parsedDigestResponse);
                byte[] response = this.validateDigestResponse(parsedDigestResponse);
                this.negotiationComplete();
                return response;
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }
}

