/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class UndertowEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":httpURI";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "undertow".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "httpURI", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(30);
        props.add("sendTimeout");
        props.add("sendToAll");
        props.add("sslContextParameters");
        props.add("undertowHttpBinding");
        props.add("useStreaming");
        props.add("bridgeErrorHandler");
        props.add("securityProvider");
        props.add("httpURI");
        props.add("transferException");
        props.add("headerFilterStrategy");
        props.add("options");
        props.add("tcpNoDelay");
        props.add("muteException");
        props.add("reuseAddresses");
        props.add("keepAlive");
        props.add("throwExceptionOnFailure");
        props.add("httpMethodRestrict");
        props.add("allowedRoles");
        props.add("matchOnUriPrefix");
        props.add("exchangePattern");
        props.add("accessLog");
        props.add("lazyStartProducer");
        props.add("preserveHostHeader");
        props.add("fireWebSocketChannelEvents");
        props.add("handlers");
        props.add("accessLogReceiver");
        props.add("optionsEnabled");
        props.add("cookieHandler");
        props.add("exceptionHandler");
        props.add("securityConfiguration");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

