/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.SystemUtilities;
import java.security.SecureRandom;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class UniqueIdGenerator {
    private static final Object lock = new Object();
    private static final Object lock19 = new Object();
    private static int count = 0;
    private static int count2 = 0;
    private static long previousTimeMilliseconds = 0L;
    private static long previousTimeMilliseconds2 = 0L;
    private static final int clusterId;
    private static final Map<Long, Long> lastIds;
    private static final Map<Long, Long> lastIdsFull;

    private UniqueIdGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUniqueId() {
        Object object = lock;
        synchronized (object) {
            long id = UniqueIdGenerator.getUniqueIdAttempt();
            while (lastIds.containsKey(id)) {
                id = UniqueIdGenerator.getUniqueIdAttempt();
            }
            lastIds.put(id, null);
            return id;
        }
    }

    private static long getUniqueIdAttempt() {
        long currentTimeMilliseconds;
        if (++count >= 1000) {
            count = 0;
        }
        if ((currentTimeMilliseconds = System.currentTimeMillis()) > previousTimeMilliseconds) {
            count = 0;
            previousTimeMilliseconds = currentTimeMilliseconds;
        }
        return currentTimeMilliseconds * 100000L + (long)(count * 100) + (long)clusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUniqueId19() {
        Object object = lock19;
        synchronized (object) {
            long id = UniqueIdGenerator.getFullUniqueId19();
            while (lastIdsFull.containsKey(id)) {
                id = UniqueIdGenerator.getFullUniqueId19();
            }
            lastIdsFull.put(id, null);
            return id;
        }
    }

    private static long getFullUniqueId19() {
        long currentTimeMilliseconds;
        if (++count2 >= 10000) {
            count2 = 0;
        }
        if ((currentTimeMilliseconds = System.currentTimeMillis()) > previousTimeMilliseconds2) {
            count2 = 0;
            previousTimeMilliseconds2 = currentTimeMilliseconds;
        }
        return currentTimeMilliseconds * 1000000L + (long)(count2 * 100) + (long)clusterId;
    }

    public static Date getDate(long uniqueId) {
        return new Date(uniqueId / 100000L);
    }

    public static Date getDate19(long uniqueId) {
        return new Date(uniqueId / 1000000L);
    }

    static {
        lastIds = new LinkedHashMap<Long, Long>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, Long> eldest) {
                return this.size() > 1000;
            }
        };
        lastIdsFull = new LinkedHashMap<Long, Long>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, Long> eldest) {
                return this.size() > 10000;
            }
        };
        String id = SystemUtilities.getExternalVariable("JAVA_UTIL_CLUSTERID");
        if (StringUtilities.isEmpty(id)) {
            SecureRandom random = new SecureRandom();
            clusterId = Math.abs(random.nextInt()) % 100;
        } else {
            try {
                clusterId = Math.abs(Integer.parseInt(id)) % 100;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Environment / System variable JAVA_UTIL_CLUSTERID must be 0-99");
            }
        }
    }
}

