/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.converter.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.converter.json.FormatStrategy;
import java.io.IOException;
import java.io.UncheckedIOException;

public class PrettyFormatStrategy
implements FormatStrategy {
    private final ObjectMapper mapper = new ObjectMapper();
    private String idName = "schemaId";
    private String payloadName = "payload";

    public PrettyFormatStrategy setIdName(String idName) {
        this.idName = idName;
        return this;
    }

    public PrettyFormatStrategy setPayloadName(String payloadName) {
        this.payloadName = payloadName;
        return this;
    }

    @Override
    public byte[] fromConnectData(long globalId, byte[] bytes) {
        String payload = IoUtil.toString((byte[])bytes);
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        root.put(this.idName, globalId);
        root.putRawValue(this.payloadName, new RawValue(payload));
        try {
            return this.mapper.writeValueAsBytes((Object)root);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public FormatStrategy.IdPayload toConnectData(byte[] bytes) {
        try {
            JsonNode root = this.mapper.readTree(bytes);
            long globalId = root.get(this.idName).asLong();
            String payload = root.get(this.payloadName).toString();
            byte[] payloadBytes = IoUtil.toBytes((String)payload);
            return new FormatStrategy.IdPayload(globalId, payloadBytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

