/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.elsql;

import com.opengamma.elsql.AndSqlFragment;
import com.opengamma.elsql.ContainerSqlFragment;
import com.opengamma.elsql.EqualsSqlFragment;
import com.opengamma.elsql.IfSqlFragment;
import com.opengamma.elsql.IncludeSqlFragment;
import com.opengamma.elsql.LikeSqlFragment;
import com.opengamma.elsql.LoopSqlFragment;
import com.opengamma.elsql.NameSqlFragment;
import com.opengamma.elsql.OffsetFetchSqlFragment;
import com.opengamma.elsql.OperatorSqlFragment;
import com.opengamma.elsql.OrSqlFragment;
import com.opengamma.elsql.PagingSqlFragment;
import com.opengamma.elsql.TextSqlFragment;
import com.opengamma.elsql.ValueSqlFragment;
import com.opengamma.elsql.WhereSqlFragment;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ElSqlParser {
    private static final String IDENTIFIER = "[A-Za-z0-9_]+";
    private static final String VARIABLE = "[:](?:[A-Za-z0-9_]+|[$]?[{][A-Za-z0-9_.]+[}])";
    private static final String VARIABLE_OR_LITERAL = "[0-9]+|[:](?:[A-Za-z0-9_]+|[$]?[{][A-Za-z0-9_.]+[}])";
    private static final String VARIABLE_LOOPINDEX = "[:](?:[A-Za-z0-9_]+(?:@LOOPINDEX[123]?)?|[$]?[{][A-Za-z0-9_.]+(?:@LOOPINDEX[123]?)?[}])";
    private static final String QUERY_TEXT = "[A-Za-z0-9_]+";
    private static final Pattern NAME_PATTERN = Pattern.compile("[ ]*[@]NAME[(]([A-Za-z0-9_]+)[)][ ]*");
    private static final Pattern AND_PATTERN = Pattern.compile("[ ]*[@]AND[(]([:](?:[A-Za-z0-9_]+(?:@LOOPINDEX[123]?)?|[$]?[{][A-Za-z0-9_.]+(?:@LOOPINDEX[123]?)?[}]))([ ]?[=][ ]?[A-Za-z0-9_]+)?[)][ ]*");
    private static final Pattern OR_PATTERN = Pattern.compile("[ ]*[@]OR[(]([:](?:[A-Za-z0-9_]+(?:@LOOPINDEX[123]?)?|[$]?[{][A-Za-z0-9_.]+(?:@LOOPINDEX[123]?)?[}]))([ ]?[=][ ]?[A-Za-z0-9_]+)?[)][ ]*");
    private static final Pattern IF_PATTERN = Pattern.compile("[ ]*[@]IF[(]([:](?:[A-Za-z0-9_]+(?:@LOOPINDEX[123]?)?|[$]?[{][A-Za-z0-9_.]+(?:@LOOPINDEX[123]?)?[}]))([ ]?[=][ ]?[A-Za-z0-9_]+)?[)][ ]*");
    private static final Pattern LOOP_PATTERN = Pattern.compile("[ ]*[@]LOOP[(]([0-9]+|[:](?:[A-Za-z0-9_]+|[$]?[{][A-Za-z0-9_.]+[}]))[)][ ]*");
    private static final Pattern INCLUDE_PATTERN = Pattern.compile("[@]INCLUDE[(]([:](?:[A-Za-z0-9_]+|[$]?[{][A-Za-z0-9_.]+[}])|[A-Za-z0-9_]+)[)](.*)");
    private static final Pattern PAGING_PATTERN = Pattern.compile("[@]PAGING[(]([0-9]+|[:](?:[A-Za-z0-9_]+|[$]?[{][A-Za-z0-9_.]+[}]))[ ]?[,][ ]?([0-9]+|[:](?:[A-Za-z0-9_]+|[$]?[{][A-Za-z0-9_.]+[}]))[)](.*)");
    private static final Pattern OFFSET_FETCH_PATTERN = Pattern.compile("[@]OFFSETFETCH[(]([0-9]+|[:](?:[A-Za-z0-9_]+|[$]?[{][A-Za-z0-9_.]+[}]))[ ]?[,][ ]?([0-9]+|[:](?:[A-Za-z0-9_]+|[$]?[{][A-Za-z0-9_.]+[}]))[)](.*)");
    private static final Pattern FETCH_PATTERN = Pattern.compile("[@]FETCH[(]([0-9]+|[:](?:[A-Za-z0-9_]+|[$]?[{][A-Za-z0-9_.]+[}]))[)](.*)");
    private static final Pattern VALUE_PATTERN = Pattern.compile("[@]VALUE[(]([:](?:[A-Za-z0-9_]+(?:@LOOPINDEX[123]?)?|[$]?[{][A-Za-z0-9_.]+(?:@LOOPINDEX[123]?)?[}]))[)]( )*(.*)");
    private static final Pattern OPERATOR_VARIABLE_PATTERN = Pattern.compile("([^:])*([:](?:[A-Za-z0-9_]+(?:@LOOPINDEX[123]?)?|[$]?[{][A-Za-z0-9_.]+(?:@LOOPINDEX[123]?)?[}]))(.*)");
    private final List<Line> _lines = new ArrayList<Line>();
    private Map<String, NameSqlFragment> _namedFragments = new LinkedHashMap<String, NameSqlFragment>();

    ElSqlParser(List<String> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            this._lines.add(new Line(line, i + 1));
        }
    }

    Map<String, NameSqlFragment> parse() {
        this.rejectTabs();
        this.parseNamedSections();
        return this._namedFragments;
    }

    private void rejectTabs() {
        for (Line line : this._lines) {
            if (!line.containsTab()) continue;
            throw new IllegalArgumentException("Tab character not permitted: " + line);
        }
    }

    private void parseNamedSections() {
        ContainerSqlFragment containerFragment = new ContainerSqlFragment();
        this.parseContainerSection(containerFragment, this._lines.listIterator(), -1);
    }

    private void parseContainerSection(ContainerSqlFragment container, ListIterator<Line> lineIterator, int indent) {
        while (lineIterator.hasNext()) {
            Line line = lineIterator.next();
            if (line.isComment()) {
                lineIterator.remove();
                continue;
            }
            if (line.indent() <= indent) {
                lineIterator.previous();
                return;
            }
            String trimmed = line.lineTrimmed();
            if (trimmed.startsWith("@NAME")) {
                Matcher nameMatcher = NAME_PATTERN.matcher(trimmed);
                if (!nameMatcher.matches()) {
                    throw new IllegalArgumentException("@NAME found with invalid format: " + line);
                }
                NameSqlFragment nameFragment = new NameSqlFragment(nameMatcher.group(1));
                this.parseContainerSection(nameFragment, lineIterator, line.indent());
                if (nameFragment.getFragments().size() == 0) {
                    throw new IllegalArgumentException("@NAME found with no subsequent indented lines: " + line);
                }
                container.addFragment(nameFragment);
                this._namedFragments.put(nameFragment.getName(), nameFragment);
                continue;
            }
            if (indent < 0) {
                throw new IllegalArgumentException("Invalid fragment found at root level, only @NAME is permitted: " + line);
            }
            if (trimmed.startsWith("@PAGING")) {
                Matcher pagingMatcher = PAGING_PATTERN.matcher(trimmed);
                if (!pagingMatcher.matches()) {
                    throw new IllegalArgumentException("@PAGING found with invalid format: " + line);
                }
                PagingSqlFragment whereFragment = new PagingSqlFragment(pagingMatcher.group(1), pagingMatcher.group(2));
                this.parseContainerSection(whereFragment, lineIterator, line.indent());
                if (whereFragment.getFragments().size() == 0) {
                    throw new IllegalArgumentException("@PAGING found with no subsequent indented lines: " + line);
                }
                container.addFragment(whereFragment);
                continue;
            }
            if (trimmed.startsWith("@WHERE")) {
                if (!trimmed.equals("@WHERE")) {
                    throw new IllegalArgumentException("@WHERE found with invalid format: " + line);
                }
                WhereSqlFragment whereFragment = new WhereSqlFragment();
                this.parseContainerSection(whereFragment, lineIterator, line.indent());
                if (whereFragment.getFragments().size() == 0) {
                    throw new IllegalArgumentException("@WHERE found with no subsequent indented lines: " + line);
                }
                container.addFragment(whereFragment);
                continue;
            }
            if (trimmed.startsWith("@AND")) {
                Matcher andMatcher = AND_PATTERN.matcher(trimmed);
                if (!andMatcher.matches()) {
                    throw new IllegalArgumentException("@AND found with invalid format: " + line);
                }
                AndSqlFragment andFragment = new AndSqlFragment(andMatcher.group(1), this.extractVariable(andMatcher.group(2)));
                this.parseContainerSection(andFragment, lineIterator, line.indent());
                if (andFragment.getFragments().size() == 0) {
                    throw new IllegalArgumentException("@AND found with no subsequent indented lines: " + line);
                }
                container.addFragment(andFragment);
                continue;
            }
            if (trimmed.startsWith("@OR")) {
                Matcher orMatcher = OR_PATTERN.matcher(trimmed);
                if (!orMatcher.matches()) {
                    throw new IllegalArgumentException("@OR found with invalid format: " + line);
                }
                OrSqlFragment orFragment = new OrSqlFragment(orMatcher.group(1), this.extractVariable(orMatcher.group(2)));
                this.parseContainerSection(orFragment, lineIterator, line.indent());
                if (orFragment.getFragments().size() == 0) {
                    throw new IllegalArgumentException("@OR found with no subsequent indented lines: " + line);
                }
                container.addFragment(orFragment);
                continue;
            }
            if (trimmed.startsWith("@IF")) {
                Matcher ifMatcher = IF_PATTERN.matcher(trimmed);
                if (!ifMatcher.matches()) {
                    throw new IllegalArgumentException("@IF found with invalid format: " + line);
                }
                IfSqlFragment ifFragment = new IfSqlFragment(ifMatcher.group(1), this.extractVariable(ifMatcher.group(2)));
                this.parseContainerSection(ifFragment, lineIterator, line.indent());
                if (ifFragment.getFragments().size() == 0) {
                    throw new IllegalArgumentException("@IF found with no subsequent indented lines: " + line);
                }
                container.addFragment(ifFragment);
                continue;
            }
            if (trimmed.startsWith("@LOOP")) {
                if (trimmed.startsWith("@LOOPINDEX") || trimmed.startsWith("@LOOPJOIN")) {
                    this.parseLine(container, line);
                    continue;
                }
                Matcher loopMatcher = LOOP_PATTERN.matcher(trimmed);
                if (!loopMatcher.matches()) {
                    throw new IllegalArgumentException("@LOOP found with invalid format: " + line);
                }
                LoopSqlFragment loopFragment = new LoopSqlFragment(loopMatcher.group(1));
                this.parseContainerSection(loopFragment, lineIterator, line.indent());
                if (loopFragment.getFragments().size() == 0) {
                    throw new IllegalArgumentException("@LOOP found with no subsequent indented lines: " + line);
                }
                container.addFragment(loopFragment);
                continue;
            }
            this.parseLine(container, line);
        }
    }

    private String extractVariable(String text) {
        if (text == null) {
            return null;
        }
        if ((text = text.trim()).startsWith("=")) {
            return this.extractVariable(text.substring(1));
        }
        return text;
    }

    private void parseLine(ContainerSqlFragment container, Line line) {
        String trimmed = line.lineTrimmed();
        if (trimmed.length() == 0) {
            return;
        }
        if (trimmed.contains("@INCLUDE")) {
            this.parseIncludeTag(container, line);
        } else if (trimmed.contains("@LIKE")) {
            this.parseOperatorTag(container, line, "@LIKE");
        } else if (trimmed.contains("@EQUALS")) {
            this.parseOperatorTag(container, line, "@EQUALS");
        } else if (trimmed.contains("@OFFSETFETCH")) {
            this.parseOffsetFetchTag(container, line);
        } else if (trimmed.contains("@FETCH")) {
            this.parseFetchTag(container, line);
        } else if (trimmed.contains("@VALUE")) {
            this.parseValueTag(container, line);
        } else if (trimmed.contains("@LOOPJOIN")) {
            TextSqlFragment textFragment = new TextSqlFragment(trimmed, line.endOfLine());
            container.addFragment(textFragment);
        } else {
            if (trimmed.startsWith("@")) {
                throw new IllegalArgumentException("Unknown tag at start of line: " + line);
            }
            TextSqlFragment textFragment = new TextSqlFragment(trimmed, line.endOfLine());
            container.addFragment(textFragment);
        }
    }

    private void parseIncludeTag(ContainerSqlFragment container, Line line) {
        Line[] split = line.split(line.lineTrimmed().indexOf("@INCLUDE"));
        this.parseLine(container, split[0]);
        String trimmed = split[1].lineTrimmed();
        Matcher matcher = INCLUDE_PATTERN.matcher(trimmed);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("@INCLUDE found with invalid format: " + line);
        }
        IncludeSqlFragment includeFragment = new IncludeSqlFragment(matcher.group(1));
        container.addFragment(includeFragment);
        Line subLine = split[1].splitRemainder(matcher.start(2));
        this.parseLine(container, subLine);
    }

    private void parseOperatorTag(ContainerSqlFragment container, Line line, String tagName) {
        Line[] split = line.split(line.lineTrimmed().indexOf(tagName));
        this.parseLine(container, split[0]);
        String trimmed = split[1].lineTrimmed();
        String content = trimmed.substring(tagName.length());
        String endTag = "@END" + tagName.substring(1);
        int end = trimmed.indexOf(endTag);
        int remainderIndex = trimmed.length();
        if (end >= 0) {
            content = trimmed.substring(tagName.length(), end);
            remainderIndex = end + endTag.length();
        }
        TextSqlFragment contentTextFragment = new TextSqlFragment(content, line.endOfLine());
        Matcher matcher = OPERATOR_VARIABLE_PATTERN.matcher(content);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(tagName + " found with invalid format: " + line);
        }
        String variable = matcher.group(2);
        OperatorSqlFragment operatorFragment = tagName.equals("@LIKE") ? new LikeSqlFragment(variable) : new EqualsSqlFragment(variable);
        container.addFragment(operatorFragment);
        operatorFragment.addFragment(contentTextFragment);
        Line subLine = split[1].splitRemainder(remainderIndex);
        this.parseLine(container, subLine);
    }

    private void parseOffsetFetchTag(ContainerSqlFragment container, Line line) {
        Line[] split = line.split(line.lineTrimmed().indexOf("@OFFSETFETCH"));
        this.parseLine(container, split[0]);
        String trimmed = split[1].lineTrimmed();
        String offsetVariable = ":paging_offset";
        String fetchVariable = ":paging_fetch";
        int remainderIndex = 12;
        if (trimmed.startsWith("@OFFSETFETCH(")) {
            Matcher matcher = OFFSET_FETCH_PATTERN.matcher(trimmed);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("@OFFSETFETCH found with invalid format: " + line);
            }
            offsetVariable = matcher.group(1);
            fetchVariable = matcher.group(2);
            remainderIndex = matcher.start(3);
        }
        OffsetFetchSqlFragment pagingFragment = new OffsetFetchSqlFragment(offsetVariable, fetchVariable);
        container.addFragment(pagingFragment);
        Line subLine = split[1].splitRemainder(remainderIndex);
        this.parseLine(container, subLine);
    }

    private void parseFetchTag(ContainerSqlFragment container, Line line) {
        Line[] split = line.split(line.lineTrimmed().indexOf("@FETCH"));
        this.parseLine(container, split[0]);
        String trimmed = split[1].lineTrimmed();
        String fetchVariable = ":paging_fetch";
        int remainderIndex = 6;
        if (trimmed.startsWith("@FETCH(")) {
            Matcher matcherVariable = FETCH_PATTERN.matcher(trimmed);
            if (matcherVariable.matches()) {
                fetchVariable = matcherVariable.group(1);
                remainderIndex = matcherVariable.start(2);
            } else {
                throw new IllegalArgumentException("@FETCH found with invalid format: " + line);
            }
        }
        OffsetFetchSqlFragment pagingFragment = new OffsetFetchSqlFragment(fetchVariable);
        container.addFragment(pagingFragment);
        Line subLine = split[1].splitRemainder(remainderIndex);
        this.parseLine(container, subLine);
    }

    private void parseValueTag(ContainerSqlFragment container, Line line) {
        Line[] split = line.split(line.lineTrimmed().indexOf("@VALUE"));
        this.parseLine(container, split[0]);
        Line lineStartingAtTag = split[1];
        Matcher matcher = VALUE_PATTERN.matcher(lineStartingAtTag.lineTrimmed());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("@VALUE found with invalid format: " + line);
        }
        String followingSpaces = matcher.group(2);
        Line subLine = lineStartingAtTag.splitRemainder(matcher.start(3));
        boolean followWithSpace = followingSpaces != null && followingSpaces.length() > 0 || subLine.lineTrimmed().isEmpty();
        ValueSqlFragment valueFragment = new ValueSqlFragment(matcher.group(1), followWithSpace);
        container.addFragment(valueFragment);
        this.parseLine(container, subLine);
    }

    static final class Line {
        private final String _line;
        private final String _trimmed;
        private final int _lineNumber;
        private final boolean _endOfLine;

        Line(String line, int lineNumber) {
            this._line = line;
            int commentPos = line.indexOf("--");
            this._trimmed = commentPos >= 0 ? line.substring(0, commentPos).trim() : line.trim();
            this._lineNumber = lineNumber;
            this._endOfLine = true;
        }

        Line(String line, String trimmed, int lineNumber, boolean endOfLine) {
            this._line = line;
            this._trimmed = trimmed;
            this._lineNumber = lineNumber;
            this._endOfLine = endOfLine;
        }

        String line() {
            return this._line;
        }

        String lineTrimmed() {
            return this._trimmed;
        }

        int lineNumber() {
            return this._lineNumber;
        }

        boolean endOfLine() {
            return this._endOfLine;
        }

        boolean containsTab() {
            return this._line.contains("\t");
        }

        boolean isComment() {
            return this._trimmed.startsWith("--") || this._trimmed.length() == 0;
        }

        int indent() {
            for (int i = 0; i < this._line.length(); ++i) {
                if (this._line.charAt(i) == ' ') continue;
                return i;
            }
            return this._line.length();
        }

        Line[] split(int trimmedIndex) {
            String before = this._trimmed.substring(0, trimmedIndex);
            String after = this._trimmed.substring(trimmedIndex);
            return new Line[]{new Line(before, before, this._lineNumber, false), new Line(after, after, this._lineNumber, this._endOfLine)};
        }

        Line splitRemainder(int trimmedIndex) {
            String after = this._trimmed.substring(trimmedIndex);
            return new Line(after, after, this._lineNumber, this._endOfLine);
        }

        public String toString() {
            return "Line " + this.lineNumber();
        }
    }
}

