/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.transforms;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.json.JsonConverterConfig;
import org.apache.kafka.connect.storage.ConverterType;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaAndStructToJsonTransform<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaAndStructToJsonTransform.class);
    private JsonConverter jsonConverter;

    public R apply(R r) {
        LOG.debug("Incoming record: {}", r);
        if (r.value() != null && r.valueSchema() != null) {
            byte[] json = this.jsonConverter.fromConnectData(r.topic(), r.valueSchema(), r.value());
            if (json == null) {
                LOG.warn("No record was converted as part of this transformation, resulting json byte[] was null.");
                return r;
            }
            LOG.debug("Json created: {}", (Object)new String(json));
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), r.keySchema(), r.key(), Schema.BYTES_SCHEMA, (Object)json, r.timestamp());
        }
        LOG.debug("Incoming record with a null value or a null schema, nothing to be done.");
        return r;
    }

    public ConfigDef config() {
        return JsonConverterConfig.configDef();
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        this.jsonConverter = new JsonConverter();
        HashMap conf = new HashMap(configs);
        conf.put("converter.type", ConverterType.VALUE.getName());
        this.jsonConverter.configure(conf);
    }
}

