/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.converter;

import io.apicurio.registry.utils.converter.SchemalessConverter;
import io.apicurio.registry.utils.converter.avro.AvroData;
import io.apicurio.registry.utils.converter.avro.AvroDataConfig;
import io.apicurio.registry.utils.serde.AvroKafkaDeserializer;
import io.apicurio.registry.utils.serde.AvroKafkaSerializer;
import io.apicurio.registry.utils.serde.avro.NonRecordContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.generic.GenericContainer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;

public class AvroConverter<T>
extends SchemalessConverter<T> {
    private AvroData avroData;

    public AvroConverter() {
    }

    public AvroConverter(AvroKafkaSerializer<T> serializer, AvroKafkaDeserializer<T> deserializer, AvroData avroData) {
        super(serializer, deserializer);
        this.avroData = Objects.requireNonNull(avroData);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        HashMap copy = new HashMap(configs);
        copy.putIfAbsent("apicurio.registry.converter.serializer", new AvroKafkaSerializer());
        copy.putIfAbsent("apicurio.registry.converter.deserializer", new AvroKafkaDeserializer());
        super.configure(copy, isKey);
        this.avroData = new AvroData(new AvroDataConfig(copy));
    }

    @Override
    protected T applySchema(Schema schema, Object value) {
        return (T)this.avroData.fromConnectData(schema, value);
    }

    @Override
    protected SchemaAndValue toSchemaAndValue(T result) {
        if (result instanceof GenericContainer) {
            GenericContainer container;
            Object value = container = (GenericContainer)result;
            Integer version = null;
            if (result instanceof NonRecordContainer) {
                NonRecordContainer nrc = (NonRecordContainer)result;
                value = nrc.getValue();
            }
            return this.avroData.toConnectData(container.getSchema(), value, version);
        }
        return new SchemaAndValue(null, result);
    }

    @Override
    protected Class<? extends Serializer> serializerClass() {
        return AvroKafkaSerializer.class;
    }

    @Override
    protected Class<? extends Deserializer> deserializerClass() {
        return AvroKafkaDeserializer.class;
    }

    public AvroKafkaSerializer<T> getSerializer() {
        return (AvroKafkaSerializer)this.serializer;
    }

    public AvroKafkaDeserializer<T> getDeserializer() {
        return (AvroKafkaDeserializer)this.deserializer;
    }
}

