/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.schema.validation;

import com.worldturner.medeia.api.FailedValidationResult;
import com.worldturner.medeia.api.FormatValidation;
import com.worldturner.medeia.api.OkValidationResult;
import com.worldturner.medeia.api.ValidationResult;
import com.worldturner.medeia.format.HostnameKt;
import com.worldturner.medeia.format.Idn_hostnameKt;
import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.pointer.JsonPointer;
import com.worldturner.medeia.pointer.RelativeJsonPointer;
import com.worldturner.medeia.schema.validation.FormatValidatorKt;
import com.worldturner.medeia.schema.validation.SchemaValidator;
import com.worldturner.medeia.schema.validation.stream.SchemaValidatorInstance;
import java.net.URI;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J&\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0002J\"\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lcom/worldturner/medeia/schema/validation/FormatValidator;", "Lcom/worldturner/medeia/schema/validation/SchemaValidator;", "Lcom/worldturner/medeia/schema/validation/stream/SchemaValidatorInstance;", "format", "", "customFormats", "", "Lcom/worldturner/medeia/api/FormatValidation;", "(Ljava/lang/String;Ljava/util/Map;)V", "getCustomFormats", "()Ljava/util/Map;", "getFormat", "()Ljava/lang/String;", "createInstance", "startLevel", "", "failedValidation", "Lcom/worldturner/medeia/api/FailedValidationResult;", "value", "", "location", "Lcom/worldturner/medeia/parser/JsonTokenLocation;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "recordUnknownRefs", "", "unknownRefs", "", "Ljava/net/URI;", "validate", "Lcom/worldturner/medeia/api/ValidationResult;", "token", "Lcom/worldturner/medeia/parser/JsonTokenData;", "Companion", "medeia-validator-core"})
public final class FormatValidator
implements SchemaValidator,
SchemaValidatorInstance {
    @NotNull
    private final String format;
    @NotNull
    private final Map<String, FormatValidation> customFormats;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public SchemaValidatorInstance createInstance(int startLevel) {
        return this;
    }

    @Override
    public void recordUnknownRefs(@NotNull Collection<URI> unknownRefs) {
        Intrinsics.checkParameterIsNotNull(unknownRefs, (String)"unknownRefs");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public ValidationResult validate(@NotNull JsonTokenData token, @NotNull JsonTokenLocation location) {
        ValidationResult validationResult;
        FormatValidation customValidation;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        FormatValidation formatValidation = customValidation = this.customFormats.get(this.format);
        if (formatValidation != null) {
            ValidationResult validationResult2;
            FormatValidation formatValidation2;
            FormatValidation it = formatValidation2 = formatValidation;
            boolean bl = false;
            Object value = token.toValue();
            String result = it.validate(value, this.format);
            Object object = result;
            if (object != null) {
                String string;
                String it2 = string = object;
                boolean bl2 = false;
                object = this.failedValidation(value, location, it2);
                if (object != null) {
                    validationResult2 = (ValidationResult)object;
                    return validationResult2;
                }
            }
            validationResult2 = OkValidationResult.INSTANCE;
            return validationResult2;
        }
        if (token.getType() != JsonTokenType.VALUE_TEXT) {
            return OkValidationResult.INSTANCE;
        }
        String string = token.getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = string;
        switch (this.format) {
            case "regex": {
                void var6_12;
                try {
                    Regex regex;
                    Regex it = regex = new Regex(string2);
                    boolean bl = false;
                    ValidationResult validationResult3 = OkValidationResult.INSTANCE;
                }
                catch (PatternSyntaxException e) {
                    ValidationResult validationResult4 = this.failedValidation((Object)string2, location, e);
                }
                validationResult = var6_12;
                return validationResult;
            }
            case "iri": 
            case "uri": {
                void var6_16;
                try {
                    URI uRI;
                    URI uRI2 = uRI = URI.create(string2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)uRI2, (String)"uri");
                    ValidationResult validationResult5 = uRI2.isAbsolute() ? (ValidationResult)OkValidationResult.INSTANCE : (ValidationResult)this.failedValidation(string2, location);
                }
                catch (IllegalArgumentException e) {
                    ValidationResult validationResult6 = this.failedValidation((Object)string2, location, e);
                }
                validationResult = var6_16;
                return validationResult;
            }
            case "uri-reference": 
            case "iri-reference": {
                void var6_20;
                try {
                    URI uRI;
                    URI it = uRI = URI.create(string2);
                    boolean bl = false;
                    ValidationResult validationResult7 = OkValidationResult.INSTANCE;
                }
                catch (IllegalArgumentException e) {
                    ValidationResult validationResult8 = this.failedValidation((Object)string2, location, e);
                }
                validationResult = var6_20;
                return validationResult;
            }
            case "json-pointer": {
                void var6_24;
                try {
                    JsonPointer jsonPointer;
                    JsonPointer it = jsonPointer = new JsonPointer(string2, false, 2, null);
                    boolean bl = false;
                    ValidationResult validationResult9 = OkValidationResult.INSTANCE;
                }
                catch (IllegalArgumentException e) {
                    ValidationResult validationResult10 = this.failedValidation((Object)string2, location, e);
                }
                validationResult = var6_24;
                return validationResult;
            }
            case "relative-json-pointer": {
                void var6_28;
                try {
                    RelativeJsonPointer relativeJsonPointer;
                    RelativeJsonPointer it = relativeJsonPointer = new RelativeJsonPointer(string2);
                    boolean bl = false;
                    ValidationResult validationResult11 = OkValidationResult.INSTANCE;
                }
                catch (IllegalArgumentException e) {
                    ValidationResult validationResult12 = this.failedValidation((Object)string2, location, e);
                }
                validationResult = var6_28;
                return validationResult;
            }
            case "date": {
                void var6_32;
                try {
                    LocalDate localDate;
                    LocalDate it = localDate = LocalDate.parse(string2);
                    boolean bl = false;
                    ValidationResult validationResult13 = OkValidationResult.INSTANCE;
                }
                catch (DateTimeParseException e) {
                    ValidationResult validationResult14 = this.failedValidation((Object)string2, location, e);
                }
                validationResult = var6_32;
                return validationResult;
            }
            case "time": {
                void var6_36;
                try {
                    OffsetTime offsetTime;
                    OffsetTime it = offsetTime = OffsetTime.parse(string2);
                    boolean bl = false;
                    ValidationResult validationResult15 = OkValidationResult.INSTANCE;
                }
                catch (DateTimeParseException e) {
                    ValidationResult validationResult16 = this.failedValidation((Object)string2, location, e);
                }
                validationResult = var6_36;
                return validationResult;
            }
            case "date-time": {
                void var6_40;
                try {
                    OffsetDateTime offsetDateTime;
                    OffsetDateTime it = offsetDateTime = OffsetDateTime.parse(string2);
                    boolean bl = false;
                    ValidationResult validationResult17 = OkValidationResult.INSTANCE;
                }
                catch (DateTimeParseException e) {
                    ValidationResult validationResult18 = this.failedValidation((Object)string2, location, e);
                }
                validationResult = var6_40;
                return validationResult;
            }
            case "ipv4": {
                if (FormatValidatorKt.access$isIpv4(string2)) {
                    validationResult = OkValidationResult.INSTANCE;
                    return validationResult;
                }
                validationResult = this.failedValidation(string2, location);
                return validationResult;
            }
            case "ipv6": {
                if (FormatValidatorKt.access$isIpv6(string2)) {
                    validationResult = OkValidationResult.INSTANCE;
                    return validationResult;
                }
                validationResult = this.failedValidation(string2, location);
                return validationResult;
            }
            case "hostname": {
                if (HostnameKt.isHostname(string2)) {
                    validationResult = OkValidationResult.INSTANCE;
                    return validationResult;
                }
                validationResult = this.failedValidation(string2, location);
                return validationResult;
            }
            case "idn-hostname": {
                if (Idn_hostnameKt.isIdnHostname(string2)) {
                    validationResult = OkValidationResult.INSTANCE;
                    return validationResult;
                }
                validationResult = this.failedValidation(string2, location);
                return validationResult;
            }
        }
        validationResult = OkValidationResult.INSTANCE;
        return validationResult;
    }

    private final FailedValidationResult failedValidation(Object value, JsonTokenLocation location, String msg) {
        Collection collection = null;
        String string = "Invalid " + this.format + " '" + value + "': " + msg;
        String string2 = "format";
        String string3 = null;
        JsonTokenLocation jsonTokenLocation = location;
        return new FailedValidationResult(string2, string3, string, jsonTokenLocation, collection, 18, null);
    }

    private final FailedValidationResult failedValidation(Object value, JsonTokenLocation location) {
        Collection collection = null;
        String string = "Invalid " + this.format + " '" + value + '\'';
        String string2 = "format";
        String string3 = null;
        JsonTokenLocation jsonTokenLocation = location;
        return new FailedValidationResult(string2, string3, string, jsonTokenLocation, collection, 18, null);
    }

    private final FailedValidationResult failedValidation(Object value, JsonTokenLocation location, Exception e) {
        Object object;
        block3: {
            block2: {
                String string;
                object = e.getMessage();
                if (object == null) break block2;
                String it = string = object;
                boolean bl = false;
                object = this.failedValidation(value, location, it);
                if (object != null) break block3;
            }
            object = this.failedValidation(value, location);
        }
        return object;
    }

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    @NotNull
    public final Map<String, FormatValidation> getCustomFormats() {
        return this.customFormats;
    }

    public FormatValidator(@NotNull String format, @NotNull Map<String, ? extends FormatValidation> customFormats) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull(customFormats, (String)"customFormats");
        this.format = format;
        this.customFormats = customFormats;
    }

    public /* synthetic */ FormatValidator(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, map);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"Lcom/worldturner/medeia/schema/validation/FormatValidator$Companion;", "", "()V", "create", "Lcom/worldturner/medeia/schema/validation/FormatValidator;", "format", "", "customFormats", "", "Lcom/worldturner/medeia/api/FormatValidation;", "medeia-validator-core"})
    public static final class Companion {
        @Nullable
        public final FormatValidator create(@Nullable String format, @NotNull Map<String, ? extends FormatValidation> customFormats) {
            FormatValidator formatValidator;
            Intrinsics.checkParameterIsNotNull(customFormats, (String)"customFormats");
            String string = format;
            if (string != null) {
                String string2;
                String it = string2 = string;
                boolean bl = false;
                formatValidator = new FormatValidator(format, customFormats);
            } else {
                formatValidator = null;
            }
            return formatValidator;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

