/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExchangeConstantProvider;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.impl.engine.DefaultContextPluginManager;
import org.apache.camel.impl.engine.DefaultManagementStrategyFactory;
import org.apache.camel.impl.engine.ExplicitCamelContextNameStrategy;
import org.apache.camel.impl.engine.HashMapHeadersMapFactory;
import org.apache.camel.impl.engine.InternalRouteController;
import org.apache.camel.spi.BootstrapCloseable;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.EndpointServiceRegistry;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExchangeFactoryManager;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.ManagementStrategyFactory;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.PluginManager;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.spi.RestRegistryFactory;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.NormalizedUri;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.startup.DefaultStartupStepRecorder;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultCamelContextExtension
implements ExtendedCamelContext {
    private final AbstractCamelContext camelContext;
    private final ThreadLocal<String> isCreateRoute = new ThreadLocal();
    private final ThreadLocal<String> isCreateProcessor = new ThreadLocal();
    private final ThreadLocal<Boolean> isSetupRoutes = new ThreadLocal();
    private final List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private final Map<String, FactoryFinder> factories = new ConcurrentHashMap<String, FactoryFinder>();
    private final Map<String, FactoryFinder> bootstrapFactories = new ConcurrentHashMap<String, FactoryFinder>();
    private final Set<LogListener> logListeners = new LinkedHashSet<LogListener>();
    private final PluginManager pluginManager = new DefaultContextPluginManager();
    private final RouteController internalRouteController;
    private final List<BootstrapCloseable> bootstraps = new CopyOnWriteArrayList<BootstrapCloseable>();
    private volatile String description;
    private volatile String profile;
    private volatile ExchangeFactory exchangeFactory;
    private volatile ExchangeFactoryManager exchangeFactoryManager;
    private volatile ProcessorExchangeFactory processorExchangeFactory;
    private volatile ReactiveExecutor reactiveExecutor;
    private volatile Registry registry;
    private volatile ManagementStrategy managementStrategy;
    private volatile ManagementMBeanAssembler managementMBeanAssembler;
    private volatile HeadersMapFactory headersMapFactory;
    private volatile boolean eventNotificationApplicable;
    private volatile CamelContextNameStrategy nameStrategy;
    private volatile ManagementNameStrategy managementNameStrategy;
    private volatile PropertiesComponent propertiesComponent;
    private volatile RestRegistryFactory restRegistryFactory;
    private volatile RestConfiguration restConfiguration;
    private volatile RestRegistry restRegistry;
    private volatile ClassResolver classResolver;
    private volatile MessageHistoryFactory messageHistoryFactory;
    private volatile StreamCachingStrategy streamCachingStrategy;
    private volatile InflightRepository inflightRepository;
    private volatile UuidGenerator uuidGenerator;
    private volatile Tracer tracer;
    private volatile TransformerRegistry transformerRegistry;
    private volatile ValidatorRegistry validatorRegistry;
    private volatile TypeConverterRegistry typeConverterRegistry;
    private volatile EndpointServiceRegistry endpointServiceRegistry;
    private volatile TypeConverter typeConverter;
    private volatile RouteController routeController;
    private volatile ShutdownStrategy shutdownStrategy;
    private volatile ExecutorServiceManager executorServiceManager;
    private volatile Injector injector;
    private volatile StartupStepRecorder startupStepRecorder = new DefaultStartupStepRecorder();
    @Deprecated(since="3.17.0")
    private ErrorHandlerFactory errorHandlerFactory;
    private String basePackageScan;
    private final Lock lock = new ReentrantLock();
    private volatile FactoryFinder bootstrapFactoryFinder;

    public DefaultCamelContextExtension(AbstractCamelContext camelContext) {
        this.camelContext = camelContext;
        this.internalRouteController = new InternalRouteController(camelContext);
    }

    public byte getStatusPhase() {
        return this.camelContext.getStatusPhase();
    }

    public String getName() {
        return this.camelContext.getNameStrategy().getName();
    }

    CamelContextNameStrategy getNameStrategy() {
        if (this.nameStrategy == null) {
            this.lock.lock();
            try {
                if (this.nameStrategy == null) {
                    this.setNameStrategy(this.camelContext.createCamelContextNameStrategy());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.nameStrategy;
    }

    void setNameStrategy(CamelContextNameStrategy nameStrategy) {
        this.nameStrategy = this.camelContext.getInternalServiceManager().addService(this.camelContext, nameStrategy);
    }

    ManagementNameStrategy getManagementNameStrategy() {
        if (this.managementNameStrategy == null) {
            this.lock.lock();
            try {
                if (this.managementNameStrategy == null) {
                    this.setManagementNameStrategy(this.camelContext.createManagementNameStrategy());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.managementNameStrategy;
    }

    void setManagementNameStrategy(ManagementNameStrategy managementNameStrategy) {
        this.managementNameStrategy = this.camelContext.getInternalServiceManager().addService(this.camelContext, managementNameStrategy);
    }

    PropertiesComponent getPropertiesComponent() {
        if (this.propertiesComponent == null) {
            this.lock.lock();
            try {
                if (this.propertiesComponent == null) {
                    this.setPropertiesComponent(this.camelContext.createPropertiesComponent());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.propertiesComponent;
    }

    void setPropertiesComponent(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = this.camelContext.getInternalServiceManager().addService(this.camelContext, propertiesComponent);
    }

    public void setName(String name) {
        this.camelContext.setNameStrategy(new ExplicitCamelContextNameStrategy(name));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public Endpoint hasEndpoint(NormalizedEndpointUri uri) {
        return (Endpoint)this.camelContext.getEndpointRegistry().get((Object)uri);
    }

    public NormalizedEndpointUri normalizeUri(String uri) {
        try {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)this.camelContext, (String)uri);
            return NormalizedUri.newNormalizedUri((String)uri, (boolean)false);
        }
        catch (ResolveEndpointFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
    }

    public Endpoint getEndpoint(NormalizedEndpointUri uri) {
        return this.camelContext.doGetEndpoint(uri.getUri(), null, true, false);
    }

    public Endpoint getPrototypeEndpoint(String uri) {
        return this.camelContext.doGetEndpoint(uri, null, false, true);
    }

    public Endpoint getPrototypeEndpoint(NormalizedEndpointUri uri) {
        return this.camelContext.doGetEndpoint(uri.getUri(), null, true, true);
    }

    public Endpoint getEndpoint(NormalizedEndpointUri uri, Map<String, Object> parameters) {
        return this.camelContext.doGetEndpoint(uri.getUri(), parameters, true, false);
    }

    public void registerEndpointCallback(EndpointStrategy strategy) {
        if (this.camelContext.getEndpointStrategies().add(strategy)) {
            for (Endpoint endpoint : this.camelContext.getEndpoints()) {
                Endpoint newEndpoint = strategy.registerEndpoint(endpoint.getEndpointUri(), endpoint);
                if (newEndpoint == null) continue;
                this.camelContext.getEndpointRegistry().put((Object)this.camelContext.getEndpointKey(endpoint.getEndpointUri()), (Object)newEndpoint);
            }
        }
    }

    public List<RouteStartupOrder> getRouteStartupOrder() {
        return this.camelContext.getRouteStartupOrder();
    }

    public boolean isSetupRoutes() {
        Boolean answer = this.isSetupRoutes.get();
        return answer != null && answer != false;
    }

    public String getCreateRoute() {
        return this.isCreateRoute.get();
    }

    public String getCreateProcessor() {
        return this.isCreateProcessor.get();
    }

    public void addBootstrap(BootstrapCloseable bootstrap) {
        this.bootstraps.add(bootstrap);
    }

    void closeBootstraps() {
        for (BootstrapCloseable bootstrap : this.bootstraps) {
            try {
                bootstrap.close();
            }
            catch (Exception e) {
                DefaultCamelContextExtension.logger().warn("Error during closing bootstrap. This exception is ignored.", (Throwable)e);
            }
        }
        this.bootstraps.clear();
    }

    List<BootstrapCloseable> getBootstraps() {
        return this.bootstraps;
    }

    public List<Service> getServices() {
        return this.camelContext.getInternalServiceManager().getServices();
    }

    public String resolvePropertyPlaceholders(String text, boolean keepUnresolvedOptional) {
        if (text != null && text.contains("{{")) {
            String answer = this.camelContext.getPropertiesComponent().parseUri(text, keepUnresolvedOptional);
            DefaultCamelContextExtension.logger().debug("Resolved text: {} -> {}", (Object)text, (Object)answer);
            return answer;
        }
        if (text != null && text.startsWith("Exchange.")) {
            String field = StringHelper.after((String)text, (String)"Exchange.");
            String constant = ExchangeConstantProvider.lookup((String)field);
            if (constant != null) {
                DefaultCamelContextExtension.logger().debug("Resolved constant: {} -> {}", (Object)text, (Object)constant);
                return constant;
            }
            throw new IllegalArgumentException("Constant field with name: " + field + " not found on Exchange.class");
        }
        return text;
    }

    public ManagementMBeanAssembler getManagementMBeanAssembler() {
        return this.managementMBeanAssembler;
    }

    public void setManagementMBeanAssembler(ManagementMBeanAssembler managementMBeanAssembler) {
        this.managementMBeanAssembler = this.camelContext.getInternalServiceManager().addService(this.camelContext, managementMBeanAssembler, false);
    }

    void stopRegistry() {
        ServiceHelper.stopService((Object)this.registry);
    }

    public Registry getRegistry() {
        if (this.registry == null) {
            this.lock.lock();
            try {
                if (this.registry == null) {
                    this.setRegistry(this.camelContext.createRegistry());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        CamelContextAware.trySetCamelContext((Object)registry, (CamelContext)this.camelContext);
        this.registry = registry;
    }

    public void createRoute(String routeId) {
        if (routeId != null) {
            this.isCreateRoute.set(routeId);
        } else {
            this.isSetupRoutes.remove();
        }
    }

    public void createProcessor(String processorId) {
        if (processorId != null) {
            this.isCreateProcessor.set(processorId);
        } else {
            this.isCreateProcessor.remove();
        }
    }

    public void setupRoutes(boolean done) {
        if (done) {
            this.isSetupRoutes.remove();
        } else {
            this.isSetupRoutes.set(true);
        }
    }

    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        if (!this.interceptStrategies.contains(interceptStrategy)) {
            this.interceptStrategies.add(interceptStrategy);
        }
    }

    public Set<LogListener> getLogListeners() {
        return this.logListeners;
    }

    public void addLogListener(LogListener listener) {
        CamelContextAware.trySetCamelContext((Object)listener, (CamelContext)this.camelContext);
        this.logListeners.add(listener);
    }

    public ErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    public boolean isEventNotificationApplicable() {
        return this.eventNotificationApplicable;
    }

    public void setEventNotificationApplicable(boolean eventNotificationApplicable) {
        this.eventNotificationApplicable = eventNotificationApplicable;
    }

    public FactoryFinder getDefaultFactoryFinder() {
        return this.getFactoryFinder("META-INF/services/org/apache/camel/");
    }

    public void setDefaultFactoryFinder(FactoryFinder factoryFinder) {
        this.factories.put("META-INF/services/org/apache/camel/", factoryFinder);
    }

    public FactoryFinder getBootstrapFactoryFinder() {
        if (this.bootstrapFactoryFinder == null) {
            this.lock.lock();
            try {
                if (this.bootstrapFactoryFinder == null) {
                    this.bootstrapFactoryFinder = PluginHelper.getFactoryFinderResolver((ExtendedCamelContext)this).resolveBootstrapFactoryFinder(this.camelContext.getClassResolver());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.bootstrapFactoryFinder;
    }

    public void setBootstrapFactoryFinder(FactoryFinder factoryFinder) {
        this.bootstrapFactoryFinder = factoryFinder;
    }

    public FactoryFinder getBootstrapFactoryFinder(String path) {
        return this.bootstrapFactories.computeIfAbsent(path, this.camelContext::createBootstrapFactoryFinder);
    }

    public FactoryFinder getFactoryFinder(String path) {
        return this.factories.computeIfAbsent(path, this.camelContext::createFactoryFinder);
    }

    public void setupManagement(Map<String, Object> options) {
        DefaultCamelContextExtension.logger().trace("Setting up management");
        DefaultManagementStrategyFactory factory = null;
        if (!this.camelContext.isJMXDisabled()) {
            try {
                Object object;
                FactoryFinder finder = this.camelContext.createFactoryFinder("META-INF/services/org/apache/camel/management/");
                if (finder != null && (object = finder.newInstance("ManagementStrategyFactory").orElse(null)) instanceof ManagementStrategyFactory) {
                    ManagementStrategyFactory managementStrategyFactory = object;
                    factory = managementStrategyFactory;
                }
            }
            catch (Exception e) {
                DefaultCamelContextExtension.logger().warn("Cannot create JmxManagementStrategyFactory. Will fallback and disable JMX.", (Throwable)e);
            }
        }
        if (factory == null) {
            factory = new DefaultManagementStrategyFactory();
        }
        DefaultCamelContextExtension.logger().debug("Setting up management with factory: {}", (Object)factory);
        List notifiers = null;
        if (this.managementStrategy != null) {
            notifiers = this.managementStrategy.getEventNotifiers();
        }
        try {
            ManagementStrategy strategy = factory.create(this.camelContext.getCamelContextReference(), options);
            if (notifiers != null) {
                notifiers.forEach(arg_0 -> ((ManagementStrategy)strategy).addEventNotifier(arg_0));
            }
            LifecycleStrategy lifecycle = factory.createLifecycle(this.camelContext);
            factory.setupManagement(this.camelContext, strategy, lifecycle);
        }
        catch (Exception e) {
            DefaultCamelContextExtension.logger().warn("Error setting up management due {}", (Object)e.getMessage());
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public String getBasePackageScan() {
        return this.basePackageScan;
    }

    public void setBasePackageScan(String basePackageScan) {
        this.basePackageScan = basePackageScan;
    }

    public HeadersMapFactory getHeadersMapFactory() {
        return this.headersMapFactory;
    }

    public void setHeadersMapFactory(HeadersMapFactory headersMapFactory) {
        this.headersMapFactory = this.camelContext.getInternalServiceManager().addService(this.camelContext, headersMapFactory);
    }

    void initEagerMandatoryServices(boolean caseInsensitive, Supplier<HeadersMapFactory> headersMapFactorySupplier) {
        if (this.headersMapFactory == null) {
            this.lock.lock();
            try {
                if (this.headersMapFactory == null) {
                    if (caseInsensitive) {
                        this.setHeadersMapFactory(headersMapFactorySupplier.get());
                    } else {
                        this.setHeadersMapFactory(new HashMapHeadersMapFactory());
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public ExchangeFactory getExchangeFactory() {
        if (this.exchangeFactory == null) {
            this.lock.lock();
            try {
                if (this.exchangeFactory == null) {
                    this.setExchangeFactory(this.camelContext.createExchangeFactory());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.exchangeFactory;
    }

    public void setExchangeFactory(ExchangeFactory exchangeFactory) {
        exchangeFactory.setCamelContext((CamelContext)this.camelContext);
        this.exchangeFactory = exchangeFactory;
    }

    public ExchangeFactoryManager getExchangeFactoryManager() {
        if (this.exchangeFactoryManager == null) {
            this.lock.lock();
            try {
                if (this.exchangeFactoryManager == null) {
                    this.setExchangeFactoryManager(this.camelContext.createExchangeFactoryManager());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.exchangeFactoryManager;
    }

    public void setExchangeFactoryManager(ExchangeFactoryManager exchangeFactoryManager) {
        this.exchangeFactoryManager = this.camelContext.getInternalServiceManager().addService(this.camelContext, exchangeFactoryManager);
    }

    public ProcessorExchangeFactory getProcessorExchangeFactory() {
        if (this.processorExchangeFactory == null) {
            this.lock.lock();
            try {
                if (this.processorExchangeFactory == null) {
                    this.setProcessorExchangeFactory(this.camelContext.createProcessorExchangeFactory());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.processorExchangeFactory;
    }

    public void setProcessorExchangeFactory(ProcessorExchangeFactory processorExchangeFactory) {
        processorExchangeFactory.setCamelContext((CamelContext)this.camelContext);
        this.processorExchangeFactory = processorExchangeFactory;
    }

    public ReactiveExecutor getReactiveExecutor() {
        if (this.reactiveExecutor == null) {
            this.lock.lock();
            try {
                if (this.reactiveExecutor == null) {
                    this.setReactiveExecutor(this.camelContext.createReactiveExecutor());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.reactiveExecutor;
    }

    public void setReactiveExecutor(ReactiveExecutor reactiveExecutor) {
        this.reactiveExecutor = this.camelContext.getInternalServiceManager().addService(this.camelContext, reactiveExecutor, false);
    }

    RestRegistryFactory getRestRegistryFactory() {
        if (this.restRegistryFactory == null) {
            this.lock.lock();
            try {
                if (this.restRegistryFactory == null) {
                    this.setRestRegistryFactory(this.camelContext.createRestRegistryFactory());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.restRegistryFactory;
    }

    void setRestRegistryFactory(RestRegistryFactory restRegistryFactory) {
        this.restRegistryFactory = this.camelContext.getInternalServiceManager().addService(this.camelContext, restRegistryFactory);
    }

    RestRegistry getRestRegistry() {
        if (this.restRegistry == null) {
            this.lock.lock();
            try {
                if (this.restRegistry == null) {
                    this.setRestRegistry(this.camelContext.createRestRegistry());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.restRegistry;
    }

    void setRestRegistry(RestRegistry restRegistry) {
        this.restRegistry = this.camelContext.getInternalServiceManager().addService(this.camelContext, restRegistry);
    }

    RestConfiguration getRestConfiguration() {
        if (this.restConfiguration == null) {
            this.lock.lock();
            try {
                if (this.restConfiguration == null) {
                    this.setRestConfiguration(this.camelContext.createRestConfiguration());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.restConfiguration;
    }

    void setRestConfiguration(RestConfiguration restConfiguration) {
        this.restConfiguration = restConfiguration;
    }

    ClassResolver getClassResolver() {
        if (this.classResolver == null) {
            this.lock.lock();
            try {
                if (this.classResolver == null) {
                    this.setClassResolver(this.camelContext.createClassResolver());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.classResolver;
    }

    void setClassResolver(ClassResolver classResolver) {
        this.classResolver = this.camelContext.getInternalServiceManager().addService(this.camelContext, classResolver);
    }

    MessageHistoryFactory getMessageHistoryFactory() {
        if (this.messageHistoryFactory == null) {
            this.lock.lock();
            try {
                if (this.messageHistoryFactory == null) {
                    this.setMessageHistoryFactory(this.camelContext.createMessageHistoryFactory());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.messageHistoryFactory;
    }

    void setMessageHistoryFactory(MessageHistoryFactory messageHistoryFactory) {
        this.messageHistoryFactory = this.camelContext.getInternalServiceManager().addService(this.camelContext, messageHistoryFactory);
    }

    StreamCachingStrategy getStreamCachingStrategy() {
        if (this.streamCachingStrategy == null) {
            this.lock.lock();
            try {
                if (this.streamCachingStrategy == null) {
                    this.setStreamCachingStrategy(this.camelContext.createStreamCachingStrategy());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.streamCachingStrategy;
    }

    void setStreamCachingStrategy(StreamCachingStrategy streamCachingStrategy) {
        this.streamCachingStrategy = this.camelContext.getInternalServiceManager().addService(this.camelContext, streamCachingStrategy, true, false, true);
    }

    InflightRepository getInflightRepository() {
        if (this.inflightRepository == null) {
            this.lock.lock();
            try {
                if (this.inflightRepository == null) {
                    this.setInflightRepository(this.camelContext.createInflightRepository());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.inflightRepository;
    }

    void setInflightRepository(InflightRepository repository) {
        this.inflightRepository = this.camelContext.getInternalServiceManager().addService(this.camelContext, repository);
    }

    UuidGenerator getUuidGenerator() {
        if (this.uuidGenerator == null) {
            this.lock.lock();
            try {
                if (this.uuidGenerator == null) {
                    this.setUuidGenerator(this.camelContext.createUuidGenerator());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.uuidGenerator;
    }

    void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = this.camelContext.getInternalServiceManager().addService(this.camelContext, uuidGenerator);
    }

    Tracer getTracer() {
        if (this.tracer == null) {
            this.lock.lock();
            try {
                if (this.tracer == null) {
                    this.setTracer(this.camelContext.createTracer());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.tracer;
    }

    void setTracer(Tracer tracer) {
        this.tracer = this.camelContext.getInternalServiceManager().addService(this.camelContext, tracer, true, false, true);
    }

    TransformerRegistry getTransformerRegistry() {
        if (this.transformerRegistry == null) {
            this.lock.lock();
            try {
                if (this.transformerRegistry == null) {
                    this.setTransformerRegistry(this.camelContext.createTransformerRegistry());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.transformerRegistry;
    }

    void setTransformerRegistry(TransformerRegistry transformerRegistry) {
        this.transformerRegistry = this.camelContext.getInternalServiceManager().addService(this.camelContext, transformerRegistry);
    }

    public EndpointServiceRegistry getEndpointServiceRegistry() {
        if (this.endpointServiceRegistry == null) {
            this.lock.lock();
            try {
                if (this.endpointServiceRegistry == null) {
                    this.setEndpointServiceRegistry(this.camelContext.createEndpointServiceRegistry());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.endpointServiceRegistry;
    }

    public void setEndpointServiceRegistry(EndpointServiceRegistry endpointServiceRegistry) {
        this.endpointServiceRegistry = this.camelContext.getInternalServiceManager().addService(this.camelContext, endpointServiceRegistry);
    }

    ValidatorRegistry getValidatorRegistry() {
        if (this.validatorRegistry == null) {
            this.lock.lock();
            try {
                if (this.validatorRegistry == null) {
                    this.setValidatorRegistry(this.camelContext.createValidatorRegistry());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.validatorRegistry;
    }

    public void setValidatorRegistry(ValidatorRegistry validatorRegistry) {
        this.validatorRegistry = this.camelContext.getInternalServiceManager().addService(this.camelContext, validatorRegistry);
    }

    void stopTypeConverterRegistry() {
        ServiceHelper.stopService((Service)this.typeConverterRegistry);
    }

    void resetTypeConverterRegistry() {
        this.typeConverterRegistry = null;
    }

    TypeConverterRegistry getTypeConverterRegistry() {
        if (this.typeConverterRegistry == null) {
            this.lock.lock();
            try {
                if (this.typeConverterRegistry == null) {
                    this.setTypeConverterRegistry(this.camelContext.createTypeConverterRegistry());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeConverterRegistry;
    }

    void setTypeConverterRegistry(TypeConverterRegistry typeConverterRegistry) {
        this.typeConverterRegistry = this.camelContext.getInternalServiceManager().addService(this.camelContext, typeConverterRegistry);
        if (typeConverterRegistry instanceof TypeConverter) {
            TypeConverter newTypeConverter = (TypeConverter)typeConverterRegistry;
            this.setTypeConverter(newTypeConverter);
        }
    }

    void stopTypeConverter() {
        ServiceHelper.stopService((Object)this.typeConverter);
    }

    void resetTypeConverter() {
        this.typeConverter = null;
    }

    TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = this.camelContext.getInternalServiceManager().addService(this.camelContext, typeConverter);
    }

    TypeConverter getOrCreateTypeConverter() {
        if (this.typeConverter == null) {
            this.lock.lock();
            try {
                if (this.typeConverter == null) {
                    this.setTypeConverter(this.camelContext.createTypeConverter());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeConverter;
    }

    void resetInjector() {
        this.injector = null;
    }

    Injector getInjector() {
        if (this.injector == null) {
            this.lock.lock();
            try {
                if (this.injector == null) {
                    this.setInjector(this.camelContext.createInjector());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.injector;
    }

    void setInjector(Injector injector) {
        this.injector = this.camelContext.getInternalServiceManager().addService(this.camelContext, injector);
    }

    void stopAndShutdownRouteController() {
        ServiceHelper.stopAndShutdownService((Object)this.routeController);
    }

    RouteController getRouteController() {
        if (this.routeController == null) {
            this.lock.lock();
            try {
                if (this.routeController == null) {
                    this.setRouteController(this.camelContext.createRouteController());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.routeController;
    }

    void setRouteController(RouteController routeController) {
        this.routeController = this.camelContext.getInternalServiceManager().addService(this.camelContext, routeController);
    }

    ShutdownStrategy getShutdownStrategy() {
        if (this.shutdownStrategy == null) {
            this.lock.lock();
            try {
                if (this.shutdownStrategy == null) {
                    this.setShutdownStrategy(this.camelContext.createShutdownStrategy());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.shutdownStrategy;
    }

    void setShutdownStrategy(ShutdownStrategy shutdownStrategy) {
        this.shutdownStrategy = this.camelContext.getInternalServiceManager().addService(this.camelContext, shutdownStrategy);
    }

    ExecutorServiceManager getExecutorServiceManager() {
        if (this.executorServiceManager == null) {
            this.lock.lock();
            try {
                if (this.executorServiceManager == null) {
                    this.setExecutorServiceManager(this.camelContext.createExecutorServiceManager());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.executorServiceManager;
    }

    void setExecutorServiceManager(ExecutorServiceManager executorServiceManager) {
        this.executorServiceManager = this.camelContext.getInternalServiceManager().addService(this.camelContext, executorServiceManager, false);
    }

    public RouteController getInternalRouteController() {
        return this.internalRouteController;
    }

    public EndpointUriFactory getEndpointUriFactory(String scheme) {
        return PluginHelper.getUriFactoryResolver((ExtendedCamelContext)this).resolveFactory(scheme, (CamelContext)this.camelContext);
    }

    public StartupStepRecorder getStartupStepRecorder() {
        return this.startupStepRecorder;
    }

    public void setStartupStepRecorder(StartupStepRecorder startupStepRecorder) {
        this.startupStepRecorder = startupStepRecorder;
    }

    public void addRoute(Route route) {
        this.camelContext.addRoute(route);
    }

    public void removeRoute(Route route) {
        this.camelContext.removeRoute(route);
    }

    public Processor createErrorHandler(Route route, Processor processor) throws Exception {
        return this.camelContext.createErrorHandler(route, processor);
    }

    public void disposeModel() {
    }

    public String getTestExcludeRoutes() {
        return this.camelContext.getTestExcludeRoutes();
    }

    ManagementStrategy getManagementStrategy() {
        return this.managementStrategy;
    }

    void setManagementStrategy(ManagementStrategy managementStrategy) {
        this.managementStrategy = managementStrategy;
    }

    public <T> T getContextPlugin(Class<T> type) {
        Object ret = this.pluginManager.getContextPlugin(type);
        if (ret == null && type.isInstance((Object)this.camelContext)) {
            return type.cast((Object)this.camelContext);
        }
        return (T)ret;
    }

    public <T> void addContextPlugin(Class<T> type, T module) {
        T addedModule = this.camelContext.getInternalServiceManager().addService(this.camelContext, module);
        this.pluginManager.addContextPlugin(type, addedModule);
    }

    public <T> void lazyAddContextPlugin(Class<T> type, Supplier<T> module) {
        this.pluginManager.lazyAddContextPlugin(type, () -> this.lazyInitAndAdd(module));
    }

    private <T> T lazyInitAndAdd(Supplier<T> supplier) {
        T module = supplier.get();
        return this.camelContext.getInternalServiceManager().addService(this.camelContext, module);
    }

    private static Logger logger() {
        return Holder.LOG;
    }

    private static final class Holder {
        static final Logger LOG = LoggerFactory.getLogger(DefaultCamelContextExtension.class);

        private Holder() {
        }
    }
}

