/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.apache.camel.component.caffeine.EvictionType;
import org.apache.camel.util.ObjectHelper;

public final class CaffeineHelper {
    private CaffeineHelper() {
    }

    public static void defineBuilder(Caffeine<?, ?> builder, CaffeineConfiguration configuration) {
        if (configuration.getEvictionType() == EvictionType.SIZE_BASED) {
            if (configuration.getInitialCapacity() != null) {
                builder.initialCapacity(configuration.getInitialCapacity().intValue());
            }
            if (configuration.getMaximumSize() != null) {
                builder.maximumSize((long)configuration.getMaximumSize().intValue());
            }
        } else if (configuration.getEvictionType() == EvictionType.TIME_BASED) {
            builder.expireAfterAccess((long)configuration.getExpireAfterAccessTime(), TimeUnit.SECONDS);
            builder.expireAfterWrite((long)configuration.getExpireAfterWriteTime(), TimeUnit.SECONDS);
        }
        if (configuration.isStatsEnabled()) {
            if (ObjectHelper.isEmpty((Object)configuration.getStatsCounter())) {
                builder.recordStats();
            } else {
                builder.recordStats(configuration::getStatsCounter);
            }
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getRemovalListener())) {
            builder.removalListener(configuration.getRemovalListener());
        }
    }
}

