/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.AlertRecipientsSettingType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class RecipientsConfiguration {
    protected final AlertRecipientsSettingType recipientSettingType;
    protected final List<String> emails;
    protected final List<String> groups;

    public RecipientsConfiguration(AlertRecipientsSettingType recipientSettingType, List<String> emails, List<String> groups) {
        this.recipientSettingType = recipientSettingType;
        if (emails != null) {
            for (String x : emails) {
                if (x == null) {
                    throw new IllegalArgumentException("An item in list 'emails' is null");
                }
                if (x.length() <= 255) continue;
                throw new IllegalArgumentException("Stringan item in list 'emails' is longer than 255");
            }
        }
        this.emails = emails;
        if (groups != null) {
            for (String x : groups) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'groups' is null");
            }
        }
        this.groups = groups;
    }

    public RecipientsConfiguration() {
        this(null, null, null);
    }

    public AlertRecipientsSettingType getRecipientSettingType() {
        return this.recipientSettingType;
    }

    public List<String> getEmails() {
        return this.emails;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.recipientSettingType, this.emails, this.groups});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            RecipientsConfiguration other = (RecipientsConfiguration)obj;
            return (this.recipientSettingType == other.recipientSettingType || this.recipientSettingType != null && this.recipientSettingType.equals((Object)other.recipientSettingType)) && (this.emails == other.emails || this.emails != null && this.emails.equals(other.emails)) && (this.groups == other.groups || this.groups != null && this.groups.equals(other.groups));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<RecipientsConfiguration> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RecipientsConfiguration value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.recipientSettingType != null) {
                g.writeFieldName("recipient_setting_type");
                StoneSerializers.nullable(AlertRecipientsSettingType.Serializer.INSTANCE).serialize(value.recipientSettingType, g);
            }
            if (value.emails != null) {
                g.writeFieldName("emails");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize(value.emails, g);
            }
            if (value.groups != null) {
                g.writeFieldName("groups");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize(value.groups, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public RecipientsConfiguration deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_groups;
            List<String> f_emails;
            AlertRecipientsSettingType f_recipientSettingType;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_recipientSettingType = null;
                f_emails = null;
                f_groups = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("recipient_setting_type".equals(field)) {
                        f_recipientSettingType = StoneSerializers.nullable(AlertRecipientsSettingType.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("emails".equals(field)) {
                        f_emails = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    if ("groups".equals(field)) {
                        f_groups = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            RecipientsConfiguration value = new RecipientsConfiguration(f_recipientSettingType, f_emails, f_groups);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected AlertRecipientsSettingType recipientSettingType = null;
        protected List<String> emails = null;
        protected List<String> groups = null;

        protected Builder() {
        }

        public Builder withRecipientSettingType(AlertRecipientsSettingType recipientSettingType) {
            this.recipientSettingType = recipientSettingType;
            return this;
        }

        public Builder withEmails(List<String> emails) {
            if (emails != null) {
                for (String x : emails) {
                    if (x == null) {
                        throw new IllegalArgumentException("An item in list 'emails' is null");
                    }
                    if (x.length() <= 255) continue;
                    throw new IllegalArgumentException("Stringan item in list 'emails' is longer than 255");
                }
            }
            this.emails = emails;
            return this;
        }

        public Builder withGroups(List<String> groups) {
            if (groups != null) {
                for (String x : groups) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'groups' is null");
                }
            }
            this.groups = groups;
            return this;
        }

        public RecipientsConfiguration build() {
            return new RecipientsConfiguration(this.recipientSettingType, this.emails, this.groups);
        }
    }
}

