/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class EmailIngestReceiveFileDetails {
    protected final String inboxName;
    protected final List<String> attachmentNames;
    protected final String subject;
    protected final String fromName;
    protected final String fromEmail;

    public EmailIngestReceiveFileDetails(String inboxName, List<String> attachmentNames, String subject, String fromName, String fromEmail) {
        if (inboxName == null) {
            throw new IllegalArgumentException("Required value for 'inboxName' is null");
        }
        this.inboxName = inboxName;
        if (attachmentNames == null) {
            throw new IllegalArgumentException("Required value for 'attachmentNames' is null");
        }
        for (String x : attachmentNames) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'attachmentNames' is null");
        }
        this.attachmentNames = attachmentNames;
        this.subject = subject;
        this.fromName = fromName;
        if (fromEmail != null && fromEmail.length() > 255) {
            throw new IllegalArgumentException("String 'fromEmail' is longer than 255");
        }
        this.fromEmail = fromEmail;
    }

    public EmailIngestReceiveFileDetails(String inboxName, List<String> attachmentNames) {
        this(inboxName, attachmentNames, null, null, null);
    }

    public String getInboxName() {
        return this.inboxName;
    }

    public List<String> getAttachmentNames() {
        return this.attachmentNames;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getFromName() {
        return this.fromName;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public static Builder newBuilder(String inboxName, List<String> attachmentNames) {
        return new Builder(inboxName, attachmentNames);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.inboxName, this.attachmentNames, this.subject, this.fromName, this.fromEmail});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            EmailIngestReceiveFileDetails other = (EmailIngestReceiveFileDetails)obj;
            return !(this.inboxName != other.inboxName && !this.inboxName.equals(other.inboxName) || this.attachmentNames != other.attachmentNames && !this.attachmentNames.equals(other.attachmentNames) || this.subject != other.subject && (this.subject == null || !this.subject.equals(other.subject)) || this.fromName != other.fromName && (this.fromName == null || !this.fromName.equals(other.fromName)) || this.fromEmail != other.fromEmail && (this.fromEmail == null || !this.fromEmail.equals(other.fromEmail)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<EmailIngestReceiveFileDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(EmailIngestReceiveFileDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("inbox_name");
            StoneSerializers.string().serialize(value.inboxName, g);
            g.writeFieldName("attachment_names");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.attachmentNames, g);
            if (value.subject != null) {
                g.writeFieldName("subject");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.subject, g);
            }
            if (value.fromName != null) {
                g.writeFieldName("from_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.fromName, g);
            }
            if (value.fromEmail != null) {
                g.writeFieldName("from_email");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.fromEmail, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public EmailIngestReceiveFileDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_fromEmail;
            String f_fromName;
            String f_subject;
            List<String> f_attachmentNames;
            String f_inboxName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_inboxName = null;
                f_attachmentNames = null;
                f_subject = null;
                f_fromName = null;
                f_fromEmail = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("inbox_name".equals(field)) {
                        f_inboxName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("attachment_names".equals(field)) {
                        f_attachmentNames = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("subject".equals(field)) {
                        f_subject = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("from_name".equals(field)) {
                        f_fromName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("from_email".equals(field)) {
                        f_fromEmail = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_inboxName == null) {
                    throw new JsonParseException(p, "Required field \"inbox_name\" missing.");
                }
                if (f_attachmentNames == null) {
                    throw new JsonParseException(p, "Required field \"attachment_names\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            EmailIngestReceiveFileDetails value = new EmailIngestReceiveFileDetails(f_inboxName, f_attachmentNames, f_subject, f_fromName, f_fromEmail);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String inboxName;
        protected final List<String> attachmentNames;
        protected String subject;
        protected String fromName;
        protected String fromEmail;

        protected Builder(String inboxName, List<String> attachmentNames) {
            if (inboxName == null) {
                throw new IllegalArgumentException("Required value for 'inboxName' is null");
            }
            this.inboxName = inboxName;
            if (attachmentNames == null) {
                throw new IllegalArgumentException("Required value for 'attachmentNames' is null");
            }
            for (String x : attachmentNames) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'attachmentNames' is null");
            }
            this.attachmentNames = attachmentNames;
            this.subject = null;
            this.fromName = null;
            this.fromEmail = null;
        }

        public Builder withSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder withFromName(String fromName) {
            this.fromName = fromName;
            return this;
        }

        public Builder withFromEmail(String fromEmail) {
            if (fromEmail != null && fromEmail.length() > 255) {
                throw new IllegalArgumentException("String 'fromEmail' is longer than 255");
            }
            this.fromEmail = fromEmail;
            return this;
        }

        public EmailIngestReceiveFileDetails build() {
            return new EmailIngestReceiveFileDetails(this.inboxName, this.attachmentNames, this.subject, this.fromName, this.fromEmail);
        }
    }
}

