/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class SharingAllowlistListResponse {
    protected final List<String> domains;
    protected final List<String> emails;
    protected final String cursor;
    protected final boolean hasMore;

    public SharingAllowlistListResponse(List<String> domains, List<String> emails, String cursor, boolean hasMore) {
        if (domains == null) {
            throw new IllegalArgumentException("Required value for 'domains' is null");
        }
        for (String x : domains) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'domains' is null");
        }
        this.domains = domains;
        if (emails == null) {
            throw new IllegalArgumentException("Required value for 'emails' is null");
        }
        for (String x : emails) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'emails' is null");
        }
        this.emails = emails;
        if (cursor == null) {
            throw new IllegalArgumentException("Required value for 'cursor' is null");
        }
        this.cursor = cursor;
        this.hasMore = hasMore;
    }

    public SharingAllowlistListResponse(List<String> domains, List<String> emails) {
        this(domains, emails, "", false);
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public List<String> getEmails() {
        return this.emails;
    }

    public String getCursor() {
        return this.cursor;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public static Builder newBuilder(List<String> domains, List<String> emails) {
        return new Builder(domains, emails);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.domains, this.emails, this.cursor, this.hasMore});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharingAllowlistListResponse other = (SharingAllowlistListResponse)obj;
            return !(this.domains != other.domains && !this.domains.equals(other.domains) || this.emails != other.emails && !this.emails.equals(other.emails) || this.cursor != other.cursor && !this.cursor.equals(other.cursor) || this.hasMore != other.hasMore);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharingAllowlistListResponse> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharingAllowlistListResponse value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("domains");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.domains, g);
            g.writeFieldName("emails");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.emails, g);
            g.writeFieldName("cursor");
            StoneSerializers.string().serialize(value.cursor, g);
            g.writeFieldName("has_more");
            StoneSerializers.boolean_().serialize((Boolean)value.hasMore, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharingAllowlistListResponse deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_hasMore;
            String f_cursor;
            List<String> f_emails;
            List<String> f_domains;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_domains = null;
                f_emails = null;
                f_cursor = "";
                f_hasMore = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("domains".equals(field)) {
                        f_domains = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("emails".equals(field)) {
                        f_emails = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("cursor".equals(field)) {
                        f_cursor = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("has_more".equals(field)) {
                        f_hasMore = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_domains == null) {
                    throw new JsonParseException(p, "Required field \"domains\" missing.");
                }
                if (f_emails == null) {
                    throw new JsonParseException(p, "Required field \"emails\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharingAllowlistListResponse value = new SharingAllowlistListResponse(f_domains, f_emails, f_cursor, f_hasMore);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final List<String> domains;
        protected final List<String> emails;
        protected String cursor;
        protected boolean hasMore;

        protected Builder(List<String> domains, List<String> emails) {
            if (domains == null) {
                throw new IllegalArgumentException("Required value for 'domains' is null");
            }
            for (String x : domains) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'domains' is null");
            }
            this.domains = domains;
            if (emails == null) {
                throw new IllegalArgumentException("Required value for 'emails' is null");
            }
            for (String x : emails) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'emails' is null");
            }
            this.emails = emails;
            this.cursor = "";
            this.hasMore = false;
        }

        public Builder withCursor(String cursor) {
            this.cursor = cursor != null ? cursor : "";
            return this;
        }

        public Builder withHasMore(Boolean hasMore) {
            this.hasMore = hasMore != null ? hasMore : false;
            return this;
        }

        public SharingAllowlistListResponse build() {
            return new SharingAllowlistListResponse(this.domains, this.emails, this.cursor, this.hasMore);
        }
    }
}

