/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AlphaResolvedVisibility;
import com.dropbox.core.v2.sharing.RequestedVisibility;
import com.dropbox.core.v2.sharing.VisibilityPolicyDisallowedReason;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class VisibilityPolicy {
    protected final RequestedVisibility policy;
    protected final AlphaResolvedVisibility resolvedPolicy;
    protected final boolean allowed;
    protected final VisibilityPolicyDisallowedReason disallowedReason;

    public VisibilityPolicy(RequestedVisibility policy, AlphaResolvedVisibility resolvedPolicy, boolean allowed, VisibilityPolicyDisallowedReason disallowedReason) {
        if (policy == null) {
            throw new IllegalArgumentException("Required value for 'policy' is null");
        }
        this.policy = policy;
        if (resolvedPolicy == null) {
            throw new IllegalArgumentException("Required value for 'resolvedPolicy' is null");
        }
        this.resolvedPolicy = resolvedPolicy;
        this.allowed = allowed;
        this.disallowedReason = disallowedReason;
    }

    public VisibilityPolicy(RequestedVisibility policy, AlphaResolvedVisibility resolvedPolicy, boolean allowed) {
        this(policy, resolvedPolicy, allowed, null);
    }

    public RequestedVisibility getPolicy() {
        return this.policy;
    }

    public AlphaResolvedVisibility getResolvedPolicy() {
        return this.resolvedPolicy;
    }

    public boolean getAllowed() {
        return this.allowed;
    }

    public VisibilityPolicyDisallowedReason getDisallowedReason() {
        return this.disallowedReason;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.policy, this.resolvedPolicy, this.allowed, this.disallowedReason});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            VisibilityPolicy other = (VisibilityPolicy)obj;
            return !(this.policy != other.policy && !this.policy.equals((Object)other.policy) || this.resolvedPolicy != other.resolvedPolicy && !this.resolvedPolicy.equals((Object)other.resolvedPolicy) || this.allowed != other.allowed || this.disallowedReason != other.disallowedReason && (this.disallowedReason == null || !this.disallowedReason.equals((Object)other.disallowedReason)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<VisibilityPolicy> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(VisibilityPolicy value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("policy");
            RequestedVisibility.Serializer.INSTANCE.serialize(value.policy, g);
            g.writeFieldName("resolved_policy");
            AlphaResolvedVisibility.Serializer.INSTANCE.serialize(value.resolvedPolicy, g);
            g.writeFieldName("allowed");
            StoneSerializers.boolean_().serialize((Boolean)value.allowed, g);
            if (value.disallowedReason != null) {
                g.writeFieldName("disallowed_reason");
                StoneSerializers.nullable(VisibilityPolicyDisallowedReason.Serializer.INSTANCE).serialize(value.disallowedReason, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public VisibilityPolicy deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            VisibilityPolicyDisallowedReason f_disallowedReason;
            Boolean f_allowed;
            AlphaResolvedVisibility f_resolvedPolicy;
            RequestedVisibility f_policy;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_policy = null;
                f_resolvedPolicy = null;
                f_allowed = null;
                f_disallowedReason = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("policy".equals(field)) {
                        f_policy = RequestedVisibility.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("resolved_policy".equals(field)) {
                        f_resolvedPolicy = AlphaResolvedVisibility.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("allowed".equals(field)) {
                        f_allowed = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("disallowed_reason".equals(field)) {
                        f_disallowedReason = StoneSerializers.nullable(VisibilityPolicyDisallowedReason.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_policy == null) {
                    throw new JsonParseException(p, "Required field \"policy\" missing.");
                }
                if (f_resolvedPolicy == null) {
                    throw new JsonParseException(p, "Required field \"resolved_policy\" missing.");
                }
                if (f_allowed == null) {
                    throw new JsonParseException(p, "Required field \"allowed\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            VisibilityPolicy value = new VisibilityPolicy(f_policy, f_resolvedPolicy, f_allowed, f_disallowedReason);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

