/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.FileMemberActionIndividualResult;
import com.dropbox.core.v2.sharing.MemberSelector;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class FileMemberActionResult {
    protected final MemberSelector member;
    protected final FileMemberActionIndividualResult result;
    protected final String sckeySha1;
    protected final List<String> invitationSignature;

    public FileMemberActionResult(MemberSelector member, FileMemberActionIndividualResult result, String sckeySha1, List<String> invitationSignature) {
        if (member == null) {
            throw new IllegalArgumentException("Required value for 'member' is null");
        }
        this.member = member;
        if (result == null) {
            throw new IllegalArgumentException("Required value for 'result' is null");
        }
        this.result = result;
        this.sckeySha1 = sckeySha1;
        if (invitationSignature != null) {
            for (String x : invitationSignature) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'invitationSignature' is null");
            }
        }
        this.invitationSignature = invitationSignature;
    }

    public FileMemberActionResult(MemberSelector member, FileMemberActionIndividualResult result) {
        this(member, result, null, null);
    }

    public MemberSelector getMember() {
        return this.member;
    }

    public FileMemberActionIndividualResult getResult() {
        return this.result;
    }

    public String getSckeySha1() {
        return this.sckeySha1;
    }

    public List<String> getInvitationSignature() {
        return this.invitationSignature;
    }

    public static Builder newBuilder(MemberSelector member, FileMemberActionIndividualResult result) {
        return new Builder(member, result);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.member, this.result, this.sckeySha1, this.invitationSignature});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileMemberActionResult other = (FileMemberActionResult)obj;
            return !(this.member != other.member && !this.member.equals(other.member) || this.result != other.result && !this.result.equals(other.result) || this.sckeySha1 != other.sckeySha1 && (this.sckeySha1 == null || !this.sckeySha1.equals(other.sckeySha1)) || this.invitationSignature != other.invitationSignature && (this.invitationSignature == null || !this.invitationSignature.equals(other.invitationSignature)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileMemberActionResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileMemberActionResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("member");
            MemberSelector.Serializer.INSTANCE.serialize(value.member, g);
            g.writeFieldName("result");
            FileMemberActionIndividualResult.Serializer.INSTANCE.serialize(value.result, g);
            if (value.sckeySha1 != null) {
                g.writeFieldName("sckey_sha1");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.sckeySha1, g);
            }
            if (value.invitationSignature != null) {
                g.writeFieldName("invitation_signature");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize(value.invitationSignature, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileMemberActionResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_invitationSignature;
            String f_sckeySha1;
            FileMemberActionIndividualResult f_result;
            MemberSelector f_member;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_member = null;
                f_result = null;
                f_sckeySha1 = null;
                f_invitationSignature = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("member".equals(field)) {
                        f_member = MemberSelector.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("result".equals(field)) {
                        f_result = FileMemberActionIndividualResult.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("sckey_sha1".equals(field)) {
                        f_sckeySha1 = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("invitation_signature".equals(field)) {
                        f_invitationSignature = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_member == null) {
                    throw new JsonParseException(p, "Required field \"member\" missing.");
                }
                if (f_result == null) {
                    throw new JsonParseException(p, "Required field \"result\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileMemberActionResult value = new FileMemberActionResult(f_member, f_result, f_sckeySha1, f_invitationSignature);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final MemberSelector member;
        protected final FileMemberActionIndividualResult result;
        protected String sckeySha1;
        protected List<String> invitationSignature;

        protected Builder(MemberSelector member, FileMemberActionIndividualResult result) {
            if (member == null) {
                throw new IllegalArgumentException("Required value for 'member' is null");
            }
            this.member = member;
            if (result == null) {
                throw new IllegalArgumentException("Required value for 'result' is null");
            }
            this.result = result;
            this.sckeySha1 = null;
            this.invitationSignature = null;
        }

        public Builder withSckeySha1(String sckeySha1) {
            this.sckeySha1 = sckeySha1;
            return this;
        }

        public Builder withInvitationSignature(List<String> invitationSignature) {
            if (invitationSignature != null) {
                for (String x : invitationSignature) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'invitationSignature' is null");
                }
            }
            this.invitationSignature = invitationSignature;
            return this;
        }

        public FileMemberActionResult build() {
            return new FileMemberActionResult(this.member, this.result, this.sckeySha1, this.invitationSignature);
        }
    }
}

