/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.UploadSessionType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class UploadSessionStartArg {
    protected final boolean close;
    protected final UploadSessionType sessionType;
    protected final String contentHash;

    public UploadSessionStartArg(boolean close, UploadSessionType sessionType, String contentHash) {
        this.close = close;
        this.sessionType = sessionType;
        if (contentHash != null) {
            if (contentHash.length() < 64) {
                throw new IllegalArgumentException("String 'contentHash' is shorter than 64");
            }
            if (contentHash.length() > 64) {
                throw new IllegalArgumentException("String 'contentHash' is longer than 64");
            }
        }
        this.contentHash = contentHash;
    }

    public UploadSessionStartArg() {
        this(false, null, null);
    }

    public boolean getClose() {
        return this.close;
    }

    public UploadSessionType getSessionType() {
        return this.sessionType;
    }

    public String getContentHash() {
        return this.contentHash;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.close, this.sessionType, this.contentHash});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UploadSessionStartArg other = (UploadSessionStartArg)obj;
            return this.close == other.close && (this.sessionType == other.sessionType || this.sessionType != null && this.sessionType.equals((Object)other.sessionType)) && (this.contentHash == other.contentHash || this.contentHash != null && this.contentHash.equals(other.contentHash));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UploadSessionStartArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UploadSessionStartArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("close");
            StoneSerializers.boolean_().serialize((Boolean)value.close, g);
            if (value.sessionType != null) {
                g.writeFieldName("session_type");
                StoneSerializers.nullable(UploadSessionType.Serializer.INSTANCE).serialize(value.sessionType, g);
            }
            if (value.contentHash != null) {
                g.writeFieldName("content_hash");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.contentHash, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UploadSessionStartArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_contentHash;
            UploadSessionType f_sessionType;
            Boolean f_close;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_close = false;
                f_sessionType = null;
                f_contentHash = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("close".equals(field)) {
                        f_close = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("session_type".equals(field)) {
                        f_sessionType = StoneSerializers.nullable(UploadSessionType.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("content_hash".equals(field)) {
                        f_contentHash = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UploadSessionStartArg value = new UploadSessionStartArg(f_close, f_sessionType, f_contentHash);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected boolean close = false;
        protected UploadSessionType sessionType = null;
        protected String contentHash = null;

        protected Builder() {
        }

        public Builder withClose(Boolean close) {
            this.close = close != null ? close : false;
            return this;
        }

        public Builder withSessionType(UploadSessionType sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        public Builder withContentHash(String contentHash) {
            if (contentHash != null) {
                if (contentHash.length() < 64) {
                    throw new IllegalArgumentException("String 'contentHash' is shorter than 64");
                }
                if (contentHash.length() > 64) {
                    throw new IllegalArgumentException("String 'contentHash' is longer than 64");
                }
            }
            this.contentHash = contentHash;
            return this;
        }

        public UploadSessionStartArg build() {
            return new UploadSessionStartArg(this.close, this.sessionType, this.contentHash);
        }
    }
}

