/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.UploadSessionCursor;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class UploadSessionFinishArg {
    protected final UploadSessionCursor cursor;
    protected final CommitInfo commit;
    protected final String contentHash;

    public UploadSessionFinishArg(UploadSessionCursor cursor, CommitInfo commit, String contentHash) {
        if (cursor == null) {
            throw new IllegalArgumentException("Required value for 'cursor' is null");
        }
        this.cursor = cursor;
        if (commit == null) {
            throw new IllegalArgumentException("Required value for 'commit' is null");
        }
        this.commit = commit;
        if (contentHash != null) {
            if (contentHash.length() < 64) {
                throw new IllegalArgumentException("String 'contentHash' is shorter than 64");
            }
            if (contentHash.length() > 64) {
                throw new IllegalArgumentException("String 'contentHash' is longer than 64");
            }
        }
        this.contentHash = contentHash;
    }

    public UploadSessionFinishArg(UploadSessionCursor cursor, CommitInfo commit) {
        this(cursor, commit, null);
    }

    public UploadSessionCursor getCursor() {
        return this.cursor;
    }

    public CommitInfo getCommit() {
        return this.commit;
    }

    public String getContentHash() {
        return this.contentHash;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.cursor, this.commit, this.contentHash});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UploadSessionFinishArg other = (UploadSessionFinishArg)obj;
            return !(this.cursor != other.cursor && !this.cursor.equals(other.cursor) || this.commit != other.commit && !this.commit.equals(other.commit) || this.contentHash != other.contentHash && (this.contentHash == null || !this.contentHash.equals(other.contentHash)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UploadSessionFinishArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UploadSessionFinishArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("cursor");
            UploadSessionCursor.Serializer.INSTANCE.serialize(value.cursor, g);
            g.writeFieldName("commit");
            CommitInfo.Serializer.INSTANCE.serialize(value.commit, g);
            if (value.contentHash != null) {
                g.writeFieldName("content_hash");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.contentHash, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UploadSessionFinishArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_contentHash;
            CommitInfo f_commit;
            UploadSessionCursor f_cursor;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_cursor = null;
                f_commit = null;
                f_contentHash = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("cursor".equals(field)) {
                        f_cursor = (UploadSessionCursor)UploadSessionCursor.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("commit".equals(field)) {
                        f_commit = (CommitInfo)CommitInfo.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("content_hash".equals(field)) {
                        f_contentHash = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_cursor == null) {
                    throw new JsonParseException(p, "Required field \"cursor\" missing.");
                }
                if (f_commit == null) {
                    throw new JsonParseException(p, "Required field \"commit\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UploadSessionFinishArg value = new UploadSessionFinishArg(f_cursor, f_commit, f_contentHash);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

