/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.RelocationBatchArgBase;
import com.dropbox.core.v2.files.RelocationPath;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class MoveBatchArg
extends RelocationBatchArgBase {
    protected final boolean allowOwnershipTransfer;

    public MoveBatchArg(List<RelocationPath> entries, boolean autorename, boolean allowOwnershipTransfer) {
        super(entries, autorename);
        this.allowOwnershipTransfer = allowOwnershipTransfer;
    }

    public MoveBatchArg(List<RelocationPath> entries) {
        this(entries, false, false);
    }

    @Override
    public List<RelocationPath> getEntries() {
        return this.entries;
    }

    @Override
    public boolean getAutorename() {
        return this.autorename;
    }

    public boolean getAllowOwnershipTransfer() {
        return this.allowOwnershipTransfer;
    }

    public static Builder newBuilder(List<RelocationPath> entries) {
        return new Builder(entries);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.allowOwnershipTransfer});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MoveBatchArg other = (MoveBatchArg)obj;
            return (this.entries == other.entries || this.entries.equals(other.entries)) && this.autorename == other.autorename && this.allowOwnershipTransfer == other.allowOwnershipTransfer;
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MoveBatchArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MoveBatchArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("entries");
            StoneSerializers.list(RelocationPath.Serializer.INSTANCE).serialize((List<RelocationPath>)value.entries, g);
            g.writeFieldName("autorename");
            StoneSerializers.boolean_().serialize((Boolean)value.autorename, g);
            g.writeFieldName("allow_ownership_transfer");
            StoneSerializers.boolean_().serialize((Boolean)value.allowOwnershipTransfer, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public MoveBatchArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_allowOwnershipTransfer;
            Boolean f_autorename;
            List<RelocationPath> f_entries;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_entries = null;
                f_autorename = false;
                f_allowOwnershipTransfer = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("entries".equals(field)) {
                        f_entries = StoneSerializers.list(RelocationPath.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("autorename".equals(field)) {
                        f_autorename = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("allow_ownership_transfer".equals(field)) {
                        f_allowOwnershipTransfer = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_entries == null) {
                    throw new JsonParseException(p, "Required field \"entries\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MoveBatchArg value = new MoveBatchArg(f_entries, f_autorename, f_allowOwnershipTransfer);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final List<RelocationPath> entries;
        protected boolean autorename;
        protected boolean allowOwnershipTransfer;

        protected Builder(List<RelocationPath> entries) {
            if (entries == null) {
                throw new IllegalArgumentException("Required value for 'entries' is null");
            }
            if (entries.size() < 1) {
                throw new IllegalArgumentException("List 'entries' has fewer than 1 items");
            }
            if (entries.size() > 1000) {
                throw new IllegalArgumentException("List 'entries' has more than 1000 items");
            }
            for (RelocationPath x : entries) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'entries' is null");
            }
            this.entries = entries;
            this.autorename = false;
            this.allowOwnershipTransfer = false;
        }

        public Builder withAutorename(Boolean autorename) {
            this.autorename = autorename != null ? autorename : false;
            return this;
        }

        public Builder withAllowOwnershipTransfer(Boolean allowOwnershipTransfer) {
            this.allowOwnershipTransfer = allowOwnershipTransfer != null ? allowOwnershipTransfer : false;
            return this;
        }

        public MoveBatchArg build() {
            return new MoveBatchArg(this.entries, this.autorename, this.allowOwnershipTransfer);
        }
    }
}

