/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Channel;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.StartupStep;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.ChildServiceSupport;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.MDC;

public class RouteService
extends ChildServiceSupport {
    private final CamelContext camelContext;
    private final StartupStepRecorder startupStepRecorder;
    private final Route route;
    private boolean removingRoutes;
    private Consumer input;
    private final Lock lock = new ReentrantLock();
    private final AtomicBoolean setUpDone = new AtomicBoolean();
    private final AtomicBoolean warmUpDone = new AtomicBoolean();
    private final AtomicBoolean endpointDone = new AtomicBoolean();

    public RouteService(Route route) {
        this.route = route;
        this.camelContext = this.route.getCamelContext();
        this.startupStepRecorder = this.camelContext.getCamelContextExtension().getStartupStepRecorder();
    }

    public String getId() {
        return this.route.getId();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Route getRoute() {
        return this.route;
    }

    public Set<Endpoint> gatherEndpoints() {
        LinkedHashSet<Endpoint> answer = new LinkedHashSet<Endpoint>();
        Set<Service> services = this.gatherChildServices();
        for (Service service : services) {
            EndpointAware endpointAware;
            Endpoint endpoint;
            if (!(service instanceof EndpointAware) || (endpoint = (endpointAware = (EndpointAware)service).getEndpoint()) == null) continue;
            answer.add(endpoint);
        }
        return answer;
    }

    public Consumer getInput() {
        return this.input;
    }

    public boolean isRemovingRoutes() {
        return this.removingRoutes;
    }

    public void setRemovingRoutes(boolean removingRoutes) {
        this.removingRoutes = removingRoutes;
    }

    public void warmUp() throws FailedToStartRouteException {
        try {
            this.doWarmUp();
        }
        catch (Exception e) {
            throw new FailedToStartRouteException(this.getId(), e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setUp() throws FailedToStartRouteException {
        if (this.setUpDone.compareAndSet(false, true)) {
            try {
                this.doSetup();
            }
            catch (Exception e) {
                throw new FailedToStartRouteException(this.getId(), e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public boolean isAutoStartup() {
        if (!this.getCamelContext().isAutoStartup().booleanValue()) {
            return false;
        }
        if (!this.getRoute().isAutoStartup().booleanValue()) {
            return false;
        }
        if (this.getCamelContext().getAutoStartupExcludePattern() != null) {
            String[] patterns = this.getCamelContext().getAutoStartupExcludePattern().split(",");
            String id = this.getRoute().getRouteId();
            String url = this.getRoute().getEndpoint().getEndpointUri();
            if (PatternHelper.matchPatterns((String)id, (String[])patterns) || PatternHelper.matchPatterns((String)url, (String[])patterns)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetup() throws Exception {
        this.lock.lock();
        try {
            ServiceHelper.initService((Object)this.route.getEndpoint());
            try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
                this.route.initializeServices();
                List services = this.route.getServices();
                ArrayList<Service> list = new ArrayList<Service>();
                for (Service service : services) {
                    if (service instanceof RouteAware) {
                        RouteAware routeAware = (RouteAware)service;
                        routeAware.setRoute(this.route);
                    }
                    if (service instanceof RouteIdAware) {
                        RouteIdAware routeIdAware = (RouteIdAware)service;
                        routeIdAware.setRouteId(this.route.getId());
                    }
                    CamelContextAware.trySetCamelContext((Object)service, (CamelContext)this.camelContext);
                    if (service instanceof Consumer) {
                        Consumer consumer;
                        this.input = consumer = (Consumer)service;
                        continue;
                    }
                    list.add(service);
                }
                this.initChildServices(list);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWarmUp() throws Exception {
        block10: {
            this.lock.lock();
            try {
                if (this.endpointDone.compareAndSet(false, true)) {
                    ServiceHelper.startService((Service)this.route.getEndpoint());
                }
                if (!this.warmUpDone.compareAndSet(false, true)) break block10;
                try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
                    this.route.warmUp();
                    this.startChildServices(this.route, this.childServices);
                    EventHelper.notifyRouteAdded((CamelContext)this.camelContext, (Route)this.route);
                }
                for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                    strategy.onRoutesAdd(Collections.singletonList(this.route));
                }
                this.camelContext.getCamelContextExtension().addRoute(this.route);
                this.camelContext.getInflightRepository().addRoute(this.route.getId());
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected void doStart() {
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            EventHelper.notifyRouteStarting((CamelContext)this.camelContext, (Route)this.route);
        }
        try {
            this.warmUp();
        }
        catch (FailedToStartRouteException e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
        mdcHelper = new MDCHelper(this.route.getId());
        try {
            ServiceHelper.startService((Object)this.route);
            this.routePolicyCallback(RoutePolicy::onStart);
            EventHelper.notifyRouteStarted((CamelContext)this.camelContext, (Route)this.route);
        }
        finally {
            mdcHelper.close();
        }
    }

    protected void doStop() {
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            EventHelper.notifyRouteStopping((CamelContext)this.camelContext, (Route)this.route);
        }
        boolean isShutdownCamelContext = this.camelContext.isStopping();
        if (isShutdownCamelContext || this.isRemovingRoutes()) {
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onRoutesRemove(Collections.singletonList(this.route));
            }
        }
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            Set<Service> services = this.gatherChildServices();
            this.stopChildServices(this.route, services, isShutdownCamelContext);
            if (isShutdownCamelContext) {
                ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.route});
            } else {
                ServiceHelper.stopService((Object)this.route);
            }
            this.routePolicyCallback(RoutePolicy::onStop);
            EventHelper.notifyRouteStopped((CamelContext)this.camelContext, (Route)this.route);
        }
        if (this.isRemovingRoutes()) {
            this.camelContext.getCamelContextExtension().removeRoute(this.route);
        }
        this.input = null;
        this.childServices = null;
        this.warmUpDone.set(false);
        this.setUpDone.set(false);
        this.endpointDone.set(false);
        this.setUpDone.set(false);
        this.warmUpDone.set(false);
    }

    protected void doShutdown() {
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            Set<Service> services = this.gatherChildServices();
            this.stopChildServices(this.route, services, true);
            ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.route});
            ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.route.getEndpoint()});
            this.routePolicyCallback(RoutePolicy::onRemove);
            EventHelper.notifyRouteRemoved((CamelContext)this.camelContext, (Route)this.route);
        }
        for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
            strategy.onRoutesRemove(Collections.singletonList(this.route));
        }
        this.camelContext.getInflightRepository().removeRoute(this.route.getId());
        this.camelContext.getCamelContextExtension().removeRoute(this.route);
        this.input = null;
        this.childServices = null;
        this.warmUpDone.set(false);
        this.setUpDone.set(false);
        this.endpointDone.set(false);
    }

    protected void doSuspend() {
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            this.routePolicyCallback(RoutePolicy::onSuspend);
        }
    }

    protected void doResume() {
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            this.routePolicyCallback(RoutePolicy::onResume);
        }
    }

    private void routePolicyCallback(BiConsumer<RoutePolicy, Route> callback) {
        if (this.route.getRoutePolicyList() != null) {
            for (RoutePolicy routePolicy : this.route.getRoutePolicyList()) {
                callback.accept(routePolicy, this.route);
            }
        }
    }

    private StartupStep beginStep(Service service, String description) {
        Class type = service instanceof Processor ? Processor.class : Service.class;
        description = (String)description + " " + service.getClass().getSimpleName();
        String id = null;
        if (service instanceof IdAware) {
            IdAware idAware = (IdAware)service;
            id = idAware.getId();
        }
        return this.startupStepRecorder.beginStep(type, id, (String)description);
    }

    protected void initChildServices(List<Service> services) {
        for (Service service : services) {
            boolean shouldRecord;
            StartupStep step = null;
            boolean bl = shouldRecord = !(service instanceof InternalProcessor) && !"RoutePipeline".equals(service.getClass().getSimpleName());
            if (shouldRecord) {
                step = this.beginStep(service, "Init");
            }
            ServiceHelper.initService((Object)service);
            if (step != null) {
                this.startupStepRecorder.endStep(step);
            }
            this.addChildService(service);
        }
    }

    protected void startChildServices(Route route, List<Service> services) {
        for (Service service : services) {
            boolean shouldRecord;
            StartupStep step = null;
            boolean bl = shouldRecord = !(service instanceof InternalProcessor) && !"RoutePipeline".equals(service.getClass().getSimpleName());
            if (shouldRecord) {
                step = this.beginStep(service, "Start");
            }
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onServiceAdd(this.camelContext, service, route);
            }
            ServiceHelper.startService((Service)service);
            if (step == null) continue;
            this.startupStepRecorder.endStep(step);
        }
    }

    protected void stopChildServices(Route route, Set<Service> services, boolean shutdown) {
        for (Service service : services) {
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onServiceRemove(this.camelContext, service, route);
            }
            if (shutdown) {
                ServiceHelper.stopAndShutdownService((Object)service);
            } else {
                ServiceHelper.stopService((Service)service);
            }
            this.removeChildService(service);
        }
    }

    private Set<Service> gatherChildServices() {
        ArrayList<Service> services = new ArrayList<Service>(this.route.getServices());
        this.doGetRouteServices(services);
        LinkedHashSet<Service> list = new LinkedHashSet<Service>();
        for (Service service : services) {
            list.addAll(ServiceHelper.getChildServices((Service)service));
        }
        this.doGetErrorHandler(list);
        return list;
    }

    private void doGetErrorHandler(Set<Service> services) {
        ArrayList<Service> extra = new ArrayList<Service>();
        for (Service service : services) {
            Channel channel;
            Processor eh;
            if (!(service instanceof Channel) || !((eh = (channel = (Channel)service).getErrorHandler()) instanceof Service)) continue;
            Service s = (Service)eh;
            extra.add(s);
        }
        if (!extra.isEmpty()) {
            services.addAll(extra);
        }
    }

    protected void doGetRouteServices(List<Service> services) {
        Service service;
        for (Processor proc : this.getRoute().getOnExceptions()) {
            if (!(proc instanceof Service)) continue;
            service = (Service)proc;
            services.add(service);
        }
        for (Processor proc : this.getRoute().getOnCompletions()) {
            if (!(proc instanceof Service)) continue;
            service = (Service)proc;
            services.add(service);
        }
    }

    class MDCHelper
    implements AutoCloseable {
        final Map<String, String> originalContextMap;

        MDCHelper(String routeId) {
            if (RouteService.this.getCamelContext().isUseMDCLogging().booleanValue()) {
                this.originalContextMap = MDC.getCopyOfContextMap();
                MDC.put((String)"camel.contextId", (String)RouteService.this.getCamelContext().getName());
                MDC.put((String)"camel.routeId", (String)routeId);
            } else {
                this.originalContextMap = null;
            }
        }

        @Override
        public void close() {
            if (RouteService.this.getCamelContext().isUseMDCLogging().booleanValue()) {
                if (this.originalContextMap != null) {
                    MDC.setContextMap(this.originalContextMap);
                } else {
                    MDC.clear();
                }
            }
        }
    }
}

