/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.io.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.camel.xml.io.util.XmlStreamInfo;

public class XmlStreamDetector {
    private final XMLStreamReader reader;
    private final XmlStreamInfo information = new XmlStreamInfo();

    public XmlStreamDetector(InputStream xmlStream) throws IOException {
        if (xmlStream == null) {
            this.reader = null;
            this.information.problem = new IllegalArgumentException("XML Stream is null");
            return;
        }
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            this.reader = factory.createXMLStreamReader(xmlStream);
        }
        catch (XMLStreamException e) {
            this.information.problem = e;
            throw new IOException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlStreamInfo information() throws IOException {
        if (this.information.problem != null) {
            return this.information;
        }
        if (7 != this.reader.getEventType()) {
            this.information.problem = new IllegalStateException("Expected START_DOCUMENT");
            return this.information;
        }
        boolean skipComments = false;
        try {
            block7: while (this.reader.hasNext()) {
                int ev = this.reader.next();
                switch (ev) {
                    case 5: {
                        if (skipComments) break;
                        String comment = this.reader.getText();
                        if (comment == null) continue block7;
                        comment.lines().map(String::trim).forEach(l -> {
                            if (l.startsWith("camel-k:")) {
                                this.information.modelines.add((String)l);
                            }
                        });
                        break;
                    }
                    case 1: {
                        if (this.information.rootElementName != null) {
                            return this.information;
                        }
                        skipComments = true;
                        this.information.rootElementName = this.reader.getLocalName();
                        this.information.rootElementNamespace = this.reader.getNamespaceURI();
                        for (int ns = 0; ns < this.reader.getNamespaceCount(); ++ns) {
                            String prefix = this.reader.getNamespacePrefix(ns);
                            this.information.namespaceMapping.put(prefix == null ? "" : prefix, this.reader.getNamespaceURI(ns));
                        }
                        for (int at = 0; at < this.reader.getAttributeCount(); ++at) {
                            QName qn = this.reader.getAttributeName(at);
                            String prefix = qn.getPrefix() == null ? "" : qn.getPrefix().trim();
                            String nsURI = qn.getNamespaceURI() == null ? "" : qn.getNamespaceURI().trim();
                            String value = this.reader.getAttributeValue(at);
                            String localPart = qn.getLocalPart();
                            if (nsURI.isEmpty() || prefix.isEmpty()) {
                                this.information.attributes.put(localPart, value);
                                continue;
                            }
                            this.information.attributes.put("{" + nsURI + "}" + localPart, value);
                            this.information.attributes.put(prefix + ":" + localPart, value);
                        }
                        continue block7;
                    }
                    case 2: 
                    case 8: {
                        if (this.information.rootElementName != null) break;
                        this.information.problem = new IllegalArgumentException("XML Stream is empty");
                        return this.information;
                    }
                }
            }
            return this.information;
        }
        catch (XMLStreamException e) {
            this.information.problem = e;
            return this.information;
        }
    }
}

