/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamcommon;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamcommon.GroupManagementType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class GroupSummary {
    protected final String groupName;
    protected final String groupId;
    protected final String groupExternalId;
    protected final Long memberCount;
    protected final GroupManagementType groupManagementType;

    public GroupSummary(String groupName, String groupId, GroupManagementType groupManagementType, String groupExternalId, Long memberCount) {
        if (groupName == null) {
            throw new IllegalArgumentException("Required value for 'groupName' is null");
        }
        this.groupName = groupName;
        if (groupId == null) {
            throw new IllegalArgumentException("Required value for 'groupId' is null");
        }
        this.groupId = groupId;
        this.groupExternalId = groupExternalId;
        this.memberCount = memberCount;
        if (groupManagementType == null) {
            throw new IllegalArgumentException("Required value for 'groupManagementType' is null");
        }
        this.groupManagementType = groupManagementType;
    }

    public GroupSummary(String groupName, String groupId, GroupManagementType groupManagementType) {
        this(groupName, groupId, groupManagementType, null, null);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public GroupManagementType getGroupManagementType() {
        return this.groupManagementType;
    }

    public String getGroupExternalId() {
        return this.groupExternalId;
    }

    public Long getMemberCount() {
        return this.memberCount;
    }

    public static Builder newBuilder(String groupName, String groupId, GroupManagementType groupManagementType) {
        return new Builder(groupName, groupId, groupManagementType);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.groupName, this.groupId, this.groupExternalId, this.memberCount, this.groupManagementType});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupSummary other = (GroupSummary)obj;
            return !(this.groupName != other.groupName && !this.groupName.equals(other.groupName) || this.groupId != other.groupId && !this.groupId.equals(other.groupId) || this.groupManagementType != other.groupManagementType && !this.groupManagementType.equals((Object)other.groupManagementType) || this.groupExternalId != other.groupExternalId && (this.groupExternalId == null || !this.groupExternalId.equals(other.groupExternalId)) || this.memberCount != other.memberCount && (this.memberCount == null || !this.memberCount.equals(other.memberCount)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends StructSerializer<GroupSummary> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(GroupSummary value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("group_name");
            StoneSerializers.string().serialize(value.groupName, g);
            g.writeFieldName("group_id");
            StoneSerializers.string().serialize(value.groupId, g);
            g.writeFieldName("group_management_type");
            GroupManagementType.Serializer.INSTANCE.serialize(value.groupManagementType, g);
            if (value.groupExternalId != null) {
                g.writeFieldName("group_external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.groupExternalId, g);
            }
            if (value.memberCount != null) {
                g.writeFieldName("member_count");
                StoneSerializers.nullable(StoneSerializers.uInt32()).serialize(value.memberCount, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GroupSummary deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_memberCount;
            String f_groupExternalId;
            GroupManagementType f_groupManagementType;
            String f_groupId;
            String f_groupName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_groupName = null;
                f_groupId = null;
                f_groupManagementType = null;
                f_groupExternalId = null;
                f_memberCount = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("group_name".equals(field)) {
                        f_groupName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("group_id".equals(field)) {
                        f_groupId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("group_management_type".equals(field)) {
                        f_groupManagementType = GroupManagementType.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("group_external_id".equals(field)) {
                        f_groupExternalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("member_count".equals(field)) {
                        f_memberCount = StoneSerializers.nullable(StoneSerializers.uInt32()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_groupName == null) {
                    throw new JsonParseException(p, "Required field \"group_name\" missing.");
                }
                if (f_groupId == null) {
                    throw new JsonParseException(p, "Required field \"group_id\" missing.");
                }
                if (f_groupManagementType == null) {
                    throw new JsonParseException(p, "Required field \"group_management_type\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GroupSummary value = new GroupSummary(f_groupName, f_groupId, f_groupManagementType, f_groupExternalId, f_memberCount);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String groupName;
        protected final String groupId;
        protected final GroupManagementType groupManagementType;
        protected String groupExternalId;
        protected Long memberCount;

        protected Builder(String groupName, String groupId, GroupManagementType groupManagementType) {
            if (groupName == null) {
                throw new IllegalArgumentException("Required value for 'groupName' is null");
            }
            this.groupName = groupName;
            if (groupId == null) {
                throw new IllegalArgumentException("Required value for 'groupId' is null");
            }
            this.groupId = groupId;
            if (groupManagementType == null) {
                throw new IllegalArgumentException("Required value for 'groupManagementType' is null");
            }
            this.groupManagementType = groupManagementType;
            this.groupExternalId = null;
            this.memberCount = null;
        }

        public Builder withGroupExternalId(String groupExternalId) {
            this.groupExternalId = groupExternalId;
            return this;
        }

        public Builder withMemberCount(Long memberCount) {
            this.memberCount = memberCount;
            return this;
        }

        public GroupSummary build() {
            return new GroupSummary(this.groupName, this.groupId, this.groupManagementType, this.groupExternalId, this.memberCount);
        }
    }
}

