/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2;

import com.dropbox.core.DbxException;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.oauth.DbxCredential;
import com.dropbox.core.oauth.DbxRefreshResult;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.DbxTeamClientV2Base;
import com.dropbox.core.v2.common.PathRoot;
import java.util.List;

public class DbxTeamClientV2
extends DbxTeamClientV2Base {
    private final DbxCredential credential;

    public DbxTeamClientV2(DbxRequestConfig requestConfig, String accessToken) {
        this(requestConfig, accessToken, DbxHost.DEFAULT);
    }

    public DbxTeamClientV2(DbxRequestConfig requestConfig, String accessToken, DbxHost host) {
        this(requestConfig, accessToken, host, null);
    }

    public DbxTeamClientV2(DbxRequestConfig requestConfig, DbxCredential credential) {
        this(requestConfig, credential, DbxHost.DEFAULT, null);
    }

    public DbxTeamClientV2(DbxRequestConfig requestConfig, String accessToken, DbxHost host, String userId) {
        this(requestConfig, new DbxCredential(accessToken), host, userId);
    }

    public DbxTeamClientV2(DbxRequestConfig requestConfig, DbxCredential credential, DbxHost host, String userId) {
        super(new DbxTeamRawClientV2(requestConfig, credential, host, userId, null, null, null));
        this.credential = credential;
    }

    public DbxRefreshResult refreshAccessToken() throws DbxException {
        return this._client.refreshAccessToken();
    }

    public DbxClientV2 asMember(String memberId) {
        if (memberId == null) {
            throw new IllegalArgumentException("'memberId' should not be null");
        }
        DbxTeamRawClientV2 asMemberClient = new DbxTeamRawClientV2(this._client.getRequestConfig(), this.credential, this._client.getHost(), this._client.getUserId(), memberId, null, null);
        return new DbxClientV2(asMemberClient);
    }

    public DbxClientV2 asAdmin(String adminId) {
        if (adminId == null) {
            throw new IllegalArgumentException("'adminId' should not be null");
        }
        DbxTeamRawClientV2 asAdminClient = new DbxTeamRawClientV2(this._client.getRequestConfig(), this.credential, this._client.getHost(), this._client.getUserId(), null, adminId, null);
        return new DbxClientV2(asAdminClient);
    }

    private static final class DbxTeamRawClientV2
    extends DbxRawClientV2 {
        private final DbxCredential credential;
        private final String memberId;
        private final String adminId;

        private DbxTeamRawClientV2(DbxRequestConfig requestConfig, DbxCredential credential, DbxHost host, String userId, String memberId, String adminId, PathRoot pathRoot) {
            super(requestConfig, host, userId, pathRoot);
            if (credential == null) {
                throw new NullPointerException("credential");
            }
            this.credential = credential;
            this.memberId = memberId;
            this.adminId = adminId;
        }

        @Override
        public DbxRefreshResult refreshAccessToken() throws DbxException {
            this.credential.refresh(this.getRequestConfig());
            return new DbxRefreshResult(this.credential.getAccessToken(), this.credential.getExpiresAt());
        }

        @Override
        boolean canRefreshAccessToken() {
            return this.credential.getRefreshToken() != null;
        }

        @Override
        boolean needsRefreshAccessToken() {
            return this.canRefreshAccessToken() && this.credential.aboutToExpire();
        }

        @Override
        protected void addAuthHeaders(List<HttpRequestor.Header> headers) {
            DbxRequestUtil.removeAuthHeader(headers);
            DbxRequestUtil.addAuthHeader(headers, this.credential.getAccessToken());
            if (this.memberId != null) {
                DbxRequestUtil.addSelectUserHeader(headers, this.memberId);
            }
            if (this.adminId != null) {
                DbxRequestUtil.addSelectAdminHeader(headers, this.adminId);
            }
        }

        @Override
        protected DbxRawClientV2 withPathRoot(PathRoot pathRoot) {
            return new DbxTeamRawClientV2(this.getRequestConfig(), this.credential, this.getHost(), this.getUserId(), this.memberId, this.adminId, pathRoot);
        }
    }
}

