/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.reifier.ProcessorReifier;

public class ChoiceReifier
extends ProcessorReifier<ChoiceDefinition> {
    public ChoiceReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ProcessorDefinition)ChoiceDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        ArrayList<FilterProcessor> filters = new ArrayList<FilterProcessor>();
        for (WhenDefinition whenClause : ((ChoiceDefinition)this.definition).getWhenClauses()) {
            Predicate pre;
            ExpressionDefinition exp = whenClause.getExpression();
            if (exp.getExpressionType() != null) {
                exp = exp.getExpressionType();
            }
            if ((pre = exp.getPredicate()) instanceof ExpressionClause) {
                ExpressionFactory model;
                ExpressionClause clause = (ExpressionClause)pre;
                if (clause.getExpressionType() != null && (model = clause.getExpressionType()) instanceof ExpressionDefinition) {
                    whenClause.setExpression((ExpressionDefinition)model);
                }
                exp = whenClause.getExpression();
            }
            FilterProcessor filter = (FilterProcessor)this.createProcessor(whenClause);
            filters.add(filter);
        }
        Processor otherwiseProcessor = null;
        if (((ChoiceDefinition)this.definition).getOtherwise() != null) {
            otherwiseProcessor = this.createProcessor(((ChoiceDefinition)this.definition).getOtherwise());
        }
        return new ChoiceProcessor(filters, otherwiseProcessor);
    }
}

