/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.clouddocs.GenericErrorTag;
import com.dropbox.core.v2.clouddocs.LockingErrorTag;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class LockingErrorTagUnion {
    public static final LockingErrorTagUnion OTHER = new LockingErrorTagUnion().withTag(Tag.OTHER);
    private Tag _tag;
    private LockingErrorTag lockingErrorValue;
    private GenericErrorTag genericErrorValue;

    private LockingErrorTagUnion() {
    }

    private LockingErrorTagUnion withTag(Tag _tag) {
        LockingErrorTagUnion result = new LockingErrorTagUnion();
        result._tag = _tag;
        return result;
    }

    private LockingErrorTagUnion withTagAndLockingError(Tag _tag, LockingErrorTag lockingErrorValue) {
        LockingErrorTagUnion result = new LockingErrorTagUnion();
        result._tag = _tag;
        result.lockingErrorValue = lockingErrorValue;
        return result;
    }

    private LockingErrorTagUnion withTagAndGenericError(Tag _tag, GenericErrorTag genericErrorValue) {
        LockingErrorTagUnion result = new LockingErrorTagUnion();
        result._tag = _tag;
        result.genericErrorValue = genericErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isLockingError() {
        return this._tag == Tag.LOCKING_ERROR;
    }

    public static LockingErrorTagUnion lockingError(LockingErrorTag value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new LockingErrorTagUnion().withTagAndLockingError(Tag.LOCKING_ERROR, value);
    }

    public LockingErrorTag getLockingErrorValue() {
        if (this._tag != Tag.LOCKING_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.LOCKING_ERROR, but was Tag." + this._tag.name());
        }
        return this.lockingErrorValue;
    }

    public boolean isGenericError() {
        return this._tag == Tag.GENERIC_ERROR;
    }

    public static LockingErrorTagUnion genericError(GenericErrorTag value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new LockingErrorTagUnion().withTagAndGenericError(Tag.GENERIC_ERROR, value);
    }

    public GenericErrorTag getGenericErrorValue() {
        if (this._tag != Tag.GENERIC_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.GENERIC_ERROR, but was Tag." + this._tag.name());
        }
        return this.genericErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.lockingErrorValue, this.genericErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LockingErrorTagUnion) {
            LockingErrorTagUnion other = (LockingErrorTagUnion)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case LOCKING_ERROR: {
                    return this.lockingErrorValue == other.lockingErrorValue || this.lockingErrorValue.equals((Object)other.lockingErrorValue);
                }
                case GENERIC_ERROR: {
                    return this.genericErrorValue == other.genericErrorValue || this.genericErrorValue.equals((Object)other.genericErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<LockingErrorTagUnion> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LockingErrorTagUnion value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case LOCKING_ERROR: {
                    g.writeStartObject();
                    this.writeTag("locking_error", g);
                    g.writeFieldName("locking_error");
                    LockingErrorTag.Serializer.INSTANCE.serialize(value.lockingErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                case GENERIC_ERROR: {
                    g.writeStartObject();
                    this.writeTag("generic_error", g);
                    g.writeFieldName("generic_error");
                    GenericErrorTag.Serializer.INSTANCE.serialize(value.genericErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public LockingErrorTagUnion deserialize(JsonParser p) throws IOException, JsonParseException {
            LockingErrorTagUnion value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("locking_error".equals(tag)) {
                LockingErrorTag fieldValue = null;
                Serializer.expectField("locking_error", p);
                fieldValue = LockingErrorTag.Serializer.INSTANCE.deserialize(p);
                value = LockingErrorTagUnion.lockingError(fieldValue);
            } else if ("generic_error".equals(tag)) {
                GenericErrorTag fieldValue = null;
                Serializer.expectField("generic_error", p);
                fieldValue = GenericErrorTag.Serializer.INSTANCE.deserialize(p);
                value = LockingErrorTagUnion.genericError(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        LOCKING_ERROR,
        GENERIC_ERROR,
        OTHER;

    }
}

