/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server.persistence;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import oadd.org.apache.jute.BinaryOutputArchive;
import oadd.org.apache.jute.InputArchive;
import oadd.org.apache.jute.OutputArchive;
import oadd.org.apache.zookeeper.server.DataTree;
import oadd.org.apache.zookeeper.server.persistence.FileHeader;
import oadd.org.apache.zookeeper.server.persistence.SnapShot;
import oadd.org.apache.zookeeper.server.persistence.Util;
import oadd.org.apache.zookeeper.server.util.SerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSnap
implements SnapShot {
    File snapDir;
    private volatile boolean close = false;
    private static final int VERSION = 2;
    private static final long dbId = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(FileSnap.class);
    public static final int SNAP_MAGIC = ByteBuffer.wrap("ZKSN".getBytes()).getInt();
    public static final String SNAPSHOT_FILE_PREFIX = "snapshot";

    public FileSnap(File snapDir) {
        this.snapDir = snapDir;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long deserialize(DataTree dt, Map<Long, Integer> sessions) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deserialize(DataTree dt, Map<Long, Integer> sessions, InputArchive ia) throws IOException {
        FileHeader header = new FileHeader();
        header.deserialize(ia, "fileheader");
        if (header.getMagic() != SNAP_MAGIC) {
            throw new IOException("mismatching magic headers " + header.getMagic() + " !=  " + SNAP_MAGIC);
        }
        SerializeUtils.deserializeSnapshot(dt, ia, sessions);
    }

    @Override
    public File findMostRecentSnapshot() throws IOException {
        List<File> files = this.findNValidSnapshots(1);
        if (files.size() == 0) {
            return null;
        }
        return files.get(0);
    }

    private List<File> findNValidSnapshots(int n) throws IOException {
        List<File> files = Util.sortDataDir(this.snapDir.listFiles(), SNAPSHOT_FILE_PREFIX, false);
        int count = 0;
        ArrayList<File> list = new ArrayList<File>();
        for (File f : files) {
            try {
                if (!Util.isValidSnapshot(f)) continue;
                list.add(f);
                if (++count != n) continue;
                break;
            }
            catch (IOException e) {
                LOG.info("invalid snapshot " + f, e);
            }
        }
        return list;
    }

    public List<File> findNRecentSnapshots(int n) throws IOException {
        List<File> files = Util.sortDataDir(this.snapDir.listFiles(), SNAPSHOT_FILE_PREFIX, false);
        int count = 0;
        ArrayList<File> list = new ArrayList<File>();
        for (File f : files) {
            if (count == n) break;
            if (Util.getZxidFromName(f.getName(), SNAPSHOT_FILE_PREFIX) == -1L) continue;
            ++count;
            list.add(f);
        }
        return list;
    }

    protected void serialize(DataTree dt, Map<Long, Integer> sessions, OutputArchive oa, FileHeader header) throws IOException {
        if (header == null) {
            throw new IllegalStateException("Snapshot's not open for writing: uninitialized header");
        }
        header.serialize(oa, "fileheader");
        SerializeUtils.serializeSnapshot(dt, oa, sessions);
    }

    @Override
    public synchronized void serialize(DataTree dt, Map<Long, Integer> sessions, File snapShot) throws IOException {
        block25: {
            if (!this.close) {
                try (BufferedOutputStream sessOS = new BufferedOutputStream(new FileOutputStream(snapShot));
                     CheckedOutputStream crcOut = new CheckedOutputStream(sessOS, new Adler32());){
                    BinaryOutputArchive oa = BinaryOutputArchive.getArchive(crcOut);
                    FileHeader header = new FileHeader(SNAP_MAGIC, 2, -1L);
                    this.serialize(dt, sessions, oa, header);
                    long val = crcOut.getChecksum().getValue();
                    oa.writeLong(val, "val");
                    oa.writeString("/", "path");
                    ((OutputStream)sessOS).flush();
                    break block25;
                }
            }
            throw new IOException("FileSnap has already been closed");
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.close = true;
    }
}

