/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.util;

import oadd.org.apache.hadoop.HadoopIllegalArgumentException;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public class LightWeightResizableGSet<K, E extends K>
extends LightWeightGSet<K, E> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private int capacity;
    private final float loadFactor;
    private int threshold;

    public LightWeightResizableGSet(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new HadoopIllegalArgumentException("Illegal initial capacity: " + initCapacity);
        }
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new HadoopIllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        this.capacity = LightWeightResizableGSet.actualArrayLength(initCapacity);
        this.hash_mask = this.capacity - 1;
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.entries = new LightWeightGSet.LinkedElement[this.capacity];
    }

    public LightWeightResizableGSet() {
        this(16, 0.75f);
    }

    public LightWeightResizableGSet(int initCapacity) {
        this(initCapacity, 0.75f);
    }

    @Override
    public E put(E element) {
        E existing = super.put(element);
        this.expandIfNecessary();
        return existing;
    }

    protected void resize(int cap) {
        int newCapacity = LightWeightResizableGSet.actualArrayLength(cap);
        if (newCapacity == this.capacity) {
            return;
        }
        this.capacity = newCapacity;
        this.threshold = (int)((float)this.capacity * this.loadFactor);
        this.hash_mask = this.capacity - 1;
        LightWeightGSet.LinkedElement[] oldEntries = this.entries;
        this.entries = new LightWeightGSet.LinkedElement[this.capacity];
        for (int i = 0; i < oldEntries.length; ++i) {
            LightWeightGSet.LinkedElement e = oldEntries[i];
            while (e != null) {
                LightWeightGSet.LinkedElement next = e.getNext();
                int index = this.getIndex(e);
                e.setNext(this.entries[index]);
                this.entries[index] = e;
                e = next;
            }
        }
    }

    protected void expandIfNecessary() {
        if (this.size > this.threshold && this.capacity < 0x40000000) {
            this.resize(this.capacity * 2);
        }
    }
}

