/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import oadd.com.google.common.util.concurrent.MoreExecutors;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.util.SemaphoredDelegatingExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class BlockingThreadPoolExecutorService
extends SemaphoredDelegatingExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingThreadPoolExecutorService.class);
    private static final AtomicInteger POOLNUMBER = new AtomicInteger(1);
    private final ThreadPoolExecutor eventProcessingExecutor;

    static ThreadFactory getNamedThreadFactory(final String prefix) {
        SecurityManager s2 = System.getSecurityManager();
        final ThreadGroup threadGroup = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);
            private final int poolNum = BlockingThreadPoolExecutorService.access$000().getAndIncrement();
            private final ThreadGroup group = threadGroup;

            @Override
            public Thread newThread(Runnable r) {
                String name = prefix + "-pool" + this.poolNum + "-t" + this.threadNumber.getAndIncrement();
                return new Thread(this.group, r, name);
            }
        };
    }

    public static ThreadFactory newDaemonThreadFactory(String prefix) {
        final ThreadFactory namedFactory = BlockingThreadPoolExecutorService.getNamedThreadFactory(prefix);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = namedFactory.newThread(r);
                if (!t.isDaemon()) {
                    t.setDaemon(true);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        };
    }

    private BlockingThreadPoolExecutorService(int permitCount, ThreadPoolExecutor eventProcessingExecutor) {
        super(MoreExecutors.listeningDecorator(eventProcessingExecutor), permitCount, false);
        this.eventProcessingExecutor = eventProcessingExecutor;
    }

    public static BlockingThreadPoolExecutorService newInstance(int activeTasks, int waitingTasks, long keepAliveTime, TimeUnit unit, String prefixName) {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(waitingTasks + activeTasks);
        ThreadPoolExecutor eventProcessingExecutor = new ThreadPoolExecutor(activeTasks, activeTasks, keepAliveTime, unit, workQueue, BlockingThreadPoolExecutorService.newDaemonThreadFactory(prefixName), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                LOG.error("Could not submit task to executor {}", (Object)executor.toString());
            }
        });
        eventProcessingExecutor.allowCoreThreadTimeOut(true);
        return new BlockingThreadPoolExecutorService(waitingTasks + activeTasks, eventProcessingExecutor);
    }

    int getActiveCount() {
        return this.eventProcessingExecutor.getActiveCount();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("BlockingThreadPoolExecutorService{");
        sb.append(super.toString());
        sb.append(", activeCount=").append(this.getActiveCount());
        sb.append('}');
        return sb.toString();
    }

    static /* synthetic */ AtomicInteger access$000() {
        return POOLNUMBER;
    }
}

