/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.security.token.delegation;

import java.util.Collection;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.io.Text;
import oadd.org.apache.hadoop.security.token.Token;
import oadd.org.apache.hadoop.security.token.TokenIdentifier;
import oadd.org.apache.hadoop.security.token.TokenSelector;
import oadd.org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class AbstractDelegationTokenSelector<TokenIdent extends AbstractDelegationTokenIdentifier>
implements TokenSelector<TokenIdent> {
    private Text kindName;

    protected AbstractDelegationTokenSelector(Text kindName) {
        this.kindName = kindName;
    }

    @Override
    public Token<TokenIdent> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (!this.kindName.equals(token.getKind()) || !service.equals(token.getService())) continue;
            return token;
        }
        return null;
    }
}

