/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.fs.AbstractFileSystem;
import oadd.org.apache.hadoop.fs.CreateFlag;
import oadd.org.apache.hadoop.fs.FSDataOutputStream;
import oadd.org.apache.hadoop.fs.FileContext;
import oadd.org.apache.hadoop.fs.FileSystem;
import oadd.org.apache.hadoop.fs.FsServerDefaults;
import oadd.org.apache.hadoop.fs.Options;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.fs.permission.FsPermission;
import oadd.org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class FSDataOutputStreamBuilder<S extends FSDataOutputStream, B extends FSDataOutputStreamBuilder<S, B>> {
    private final FileSystem fs;
    private final Path path;
    private FsPermission permission = null;
    private int bufferSize;
    private short replication;
    private long blockSize;
    private boolean recursive = false;
    private final EnumSet<CreateFlag> flags = EnumSet.noneOf(CreateFlag.class);
    private Progressable progress = null;
    private Options.ChecksumOpt checksumOpt = null;
    private final Configuration options = new Configuration(false);
    private final Set<String> mandatoryKeys = new HashSet<String>();

    protected abstract B getThisBuilder();

    FSDataOutputStreamBuilder(@Nonnull FileContext fc, @Nonnull Path p) throws IOException {
        Preconditions.checkNotNull(fc);
        Preconditions.checkNotNull(p);
        this.fs = null;
        this.path = p;
        AbstractFileSystem afs = fc.getFSofPath(p);
        FsServerDefaults defaults = afs.getServerDefaults(p);
        this.bufferSize = defaults.getFileBufferSize();
        this.replication = defaults.getReplication();
        this.blockSize = defaults.getBlockSize();
    }

    protected FSDataOutputStreamBuilder(@Nonnull FileSystem fileSystem, @Nonnull Path p) {
        Preconditions.checkNotNull(fileSystem);
        Preconditions.checkNotNull(p);
        this.fs = fileSystem;
        this.path = p;
        this.bufferSize = this.fs.getConf().getInt("oadd.io.file.buffer.size", 4096);
        this.replication = this.fs.getDefaultReplication(this.path);
        this.blockSize = this.fs.getDefaultBlockSize(p);
    }

    protected FileSystem getFS() {
        Preconditions.checkNotNull(this.fs);
        return this.fs;
    }

    protected Path getPath() {
        return this.path;
    }

    protected FsPermission getPermission() {
        if (this.permission == null) {
            this.permission = FsPermission.getFileDefault();
        }
        return this.permission;
    }

    public B permission(@Nonnull FsPermission perm) {
        Preconditions.checkNotNull(perm);
        this.permission = perm;
        return this.getThisBuilder();
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    public B bufferSize(int bufSize) {
        this.bufferSize = bufSize;
        return this.getThisBuilder();
    }

    protected short getReplication() {
        return this.replication;
    }

    public B replication(short replica) {
        this.replication = replica;
        return this.getThisBuilder();
    }

    protected long getBlockSize() {
        return this.blockSize;
    }

    public B blockSize(long blkSize) {
        this.blockSize = blkSize;
        return this.getThisBuilder();
    }

    protected boolean isRecursive() {
        return this.recursive;
    }

    public B recursive() {
        this.recursive = true;
        return this.getThisBuilder();
    }

    protected Progressable getProgress() {
        return this.progress;
    }

    public B progress(@Nonnull Progressable prog) {
        Preconditions.checkNotNull(prog);
        this.progress = prog;
        return this.getThisBuilder();
    }

    protected EnumSet<CreateFlag> getFlags() {
        return this.flags;
    }

    public B create() {
        this.flags.add(CreateFlag.CREATE);
        return this.getThisBuilder();
    }

    public B overwrite(boolean overwrite) {
        if (overwrite) {
            this.flags.add(CreateFlag.OVERWRITE);
        } else {
            this.flags.remove((Object)CreateFlag.OVERWRITE);
        }
        return this.getThisBuilder();
    }

    public B append() {
        this.flags.add(CreateFlag.APPEND);
        return this.getThisBuilder();
    }

    protected Options.ChecksumOpt getChecksumOpt() {
        return this.checksumOpt;
    }

    public B checksumOpt(@Nonnull Options.ChecksumOpt chksumOpt) {
        Preconditions.checkNotNull(chksumOpt);
        this.checksumOpt = chksumOpt;
        return this.getThisBuilder();
    }

    public B opt(@Nonnull String key, @Nonnull String value) {
        this.mandatoryKeys.remove(key);
        this.options.set(key, value);
        return this.getThisBuilder();
    }

    public B opt(@Nonnull String key, boolean value) {
        this.mandatoryKeys.remove(key);
        this.options.setBoolean(key, value);
        return this.getThisBuilder();
    }

    public B opt(@Nonnull String key, int value) {
        this.mandatoryKeys.remove(key);
        this.options.setInt(key, value);
        return this.getThisBuilder();
    }

    public B opt(@Nonnull String key, float value) {
        this.mandatoryKeys.remove(key);
        this.options.setFloat(key, value);
        return this.getThisBuilder();
    }

    public B opt(@Nonnull String key, double value) {
        this.mandatoryKeys.remove(key);
        this.options.setDouble(key, value);
        return this.getThisBuilder();
    }

    public B opt(@Nonnull String key, String ... values) {
        this.mandatoryKeys.remove(key);
        this.options.setStrings(key, values);
        return this.getThisBuilder();
    }

    public B must(@Nonnull String key, @Nonnull String value) {
        this.mandatoryKeys.add(key);
        this.options.set(key, value);
        return this.getThisBuilder();
    }

    public B must(@Nonnull String key, boolean value) {
        this.mandatoryKeys.add(key);
        this.options.setBoolean(key, value);
        return this.getThisBuilder();
    }

    public B must(@Nonnull String key, int value) {
        this.mandatoryKeys.add(key);
        this.options.setInt(key, value);
        return this.getThisBuilder();
    }

    public B must(@Nonnull String key, float value) {
        this.mandatoryKeys.add(key);
        this.options.setFloat(key, value);
        return this.getThisBuilder();
    }

    public B must(@Nonnull String key, double value) {
        this.mandatoryKeys.add(key);
        this.options.setDouble(key, value);
        return this.getThisBuilder();
    }

    public B must(@Nonnull String key, String ... values) {
        this.mandatoryKeys.add(key);
        this.options.setStrings(key, values);
        return this.getThisBuilder();
    }

    protected Configuration getOptions() {
        return this.options;
    }

    @VisibleForTesting
    protected Set<String> getMandatoryKeys() {
        return Collections.unmodifiableSet(this.mandatoryKeys);
    }

    public abstract S build() throws IllegalArgumentException, IOException;
}

