/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.util.ArrayList;
import java.util.List;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReader;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractTupleWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.ObjectArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.dummy.DummyArrayWriter;
import oadd.org.apache.drill.exec.vector.complex.AbstractMapVector;
import oadd.org.apache.drill.exec.vector.complex.MapVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedMapVector;

public abstract class MapWriter
extends AbstractTupleWriter {
    protected final ColumnMetadata mapColumnSchema;

    protected MapWriter(ColumnMetadata schema, List<AbstractObjectWriter> writers) {
        super(schema.tupleSchema(), writers);
        this.mapColumnSchema = schema;
    }

    public static AbstractTupleWriter.TupleObjectWriter buildMap(ColumnMetadata schema, MapVector vector, List<AbstractObjectWriter> writers) {
        MapWriter mapWriter = vector != null ? new SingleMapWriter(schema, vector, writers) : new DummyMapWriter(schema, writers);
        return new AbstractTupleWriter.TupleObjectWriter(mapWriter);
    }

    public static AbstractArrayWriter.ArrayObjectWriter buildMapArray(ColumnMetadata schema, RepeatedMapVector mapVector, List<AbstractObjectWriter> writers) {
        MapWriter mapWriter = mapVector != null ? new ArrayMapWriter(schema, writers) : new DummyArrayMapWriter(schema, writers);
        AbstractTupleWriter.TupleObjectWriter mapArray = new AbstractTupleWriter.TupleObjectWriter(mapWriter);
        AbstractArrayWriter arrayWriter = mapVector != null ? new ObjectArrayWriter(schema, mapVector.getOffsetVector(), mapArray) : new DummyArrayWriter(schema, mapArray);
        return new AbstractArrayWriter.ArrayObjectWriter(arrayWriter);
    }

    public static AbstractObjectWriter buildMapWriter(ColumnMetadata schema, AbstractMapVector vector, List<AbstractObjectWriter> writers) {
        if (schema.isArray()) {
            return MapWriter.buildMapArray(schema, (RepeatedMapVector)vector, writers);
        }
        return MapWriter.buildMap(schema, (MapVector)vector, writers);
    }

    public static AbstractObjectWriter buildMapWriter(ColumnMetadata schema, AbstractMapVector vector) {
        assert (schema.tupleSchema().size() == 0);
        return MapWriter.buildMapWriter(schema, vector, new ArrayList<AbstractObjectWriter>());
    }

    @Override
    public ColumnMetadata schema() {
        return this.mapColumnSchema;
    }

    protected static class DummyArrayMapWriter
    extends MapWriter {
        protected DummyArrayMapWriter(ColumnMetadata schema, List<AbstractObjectWriter> writers) {
            super(schema, writers);
        }

        @Override
        public boolean isProjected() {
            return false;
        }

        @Override
        public void copy(ColumnReader from) {
        }
    }

    protected static class DummyMapWriter
    extends MapWriter {
        protected DummyMapWriter(ColumnMetadata schema, List<AbstractObjectWriter> writers) {
            super(schema, writers);
        }

        @Override
        public boolean isProjected() {
            return false;
        }

        @Override
        public void copy(ColumnReader from) {
        }
    }

    protected static class ArrayMapWriter
    extends MapWriter {
        protected ArrayMapWriter(ColumnMetadata schema, List<AbstractObjectWriter> writers) {
            super(schema, writers);
        }

        @Override
        public void bindIndex(ColumnWriterIndex index) {
            this.bindIndex(index, new AbstractTupleWriter.MemberWriterIndex(index));
        }

        @Override
        public boolean isProjected() {
            return true;
        }
    }

    protected static class SingleMapWriter
    extends MapWriter {
        private final MapVector mapVector;

        protected SingleMapWriter(ColumnMetadata schema, MapVector vector, List<AbstractObjectWriter> writers) {
            super(schema, writers);
            this.mapVector = vector;
        }

        @Override
        public void endWrite() {
            super.endWrite();
            this.mapVector.setMapValueCount(this.vectorIndex.vectorIndex());
        }

        @Override
        public void preRollover() {
            super.preRollover();
            this.mapVector.setMapValueCount(this.vectorIndex.rowStartIndex());
        }

        @Override
        public boolean isProjected() {
            return true;
        }
    }
}

