/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.text.MessageFormat;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import oadd.io.netty.handler.ssl.SslContext;
import oadd.io.netty.handler.ssl.SslProvider;
import oadd.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import oadd.org.apache.drill.common.exceptions.DrillException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSLConfig {
    private static final Logger logger = LoggerFactory.getLogger(SSLConfig.class);
    public static final String DEFAULT_SSL_PROVIDER = "JDK";
    public static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    public static final int DEFAULT_SSL_HANDSHAKE_TIMEOUT_MS = 10000;
    protected SslContext nettySslContext;
    protected SSLContext jdkSSlContext;
    private static final boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    private static final boolean isMacOs = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    public static final String HADOOP_SSL_CONF_TPL_KEY = "hadoop.ssl.{0}.conf";
    public static final String HADOOP_SSL_KEYSTORE_LOCATION_TPL_KEY = "ssl.{0}.keystore.location";
    public static final String HADOOP_SSL_KEYSTORE_PASSWORD_TPL_KEY = "ssl.{0}.keystore.password";
    public static final String HADOOP_SSL_KEYSTORE_TYPE_TPL_KEY = "ssl.{0}.keystore.type";
    public static final String HADOOP_SSL_KEYSTORE_KEYPASSWORD_TPL_KEY = "ssl.{0}.keystore.keypassword";
    public static final String HADOOP_SSL_TRUSTSTORE_LOCATION_TPL_KEY = "ssl.{0}.truststore.location";
    public static final String HADOOP_SSL_TRUSTSTORE_PASSWORD_TPL_KEY = "ssl.{0}.truststore.password";
    public static final String HADOOP_SSL_TRUSTSTORE_TYPE_TPL_KEY = "ssl.{0}.truststore.type";

    public abstract void validateKeyStore() throws DrillException;

    public abstract SslContext initNettySslContext() throws DrillException;

    public abstract SSLContext initJDKSSLContext() throws DrillException;

    public abstract boolean isUserSslEnabled();

    public abstract boolean isHttpsEnabled();

    public abstract String getKeyStoreType();

    public abstract String getKeyStorePath();

    public abstract String getKeyStorePassword();

    public abstract String getKeyPassword();

    public abstract String getTrustStoreType();

    public abstract boolean hasTrustStorePath();

    public abstract String getTrustStorePath();

    public abstract boolean hasTrustStorePassword();

    public abstract String getTrustStorePassword();

    public abstract String getProtocol();

    public abstract SslProvider getProvider();

    public abstract int getHandshakeTimeout();

    public abstract Mode getMode();

    public abstract boolean disableHostVerification();

    public abstract boolean disableCertificateVerification();

    public abstract boolean useSystemTrustStore();

    public abstract boolean isSslValid();

    public SslContext getNettySslContext() {
        return this.nettySslContext;
    }

    public TrustManagerFactory initializeTrustManagerFactory() throws DrillException {
        TrustManagerFactory tmf;
        KeyStore ts = null;
        try {
            String trustStoreType = this.getTrustStoreType();
            if ((isWindows || isMacOs) && this.useSystemTrustStore()) {
                logger.debug("Initializing System truststore.");
                ts = KeyStore.getInstance(!trustStoreType.isEmpty() ? trustStoreType : KeyStore.getDefaultType());
                ts.load(null, null);
            } else if (!this.getTrustStorePath().isEmpty()) {
                logger.debug("Initializing truststore {}.", (Object)this.getTrustStorePath());
                ts = KeyStore.getInstance(!trustStoreType.isEmpty() ? trustStoreType : KeyStore.getDefaultType());
                FileInputStream tsStream = new FileInputStream(this.getTrustStorePath());
                ts.load(tsStream, this.getTrustStorePassword().toCharArray());
            } else {
                logger.debug("Initializing default truststore.");
            }
            tmf = this.disableCertificateVerification() ? InsecureTrustManagerFactory.INSTANCE : TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
        }
        catch (Exception e) {
            throw new DrillException("Exception while initializing the truststore: [" + e.getMessage() + "]. ", e);
        }
        return tmf;
    }

    public KeyManagerFactory initializeKeyManagerFactory() throws DrillException {
        KeyManagerFactory kmf;
        String keyStorePath = this.getKeyStorePath();
        String keyStorePassword = this.getKeyStorePassword();
        String keyStoreType = this.getKeyStoreType();
        try {
            if (keyStorePath.isEmpty()) {
                throw new DrillException("No Keystore provided.");
            }
            KeyStore ks = KeyStore.getInstance(!keyStoreType.isEmpty() ? keyStoreType : KeyStore.getDefaultType());
            FileInputStream ksStream = new FileInputStream(keyStorePath);
            if (keyStorePassword.isEmpty()) {
                throw new DrillException("The Keystore password cannot be empty.");
            }
            ks.load(ksStream, keyStorePassword.toCharArray());
            if (ks.size() == 0) {
                throw new DrillException("The Keystore has no entries.");
            }
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, this.getKeyPassword().toCharArray());
        }
        catch (Exception e) {
            throw new DrillException("Exception while initializing the keystore: [" + e.getMessage() + "]. ");
        }
        return kmf;
    }

    public void initContext() throws DrillException {
        if ((isWindows || isMacOs) && this.useSystemTrustStore()) {
            this.initJDKSSLContext();
            logger.debug("Initialized Windows/MacOs SSL context using JDK.");
        } else {
            this.initNettySslContext();
            logger.debug("Initialized SSL context.");
        }
    }

    public SSLEngine createSSLEngine(BufferAllocator allocator, String peerHost, int peerPort) {
        SSLEngine engine;
        if ((isWindows || isMacOs) && this.useSystemTrustStore()) {
            if (peerHost != null) {
                engine = this.jdkSSlContext.createSSLEngine(peerHost, peerPort);
                logger.debug("Initializing Windows/MacOs SSLEngine with hostname.");
            } else {
                engine = this.jdkSSlContext.createSSLEngine();
                logger.debug("Initializing Windows/MacOs SSLEngine with no hostname.");
            }
        } else if (peerHost != null) {
            engine = this.nettySslContext.newEngine(allocator.getAsByteBufAllocator(), peerHost, peerPort);
            logger.debug("Initializing SSLEngine with hostname.");
        } else {
            engine = this.nettySslContext.newEngine(allocator.getAsByteBufAllocator());
            logger.debug("Initializing SSLEngine with no hostname.");
        }
        return engine;
    }

    abstract Configuration getHadoopConfig();

    String getPassword(String hadoopName) {
        String value = null;
        if (this.getHadoopConfig() != null) {
            try {
                char[] password = this.getHadoopConfig().getPassword(hadoopName);
                if (password != null) {
                    value = String.valueOf(password);
                }
            }
            catch (IOException e) {
                logger.warn("Unable to obtain password {} from CredentialProvider API: {}", (Object)hadoopName, (Object)e.getMessage());
            }
        }
        return value;
    }

    String resolveHadoopPropertyName(String nameTemplate, Mode mode) {
        return MessageFormat.format(nameTemplate, mode.toString().toLowerCase());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSL is ").append(this.isUserSslEnabled() ? "" : " not ").append("enabled.\n");
        sb.append("HTTPS is ").append(this.isHttpsEnabled() ? "" : " not ").append("enabled.\n");
        if (this.isUserSslEnabled() || this.isHttpsEnabled()) {
            sb.append("SSL Configuration :").append("OS:").append(System.getProperty("os.name")).append("\n\tUsing system trust store: ").append(this.useSystemTrustStore()).append("\n\tprotocol: ").append(this.getProtocol()).append("\n\tkeyStoreType: ").append(this.getKeyStoreType()).append("\n\tkeyStorePath: ").append(this.getKeyStorePath()).append("\n\tkeyStorePassword: ").append(this.getPrintablePassword(this.getKeyStorePassword())).append("\n\tkeyPassword: ").append(this.getPrintablePassword(this.getKeyPassword())).append("\n\ttrustStoreType: ").append(this.getTrustStoreType()).append("\n\ttrustStorePath: ").append(this.getTrustStorePath()).append("\n\ttrustStorePassword: ").append(this.getPrintablePassword(this.getTrustStorePassword())).append("\n\thandshakeTimeout: ").append(this.getHandshakeTimeout()).append("\n\tdisableHostVerification: ").append(this.disableHostVerification()).append("\n\tdisableCertificateVerification: ").append(this.disableCertificateVerification());
        }
        return sb.toString();
    }

    private String getPrintablePassword(String password) {
        StringBuilder sb = new StringBuilder();
        if (password == null || password.length() < 2) {
            return password;
        }
        sb.append(password.charAt(0)).append("****").append(password.charAt(password.length() - 1));
        return sb.toString();
    }

    public static enum Mode {
        CLIENT,
        SERVER;

    }
}

