/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLEngine;
import javax.security.sasl.SaslException;
import oadd.com.google.protobuf.MessageLite;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.channel.ChannelHandler;
import oadd.io.netty.channel.ChannelPipeline;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.io.netty.channel.socket.SocketChannel;
import oadd.io.netty.handler.ssl.SslHandler;
import oadd.org.apache.drill.common.concurrent.AbstractCheckedFuture;
import oadd.org.apache.drill.common.concurrent.CheckedFuture;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.config.DrillProperties;
import oadd.org.apache.drill.common.exceptions.DrillException;
import oadd.org.apache.drill.exec.client.InvalidConnectionInfoException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.AbstractClientConnection;
import oadd.org.apache.drill.exec.rpc.Acks;
import oadd.org.apache.drill.exec.rpc.BasicClient;
import oadd.org.apache.drill.exec.rpc.ConnectionMultiListener;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import oadd.org.apache.drill.exec.rpc.NonTransientRpcException;
import oadd.org.apache.drill.exec.rpc.OutOfMemoryHandler;
import oadd.org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import oadd.org.apache.drill.exec.rpc.Response;
import oadd.org.apache.drill.exec.rpc.ResponseSender;
import oadd.org.apache.drill.exec.rpc.RpcConnectionHandler;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.security.AuthStringUtil;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorFactory;
import oadd.org.apache.drill.exec.rpc.security.ClientAuthenticatorProvider;
import oadd.org.apache.drill.exec.rpc.security.SaslProperties;
import oadd.org.apache.drill.exec.rpc.user.QueryResultHandler;
import oadd.org.apache.drill.exec.rpc.user.UserProtobufLengthDecoder;
import oadd.org.apache.drill.exec.rpc.user.UserResultsListener;
import oadd.org.apache.drill.exec.rpc.user.UserRpcConfig;
import oadd.org.apache.drill.exec.rpc.user.UserRpcUtils;
import oadd.org.apache.drill.exec.ssl.SSLConfig;
import oadd.org.apache.drill.exec.ssl.SSLConfigBuilder;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.apache.drill.shaded.guava.com.google.common.base.Throwables;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.apache.drill.shaded.guava.com.google.common.util.concurrent.SettableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserClient
extends BasicClient<UserProtos.RpcType, UserToBitConnection, UserProtos.UserToBitHandshake, UserProtos.BitToUserHandshake> {
    private static final Logger logger = LoggerFactory.getLogger(UserClient.class);
    private final BufferAllocator allocator;
    private final QueryResultHandler queryResultHandler = new QueryResultHandler();
    private final String clientName;
    private final boolean supportComplexTypes;
    private UserProtos.RpcEndpointInfos serverInfos = null;
    private Set<UserProtos.RpcType> supportedMethods = null;
    private SSLConfig sslConfig;
    private CoordinationProtos.DrillbitEndpoint endpoint;
    private DrillProperties properties;

    public UserClient(String clientName, DrillConfig config, Properties properties, boolean supportComplexTypes, BufferAllocator allocator, EventLoopGroup eventLoopGroup, Executor eventExecutor, CoordinationProtos.DrillbitEndpoint endpoint) throws NonTransientRpcException {
        super(UserRpcConfig.getMapping(config, eventExecutor), allocator.getAsByteBufAllocator(), eventLoopGroup, UserProtos.RpcType.HANDSHAKE, UserProtos.BitToUserHandshake.class, UserProtos.BitToUserHandshake.PARSER);
        this.endpoint = endpoint;
        this.clientName = clientName;
        this.allocator = allocator;
        this.supportComplexTypes = supportComplexTypes;
        try {
            this.sslConfig = new SSLConfigBuilder().properties(properties).mode(SSLConfig.Mode.CLIENT).initializeSSLContext(true).validateKeyStore(false).build();
        }
        catch (DrillException e) {
            throw new InvalidConnectionInfoException(e.getMessage());
        }
        this.properties = DrillProperties.createFromProperties(properties);
    }

    @Override
    protected void setupSSL(ChannelPipeline pipe, ConnectionMultiListener.SSLHandshakeListener sslHandshakeListener) {
        String peerHost = this.endpoint.getAddress();
        int peerPort = this.endpoint.getUserPort();
        SSLEngine sslEngine = this.sslConfig.createSSLEngine(this.allocator, peerHost, peerPort);
        SslHandler sslHandler = new SslHandler(sslEngine);
        sslHandler.setHandshakeTimeoutMillis(this.sslConfig.getHandshakeTimeout());
        sslHandler.handshakeFuture().addListener(sslHandshakeListener);
        pipe.addFirst("ssl-handler", (ChannelHandler)sslHandler);
        logger.debug(this.sslConfig.toString());
    }

    @Override
    protected boolean isSslEnabled() {
        return this.sslConfig.isUserSslEnabled();
    }

    public UserProtos.RpcEndpointInfos getServerInfos() {
        return this.serverInfos;
    }

    public Set<UserProtos.RpcType> getSupportedMethods() {
        return this.supportedMethods;
    }

    public void submitQuery(UserResultsListener resultsListener, UserProtos.RunQuery query) {
        this.send(this.queryResultHandler.getWrappedListener(resultsListener), UserProtos.RpcType.RUN_QUERY, query, UserBitShared.QueryId.class, new ByteBuf[0]);
    }

    public void connect(CoordinationProtos.DrillbitEndpoint endpoint, DrillProperties properties, UserBitShared.UserCredentials credentials) throws RpcException {
        UserProtos.UserToBitHandshake.Builder hsBuilder = UserProtos.UserToBitHandshake.newBuilder().setRpcVersion(5).setSupportListening(true).setSupportComplexTypes(this.supportComplexTypes).setSupportTimeout(true).setCredentials(credentials).setClientInfos(UserRpcUtils.getRpcEndpointInfos(this.clientName)).setSaslSupport(UserProtos.SaslSupport.SASL_PRIVACY).setProperties(properties.serializeForServer());
        if (properties.containsKey("test_sasl_level")) {
            hsBuilder.setSaslSupport(UserProtos.SaslSupport.valueOf(Integer.parseInt(properties.getProperty("test_sasl_level"))));
        }
        try {
            if (this.sslConfig.isUserSslEnabled()) {
                this.connect(hsBuilder.build(), endpoint).checkedGet(this.sslConfig.getHandshakeTimeout(), TimeUnit.MILLISECONDS);
            } else {
                this.connect(hsBuilder.build(), endpoint).checkedGet();
            }
        }
        catch (TimeoutException e) {
            String msg = "Connecting to the server timed out. This is sometimes due to a mismatch in the SSL configuration between client and server. [ Exception: " + e.getMessage() + "]";
            throw new NonTransientRpcException(msg);
        }
        catch (SaslException e) {
            throw new NonTransientRpcException(e);
        }
        catch (RpcException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RpcException(e);
        }
    }

    private void validateSaslCompatibility(DrillProperties properties, List<String> serverAuthMechs) throws NonTransientRpcException {
        boolean serverAuthConfigured;
        boolean clientNeedsEncryption = properties.containsKey("sasl_encrypt") && Boolean.parseBoolean(properties.getProperty("sasl_encrypt"));
        boolean bl = serverAuthConfigured = serverAuthMechs != null;
        if (clientNeedsEncryption && !((UserToBitConnection)this.connection).isEncryptionEnabled()) {
            throw new NonTransientRpcException("Client needs encrypted connection but server is not configured for encryption. Please contact your administrator. [Warn: It may be due to wrong config or a security attack in progress.]");
        }
        if (clientNeedsEncryption && !serverAuthConfigured) {
            throw new NonTransientRpcException("Client needs encrypted connection but server doesn't support any security mechanisms. Please contact your administrator. [Warn: It may be due to wrong config or a security attack in progress.]");
        }
        if (this.clientNeedsAuthExceptPlain(properties) && !serverAuthConfigured) {
            throw new NonTransientRpcException("Client needs authentication but server doesn't support any security mechanisms. Please contact your administrator. [Warn: It may be due to wrong config or a security attack in progress.]");
        }
    }

    private boolean clientNeedsAuthExceptPlain(DrillProperties props) {
        boolean clientNeedsAuth = false;
        String authMechanism = props.getProperty("auth");
        if (!Strings.isNullOrEmpty(authMechanism) && !authMechanism.equalsIgnoreCase("PLAIN")) {
            clientNeedsAuth = true;
        }
        return clientNeedsAuth |= !Strings.isNullOrEmpty(props.getProperty("principal"));
    }

    private CheckedFuture<Void, IOException> connect(UserProtos.UserToBitHandshake handshake, CoordinationProtos.DrillbitEndpoint endpoint) {
        final SettableFuture connectionSettable = SettableFuture.create();
        AbstractCheckedFuture<Void, IOException> connectionFuture = new AbstractCheckedFuture<Void, IOException>(connectionSettable){

            @Override
            protected IOException mapException(Exception e) {
                Throwable cause;
                if (e instanceof SaslException) {
                    return (SaslException)e;
                }
                if (e instanceof ExecutionException && (cause = Throwables.getRootCause(e)) instanceof SaslException) {
                    return (SaslException)cause;
                }
                return RpcException.mapException(e);
            }
        };
        RpcConnectionHandler<UserToBitConnection> connectionHandler = new RpcConnectionHandler<UserToBitConnection>(){

            @Override
            public void connectionSucceeded(UserToBitConnection connection) {
                connectionSettable.set(null);
            }

            @Override
            public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t) {
                if (t instanceof NonTransientRpcException || t instanceof SaslException) {
                    connectionSettable.setException(t);
                } else if (t instanceof RpcException) {
                    Throwable cause = t.getCause();
                    if (cause instanceof SaslException) {
                        connectionSettable.setException(cause);
                        return;
                    }
                    connectionSettable.setException(t);
                } else {
                    connectionSettable.setException(new RpcException(String.format("%s : %s", type.name(), t.getMessage()), t));
                }
            }
        };
        this.connectAsClient(this.queryResultHandler.getWrappedConnectionHandler(connectionHandler), handshake, endpoint.getAddress(), endpoint.getUserPort());
        return connectionFuture;
    }

    private AuthenticatorFactory getAuthenticatorFactory(DrillProperties properties, List<String> serverAuthMechanisms) throws SaslException {
        Set<String> mechanismSet = AuthStringUtil.asSet(serverAuthMechanisms);
        String authMechanism = properties.getProperty("auth");
        if (authMechanism != null) {
            if (!ClientAuthenticatorProvider.getInstance().containsFactory(authMechanism)) {
                throw new SaslException(String.format("Unknown mechanism: %s", authMechanism));
            }
            if (!mechanismSet.contains(authMechanism.toUpperCase())) {
                throw new SaslException(String.format("Server does not support authentication using: %s. [Details: %s]", authMechanism, ((UserToBitConnection)this.connection).getEncryptionCtxtString()));
            }
            return ClientAuthenticatorProvider.getInstance().getAuthenticatorFactory(authMechanism);
        }
        if (mechanismSet.contains("KERBEROS") && properties.containsKey("principal")) {
            return ClientAuthenticatorProvider.getInstance().getAuthenticatorFactory("KERBEROS");
        }
        if (mechanismSet.contains("PLAIN") && properties.containsKey("user") && !Strings.isNullOrEmpty(properties.getProperty("password"))) {
            return ClientAuthenticatorProvider.getInstance().getAuthenticatorFactory("PLAIN");
        }
        throw new SaslException(String.format("Server requires authentication using %s. Insufficient credentials?. [Details: %s]. ", mechanismSet, ((UserToBitConnection)this.connection).getEncryptionCtxtString()));
    }

    protected <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, UserProtos.RpcType rpcType, SEND protobufBody, Class<RECEIVE> clazz, boolean allowInEventLoop, ByteBuf ... dataBodies) {
        super.send(listener, this.connection, rpcType, protobufBody, clazz, allowInEventLoop, dataBodies);
    }

    @Override
    protected MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        switch (rpcType) {
            case 1: {
                return GeneralRPCProtos.Ack.getDefaultInstance();
            }
            case 0: {
                return UserProtos.BitToUserHandshake.getDefaultInstance();
            }
            case 7: {
                return UserBitShared.QueryId.getDefaultInstance();
            }
            case 10: {
                return UserBitShared.QueryResult.getDefaultInstance();
            }
            case 6: {
                return UserBitShared.QueryData.getDefaultInstance();
            }
            case 13: {
                return UserProtos.QueryPlanFragments.getDefaultInstance();
            }
            case 18: {
                return UserProtos.GetCatalogsResp.getDefaultInstance();
            }
            case 19: {
                return UserProtos.GetSchemasResp.getDefaultInstance();
            }
            case 20: {
                return UserProtos.GetTablesResp.getDefaultInstance();
            }
            case 21: {
                return UserProtos.GetColumnsResp.getDefaultInstance();
            }
            case 23: {
                return UserProtos.CreatePreparedStatementResp.getDefaultInstance();
            }
            case 24: {
                return UserBitShared.SaslMessage.getDefaultInstance();
            }
            case 9: {
                return UserProtos.GetServerMetaResp.getDefaultInstance();
            }
        }
        throw new RpcException(String.format("Unable to deal with RpcType of %d", rpcType));
    }

    @Override
    protected void handle(UserToBitConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody, ResponseSender sender) throws RpcException {
        if (!this.isAuthComplete()) {
            throw new RpcException(String.format("Request of type %d is not allowed without authentication. Remote on %s must authenticate before making requests. Connection dropped.", rpcType, connection.getRemoteAddress()));
        }
        switch (rpcType) {
            case 6: {
                this.queryResultHandler.batchArrived(connection, pBody, dBody);
                sender.send(new Response(UserProtos.RpcType.ACK, Acks.OK, new ByteBuf[0]));
                break;
            }
            case 10: {
                this.queryResultHandler.resultArrived(pBody);
                sender.send(new Response(UserProtos.RpcType.ACK, Acks.OK, new ByteBuf[0]));
                break;
            }
            default: {
                throw new RpcException(String.format("Unknown Rpc Type %d. ", rpcType));
            }
        }
    }

    @Override
    protected void prepareSaslHandshake(RpcConnectionHandler<UserToBitConnection> connectionHandler, List<String> serverAuthMechanisms) {
        try {
            Map<String, String> saslProperties = this.properties.stringPropertiesAsMap();
            saslProperties.putAll(SaslProperties.getSaslProperties(((UserToBitConnection)this.connection).isEncryptionEnabled(), ((UserToBitConnection)this.connection).getMaxWrappedSize()));
            AuthenticatorFactory factory = this.getAuthenticatorFactory(this.properties, serverAuthMechanisms);
            String mechanismName = factory.getSimpleName();
            logger.trace("Will try to authenticate to server using {} mechanism with encryption context {}", (Object)mechanismName, (Object)((UserToBitConnection)this.connection).getEncryptionCtxtString());
            ClassLoader oldThreadCtxtCL = Thread.currentThread().getContextClassLoader();
            ClassLoader newThreadCtxtCL = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(newThreadCtxtCL);
            UserGroupInformation ugi = factory.createAndLoginUser(saslProperties);
            Thread.currentThread().setContextClassLoader(oldThreadCtxtCL);
            this.startSaslHandshake(connectionHandler, saslProperties, ugi, factory, UserProtos.RpcType.SASL_MESSAGE);
        }
        catch (IOException e) {
            logger.error("Failed while doing setup for starting SASL handshake for connection {}", (Object)((UserToBitConnection)this.connection).getName());
            RpcException ex = new RpcException(String.format("Failed to initiate authentication for connection %s", ((UserToBitConnection)this.connection).getName()), e);
            connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.AUTHENTICATION, ex);
        }
    }

    @Override
    protected List<String> validateHandshake(UserProtos.BitToUserHandshake inbound) throws RpcException {
        ImmutableList<String> serverAuthMechanisms = null;
        if (inbound.hasServerInfos()) {
            this.serverInfos = inbound.getServerInfos();
        }
        this.supportedMethods = Sets.immutableEnumSet(inbound.getSupportedMethodsList());
        switch (inbound.getStatus()) {
            case SUCCESS: {
                break;
            }
            case AUTH_REQUIRED: {
                serverAuthMechanisms = ImmutableList.copyOf(inbound.getAuthenticationMechanismsList());
                this.setAuthComplete(false);
                ((UserToBitConnection)this.connection).setEncryption(inbound.hasEncrypted() && inbound.getEncrypted());
                if (inbound.hasMaxWrappedSize()) {
                    ((UserToBitConnection)this.connection).setMaxWrappedSize(inbound.getMaxWrappedSize());
                }
                logger.trace(String.format("Server requires authentication with encryption context %s before proceeding.", ((UserToBitConnection)this.connection).getEncryptionCtxtString()));
                break;
            }
            case AUTH_FAILED: 
            case RPC_VERSION_MISMATCH: 
            case UNKNOWN_FAILURE: {
                String errMsg = String.format("Status: %s, Error Id: %s, Error message: %s", inbound.getStatus(), inbound.getErrorId(), inbound.getErrorMessage());
                logger.error(errMsg);
                throw new NonTransientRpcException(errMsg);
            }
        }
        this.validateSaslCompatibility(this.properties, serverAuthMechanisms);
        return serverAuthMechanisms;
    }

    @Override
    protected UserToBitConnection initRemoteConnection(SocketChannel channel) {
        super.initRemoteConnection(channel);
        return new UserToBitConnection(channel);
    }

    @Override
    public ProtobufLengthDecoder getDecoder(BufferAllocator allocator) {
        return new UserProtobufLengthDecoder(allocator, OutOfMemoryHandler.DEFAULT_INSTANCE);
    }

    public DrillRpcFuture<UserProtos.QueryPlanFragments> planQuery(UserProtos.GetQueryPlanFragments req) {
        return this.send(UserProtos.RpcType.GET_QUERY_PLAN_FRAGMENTS, req, UserProtos.QueryPlanFragments.class, new ByteBuf[0]);
    }

    public class UserToBitConnection
    extends AbstractClientConnection {
        UserToBitConnection(SocketChannel channel) {
            super(channel, "user client");
        }

        @Override
        public BufferAllocator getAllocator() {
            return UserClient.this.allocator;
        }

        @Override
        protected Logger getLogger() {
            return logger;
        }

        @Override
        public void incConnectionCounter() {
        }

        @Override
        public void decConnectionCounter() {
        }
    }
}

