/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.Arrays;
import java.util.BitSet;
import oadd.com.carrotsearch.hppc.IntArrayList;
import oadd.org.apache.commons.lang3.ArrayUtils;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.record.RecordBatch;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class TypedFieldId {
    private final TypeProtos.MajorType finalType;
    private final TypeProtos.MajorType secondaryFinal;
    private final TypeProtos.MajorType intermediateType;
    private final int[] fieldIds;
    private final boolean isHyperReader;
    private final boolean isListVector;
    private final PathSegment remainder;
    private final BitSet dictBitSet;

    private TypedFieldId(Builder builder) {
        this.intermediateType = builder.intermediateType;
        this.finalType = builder.finalType;
        this.secondaryFinal = builder.secondaryFinal;
        this.fieldIds = builder.ids.toArray();
        this.isHyperReader = builder.hyperReader;
        this.isListVector = builder.isListVector;
        this.remainder = builder.remainder;
        this.dictBitSet = builder.dictBitSet;
    }

    public TypedFieldId cloneWithChild(int id) {
        int[] fieldIds = ArrayUtils.add(this.fieldIds, id);
        return this.getBuilder().clearAndAddIds(fieldIds).build();
    }

    private Builder getBuilder() {
        return new Builder().intermediateType(this.intermediateType).finalType(this.finalType).secondaryFinal(this.secondaryFinal).addIds(this.fieldIds).remainder(this.remainder).copyDictBitSet(this.dictBitSet).hyper(this.isHyperReader).listVector(this.isListVector);
    }

    public PathSegment getLastSegment() {
        if (this.remainder == null) {
            return null;
        }
        PathSegment seg = this.remainder;
        while (seg.getChild() != null) {
            seg = seg.getChild();
        }
        return seg;
    }

    public TypedFieldId cloneWithRemainder(PathSegment remainder) {
        return this.getBuilder().remainder(remainder).build();
    }

    public boolean hasRemainder() {
        return this.remainder != null;
    }

    public PathSegment getRemainder() {
        return this.remainder;
    }

    public boolean isHyperReader() {
        return this.isHyperReader;
    }

    public boolean isListVector() {
        return this.isListVector;
    }

    public TypeProtos.MajorType getIntermediateType() {
        return this.intermediateType;
    }

    public boolean isDict(int depth) {
        return this.dictBitSet.get(depth);
    }

    public Class<? extends ValueVector> getIntermediateClass() {
        return BasicTypeHelper.getValueVectorClass(this.intermediateType.getMinorType(), this.intermediateType.getMode());
    }

    public TypeProtos.MajorType getFinalType() {
        return this.finalType;
    }

    public int[] getFieldIds() {
        return this.fieldIds;
    }

    public TypeProtos.MajorType getSecondaryFinal() {
        return this.secondaryFinal;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fieldIds);
        result = 31 * result + (this.finalType == null ? 0 : this.finalType.hashCode());
        result = 31 * result + (this.intermediateType == null ? 0 : this.intermediateType.hashCode());
        result = 31 * result + (this.isHyperReader ? 1231 : 1237);
        result = 31 * result + (this.remainder == null ? 0 : this.remainder.hashCode());
        result = 31 * result + (this.secondaryFinal == null ? 0 : this.secondaryFinal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypedFieldId other = (TypedFieldId)obj;
        if (!Arrays.equals(this.fieldIds, other.fieldIds)) {
            return false;
        }
        if (this.finalType == null ? other.finalType != null : !this.finalType.equals(other.finalType)) {
            return false;
        }
        if (this.intermediateType == null ? other.intermediateType != null : !this.intermediateType.equals(other.intermediateType)) {
            return false;
        }
        if (this.isHyperReader != other.isHyperReader) {
            return false;
        }
        if (this.remainder == null ? other.remainder != null : !this.remainder.equals(other.remainder)) {
            return false;
        }
        return !(this.secondaryFinal == null ? other.secondaryFinal != null : !this.secondaryFinal.equals(other.secondaryFinal));
    }

    public String toString() {
        int maxLen = 10;
        return "TypedFieldId [fieldIds=" + (this.fieldIds != null ? Arrays.toString(Arrays.copyOf(this.fieldIds, Math.min(this.fieldIds.length, 10))) : null) + ", remainder=" + this.remainder + "]";
    }

    public static String getPath(TypedFieldId typeFieldId, RecordBatch recordBatch) {
        StringBuilder name = new StringBuilder();
        String SEPARATOR = ".";
        int[] fieldIds = typeFieldId.getFieldIds();
        VectorWrapper<?> topLevel = recordBatch.getValueAccessorById(null, fieldIds[0]);
        name.append(topLevel.getField().getName());
        int[] lookupLevel = new int[2];
        for (int i = 0; i < fieldIds.length - 1; ++i) {
            lookupLevel[0] = fieldIds[i];
            lookupLevel[1] = fieldIds[i + 1];
            topLevel = topLevel.getChildWrapper(lookupLevel);
            name.append("." + topLevel.getField().getName());
        }
        return name.toString();
    }

    public static class Builder {
        final IntArrayList ids = new IntArrayList();
        TypeProtos.MajorType finalType;
        TypeProtos.MajorType intermediateType;
        TypeProtos.MajorType secondaryFinal;
        PathSegment remainder;
        boolean hyperReader;
        boolean withIndex;
        boolean isListVector;
        BitSet dictBitSet = new BitSet();

        public Builder addId(int id) {
            this.ids.add(id);
            return this;
        }

        public Builder withIndex() {
            this.withIndex = true;
            return this;
        }

        public Builder remainder(PathSegment remainder) {
            this.remainder = remainder;
            return this;
        }

        public Builder hyper(boolean hyper) {
            this.hyperReader = hyper;
            return this;
        }

        public Builder listVector(boolean listVector) {
            this.isListVector = listVector;
            return this;
        }

        public Builder finalType(TypeProtos.MajorType finalType) {
            this.finalType = finalType;
            return this;
        }

        public Builder secondaryFinal(TypeProtos.MajorType secondaryFinal) {
            this.secondaryFinal = secondaryFinal;
            return this;
        }

        public Builder intermediateType(TypeProtos.MajorType intermediateType) {
            this.intermediateType = intermediateType;
            return this;
        }

        public Builder setDict(int depth) {
            this.dictBitSet.set(depth, true);
            return this;
        }

        public Builder resetDictBitSet() {
            this.dictBitSet.clear();
            return this;
        }

        private Builder addIds(int ... ids) {
            for (int id : ids) {
                this.ids.add(id);
            }
            return this;
        }

        private Builder clearAndAddIds(int[] ids) {
            this.ids.clear();
            this.addIds(ids);
            return this;
        }

        private Builder copyDictBitSet(BitSet dictBitSet) {
            this.dictBitSet.or(dictBitSet);
            return this;
        }

        public TypedFieldId build() {
            Preconditions.checkNotNull(this.finalType);
            if (this.intermediateType == null) {
                this.intermediateType = this.finalType;
            }
            if (this.secondaryFinal == null) {
                this.secondaryFinal = this.finalType;
            }
            return new TypedFieldId(this);
        }
    }
}

