/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.Iterator;
import java.util.Map;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.physical.impl.sort.RecordBatchData;
import oadd.org.apache.drill.exec.record.AbstractRecordBatch;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.RecordBatch;
import oadd.org.apache.drill.exec.record.RecordBatchMemoryManager;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.record.selection.SelectionVector2;
import oadd.org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.shaded.guava.com.google.common.collect.Range;
import org.apache.drill.shaded.guava.com.google.common.collect.TreeRangeMap;

public class RecordIterator
implements VectorAccessible {
    private final RecordBatch incoming;
    private final AbstractRecordBatch<?> outgoing;
    private long outerPosition;
    private int innerPosition;
    private int innerRecordCount;
    private long totalRecordCount;
    private long startBatchPosition;
    private int markedInnerPosition;
    private long markedOuterPosition;
    private RecordBatch.IterOutcome lastOutcome;
    private final int inputIndex;
    private boolean lastBatchRead;
    private boolean initialized;
    private final OperatorContext oContext;
    private final boolean enableMarkAndReset;
    private final VectorContainer container;
    private final TreeRangeMap<Long, RecordBatchData> batches = TreeRangeMap.create();
    private final RecordBatchMemoryManager newBatchCallBack;

    public RecordIterator(RecordBatch incoming, AbstractRecordBatch<?> outgoing, OperatorContext oContext, int inputIndex, RecordBatchMemoryManager callBack) {
        this(incoming, outgoing, oContext, inputIndex, true, callBack);
    }

    public RecordIterator(RecordBatch incoming, AbstractRecordBatch<?> outgoing, OperatorContext oContext, int inputIndex, boolean enableMarkAndReset, RecordBatchMemoryManager callBack) {
        this.incoming = incoming;
        this.outgoing = outgoing;
        this.inputIndex = inputIndex;
        this.lastBatchRead = false;
        this.container = new VectorContainer(oContext);
        this.oContext = oContext;
        this.resetIndices();
        this.initialized = false;
        this.enableMarkAndReset = enableMarkAndReset;
        this.newBatchCallBack = callBack;
    }

    private void resetIndices() {
        this.innerPosition = -1;
        this.startBatchPosition = -1L;
        this.outerPosition = -1L;
        this.totalRecordCount = 0L;
        this.innerRecordCount = 0;
        this.markedInnerPosition = -1;
        this.markedOuterPosition = -1L;
    }

    private void nextBatch() {
        if (this.lastBatchRead) {
            return;
        }
        RecordBatch.IterOutcome iterOutcome = this.lastOutcome = this.outgoing != null ? this.outgoing.next(this.inputIndex, this.incoming) : this.incoming.next();
        if ((this.lastOutcome == RecordBatch.IterOutcome.OK || this.lastOutcome == RecordBatch.IterOutcome.OK_NEW_SCHEMA) && this.newBatchCallBack != null) {
            this.newBatchCallBack.update(this.inputIndex);
        }
    }

    public void mark() {
        if (!this.enableMarkAndReset) {
            throw new UnsupportedOperationException("mark and reset disabled for this RecordIterator");
        }
        Map oldBatches = this.batches.subRangeMap(Range.closedOpen(0L, this.startBatchPosition)).asMapOfRanges();
        for (RecordBatchData rbd : oldBatches.values()) {
            rbd.clear();
        }
        this.batches.remove(Range.closedOpen(0L, this.startBatchPosition));
        this.markedInnerPosition = this.innerPosition;
        this.markedOuterPosition = this.outerPosition;
    }

    public void reset() {
        if (!this.enableMarkAndReset) {
            throw new UnsupportedOperationException("mark and reset disabled for this RecordIterator");
        }
        if (this.markedOuterPosition >= 0L) {
            RecordBatchData rbdNew = (RecordBatchData)this.batches.get((Comparable)Long.valueOf(this.markedOuterPosition));
            RecordBatchData rbdOld = (RecordBatchData)this.batches.get((Comparable)Long.valueOf(this.startBatchPosition));
            assert (rbdOld != null);
            assert (rbdNew != null);
            if (rbdNew != rbdOld) {
                this.container.transferOut(rbdOld.getContainer());
                this.container.transferIn(rbdNew.getContainer());
            }
            this.innerPosition = this.markedInnerPosition;
            this.outerPosition = this.markedOuterPosition;
            Range markedBatchRange = (Range)this.batches.getEntry((Comparable)Long.valueOf(this.outerPosition)).getKey();
            this.startBatchPosition = (Long)markedBatchRange.lowerEndpoint();
            this.innerRecordCount = (int)((Long)markedBatchRange.upperEndpoint() - this.startBatchPosition);
            this.markedInnerPosition = -1;
            this.markedOuterPosition = -1L;
        }
    }

    public void forward(long delta) {
        if (!this.enableMarkAndReset) {
            throw new UnsupportedOperationException("mark and reset disabled for this RecordIterator");
        }
        assert (delta >= 0L);
        assert (delta + this.outerPosition < this.totalRecordCount);
        long nextOuterPosition = delta + this.outerPosition;
        RecordBatchData rbdNew = (RecordBatchData)this.batches.get((Comparable)Long.valueOf(nextOuterPosition));
        RecordBatchData rbdOld = (RecordBatchData)this.batches.get((Comparable)Long.valueOf(this.outerPosition));
        assert (rbdNew != null);
        assert (rbdOld != null);
        this.container.transferOut(rbdOld.getContainer());
        this.container.transferIn(rbdNew.getContainer());
        this.outerPosition = nextOuterPosition;
        Range markedBatchRange = (Range)this.batches.getEntry((Comparable)Long.valueOf(this.outerPosition)).getKey();
        this.startBatchPosition = (Long)markedBatchRange.lowerEndpoint();
        this.innerPosition = (int)(this.outerPosition - this.startBatchPosition);
        this.innerRecordCount = (int)((Long)markedBatchRange.upperEndpoint() - this.startBatchPosition);
    }

    public void prepare() {
        while (!this.lastBatchRead && this.outerPosition == -1L) {
            this.next();
        }
    }

    public RecordBatch.IterOutcome next() {
        block21: {
            int nextInnerPosition;
            long nextOuterPosition;
            block20: {
                if (this.finished()) {
                    return this.lastOutcome;
                }
                nextOuterPosition = this.outerPosition + 1L;
                nextInnerPosition = this.innerPosition + 1;
                if (this.initialized && nextOuterPosition < this.totalRecordCount) break block20;
                this.nextBatch();
                switch (this.lastOutcome) {
                    case NONE: {
                        this.outerPosition = nextOuterPosition;
                        this.lastBatchRead = true;
                        if (!this.enableMarkAndReset) {
                            this.container.clear();
                        }
                        break block21;
                    }
                    case OK_NEW_SCHEMA: 
                    case OK: {
                        if (this.initialized && this.lastOutcome == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
                            this.clear();
                            this.resetIndices();
                            this.initialized = false;
                            nextOuterPosition = 0L;
                        }
                        RecordBatchData rbd = new RecordBatchData((VectorAccessible)this.incoming, this.oContext.getAllocator());
                        this.innerRecordCount = this.incoming.getRecordCount();
                        if (!this.initialized) {
                            for (VectorWrapper<?> w : rbd.getContainer()) {
                                this.container.addOrGet(w.getField());
                            }
                            this.container.buildSchema(rbd.getContainer().getSchema().getSelectionVectorMode());
                            this.container.setEmpty();
                            this.initialized = true;
                        }
                        if (this.innerRecordCount > 0) {
                            if (this.enableMarkAndReset) {
                                if (this.startBatchPosition != -1L && this.batches.get((Comparable)Long.valueOf(this.startBatchPosition)) != null) {
                                    this.container.transferOut(((RecordBatchData)this.batches.get((Comparable)Long.valueOf(this.outerPosition))).getContainer());
                                }
                                this.container.transferIn(rbd.getContainer());
                                this.batches.put(Range.closedOpen(nextOuterPosition, nextOuterPosition + (long)this.innerRecordCount), (Object)rbd);
                            } else {
                                this.container.zeroVectors();
                                this.container.transferIn(rbd.getContainer());
                            }
                            this.innerPosition = 0;
                            this.startBatchPosition = nextOuterPosition;
                            this.outerPosition = nextOuterPosition;
                            this.totalRecordCount += (long)this.innerRecordCount;
                        } else {
                            rbd.clear();
                        }
                        break block21;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported outcome received " + (Object)((Object)this.lastOutcome));
                    }
                }
            }
            if (nextInnerPosition >= this.innerRecordCount) {
                assert (this.enableMarkAndReset);
                RecordBatchData rbdNew = (RecordBatchData)this.batches.get((Comparable)Long.valueOf(nextOuterPosition));
                RecordBatchData rbdOld = (RecordBatchData)this.batches.get((Comparable)Long.valueOf(this.outerPosition));
                assert (rbdNew != null);
                assert (rbdOld != null);
                assert (rbdOld != rbdNew);
                this.container.transferOut(rbdOld.getContainer());
                this.container.transferIn(rbdNew.getContainer());
                this.innerPosition = 0;
                this.outerPosition = nextOuterPosition;
                this.startBatchPosition = (Long)((Range)this.batches.getEntry((Comparable)Long.valueOf(this.outerPosition)).getKey()).lowerEndpoint();
                this.innerRecordCount = (int)((Long)((Range)this.batches.getEntry((Comparable)Long.valueOf(this.outerPosition)).getKey()).upperEndpoint() - this.startBatchPosition);
            } else {
                this.outerPosition = nextOuterPosition;
                this.innerPosition = nextInnerPosition;
            }
        }
        return this.lastOutcome;
    }

    public boolean finished() {
        return this.lastBatchRead && this.outerPosition >= this.totalRecordCount;
    }

    public RecordBatch.IterOutcome getLastOutcome() {
        return this.lastOutcome;
    }

    public long getTotalRecordCount() {
        return this.totalRecordCount;
    }

    public int getInnerRecordCount() {
        return this.innerRecordCount;
    }

    public long getOuterPosition() {
        return this.outerPosition;
    }

    public int getCurrentPosition() {
        assert (this.initialized);
        assert (this.innerPosition >= 0);
        assert (this.innerPosition < this.innerRecordCount);
        return this.innerPosition;
    }

    public Map<Range<Long>, RecordBatchData> cachedBatches() {
        return this.batches.asMapOfRanges();
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        assert (this.initialized);
        return this.container.getValueAccessorById(clazz, ids);
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        assert (this.initialized);
        return this.container.getValueVectorId(path);
    }

    @Override
    public BatchSchema getSchema() {
        assert (this.initialized);
        return this.container.getSchema();
    }

    @Override
    public int getRecordCount() {
        assert (this.initialized);
        return this.innerRecordCount;
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        assert (this.initialized);
        return this.container.iterator();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        if (this.container != null) {
            this.container.clear();
        }
        for (RecordBatchData d : this.batches.asMapOfRanges().values()) {
            d.clear();
        }
        this.batches.clear();
    }

    public void clearInflightBatches() {
        while (this.lastOutcome == RecordBatch.IterOutcome.OK || this.lastOutcome == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
            for (VectorWrapper wrapper : this.incoming) {
                wrapper.getValueVector().clear();
            }
            this.lastOutcome = this.incoming.next();
        }
    }

    public void close() {
        this.clear();
        this.clearInflightBatches();
    }

    public String toString() {
        return "RecordIterator[outerPosition=" + this.outerPosition + ", innerPosition=" + this.innerPosition + ", innerRecordCount=" + this.innerRecordCount + ", totalRecordCount=" + this.totalRecordCount + ", startBatchPosition=" + this.startBatchPosition + ", markedInnerPosition" + this.markedInnerPosition + ", markedOuterPosition=" + this.markedOuterPosition + ", lastOutcome=" + (Object)((Object)this.lastOutcome) + ", inputIndex=" + this.inputIndex + "]";
    }
}

