/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.framework.recipes.cache;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import oadd.com.google.common.base.Function;
import oadd.org.apache.curator.framework.CuratorFramework;
import oadd.org.apache.curator.framework.WatcherRemoveCuratorFramework;
import oadd.org.apache.curator.framework.api.BackgroundCallback;
import oadd.org.apache.curator.framework.api.BackgroundPathable;
import oadd.org.apache.curator.framework.api.Backgroundable;
import oadd.org.apache.curator.framework.api.CuratorEvent;
import oadd.org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import oadd.org.apache.curator.framework.api.Pathable;
import oadd.org.apache.curator.framework.api.UnhandledErrorListener;
import oadd.org.apache.curator.framework.api.Watchable;
import oadd.org.apache.curator.framework.listen.Listenable;
import oadd.org.apache.curator.framework.listen.ListenerContainer;
import oadd.org.apache.curator.framework.recipes.cache.ChildData;
import oadd.org.apache.curator.framework.recipes.cache.DefaultTreeCacheSelector;
import oadd.org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import oadd.org.apache.curator.framework.recipes.cache.TreeCacheListener;
import oadd.org.apache.curator.framework.recipes.cache.TreeCacheSelector;
import oadd.org.apache.curator.framework.state.ConnectionState;
import oadd.org.apache.curator.framework.state.ConnectionStateListener;
import oadd.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import oadd.org.apache.curator.shaded.com.google.common.base.Preconditions;
import oadd.org.apache.curator.shaded.com.google.common.collect.ImmutableMap;
import oadd.org.apache.curator.shaded.com.google.common.collect.Maps;
import oadd.org.apache.curator.utils.PathUtils;
import oadd.org.apache.curator.utils.ThreadUtils;
import oadd.org.apache.curator.utils.ZKPaths;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.WatchedEvent;
import oadd.org.apache.zookeeper.Watcher;
import oadd.org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeCache
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TreeCache.class);
    private final boolean createParentNodes;
    private final boolean disableZkWatches;
    private final TreeCacheSelector selector;
    private static final ChildData DEAD = new ChildData("/", null, null);
    private static final AtomicReferenceFieldUpdater<TreeNode, ChildData> childDataUpdater = AtomicReferenceFieldUpdater.newUpdater(TreeNode.class, ChildData.class, "childData");
    private static final AtomicReferenceFieldUpdater<TreeNode, ConcurrentMap<String, TreeNode>> childrenUpdater = AtomicReferenceFieldUpdater.newUpdater(TreeNode.class, ConcurrentMap.class, "children");
    private final AtomicLong outstandingOps = new AtomicLong(0L);
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private final TreeNode root;
    private final WatcherRemoveCuratorFramework client;
    private final ExecutorService executorService;
    private final boolean cacheData;
    private final boolean dataIsCompressed;
    private final int maxDepth;
    private final ListenerContainer<TreeCacheListener> listeners = new ListenerContainer();
    private final ListenerContainer<UnhandledErrorListener> errorListeners = new ListenerContainer();
    private final AtomicReference<TreeState> treeState = new AtomicReference<TreeState>(TreeState.LATENT);
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            TreeCache.this.handleStateChange(newState);
        }
    };
    static final ThreadFactory defaultThreadFactory = ThreadUtils.newThreadFactory("TreeCache");

    public static Builder newBuilder(CuratorFramework client, String path) {
        return new Builder(client, path);
    }

    private static boolean isLive(ChildData cd2) {
        return cd2 != null && cd2 != DEAD;
    }

    public TreeCache(CuratorFramework client, String path) {
        this(client, path, true, false, Integer.MAX_VALUE, Executors.newSingleThreadExecutor(defaultThreadFactory), false, false, new DefaultTreeCacheSelector());
    }

    TreeCache(CuratorFramework client, String path, boolean cacheData, boolean dataIsCompressed, int maxDepth, ExecutorService executorService, boolean createParentNodes, boolean disableZkWatches, TreeCacheSelector selector) {
        this.createParentNodes = createParentNodes;
        this.selector = Preconditions.checkNotNull(selector, "selector cannot be null");
        this.root = new TreeNode(PathUtils.validatePath(path), null);
        Preconditions.checkNotNull(client, "client cannot be null");
        this.client = client.newWatcherRemoveCuratorFramework();
        this.cacheData = cacheData;
        this.dataIsCompressed = dataIsCompressed;
        this.maxDepth = maxDepth;
        this.disableZkWatches = disableZkWatches;
        this.executorService = Preconditions.checkNotNull(executorService, "executorService cannot be null");
    }

    public TreeCache start() throws Exception {
        Preconditions.checkState(this.treeState.compareAndSet(TreeState.LATENT, TreeState.STARTED), "already started");
        if (this.createParentNodes) {
            this.client.createContainers(this.root.path);
        }
        this.client.getConnectionStateListenable().addListener(this.connectionStateListener);
        if (this.client.getZookeeperClient().isConnected()) {
            this.root.wasCreated();
        }
        return this;
    }

    @Override
    public void close() {
        if (this.treeState.compareAndSet(TreeState.STARTED, TreeState.CLOSED)) {
            this.client.removeWatchers();
            this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
            this.listeners.clear();
            this.executorService.shutdown();
            try {
                this.root.wasDeleted();
            }
            catch (Exception e) {
                ThreadUtils.checkInterrupted(e);
                this.handleException(e);
            }
        }
    }

    public Listenable<TreeCacheListener> getListenable() {
        return this.listeners;
    }

    @VisibleForTesting
    public Listenable<UnhandledErrorListener> getUnhandledErrorListenable() {
        return this.errorListeners;
    }

    private TreeNode find(String findPath) {
        String nextFind;
        PathUtils.validatePath(findPath);
        LinkedList<String> rootElements = new LinkedList<String>(ZKPaths.split(this.root.path));
        LinkedList<String> findElements = new LinkedList<String>(ZKPaths.split(findPath));
        while (!rootElements.isEmpty()) {
            if (findElements.isEmpty()) {
                return null;
            }
            String nextRoot = rootElements.removeFirst();
            nextFind = findElements.removeFirst();
            if (nextFind.equals(nextRoot)) continue;
            return null;
        }
        TreeNode current = this.root;
        while (!findElements.isEmpty()) {
            nextFind = findElements.removeFirst();
            ConcurrentMap<String, TreeNode> map = current.children;
            if (map == null) {
                return null;
            }
            current = (TreeNode)map.get(nextFind);
            if (current != null) continue;
            return null;
        }
        return current;
    }

    public Map<String, ChildData> getCurrentChildren(String fullPath) {
        ImmutableMap<String, ChildData> result;
        TreeNode node = this.find(fullPath);
        if (node == null || !TreeCache.isLive(node.childData)) {
            return null;
        }
        ConcurrentMap<String, TreeNode> map = node.children;
        if (map == null) {
            result = ImmutableMap.of();
        } else {
            ImmutableMap.Builder<String, ChildData> builder = ImmutableMap.builder();
            for (Map.Entry entry : map.entrySet()) {
                ChildData childData = ((TreeNode)entry.getValue()).childData;
                if (!TreeCache.isLive(childData)) continue;
                builder.put((String)entry.getKey(), childData);
            }
            result = builder.build();
        }
        return TreeCache.isLive(node.childData) ? result : null;
    }

    public ChildData getCurrentData(String fullPath) {
        TreeNode node = this.find(fullPath);
        if (node == null) {
            return null;
        }
        ChildData result = node.childData;
        return TreeCache.isLive(result) ? result : null;
    }

    private void callListeners(final TreeCacheEvent event) {
        this.listeners.forEach(new Function<TreeCacheListener, Void>(){

            @Override
            public Void apply(TreeCacheListener listener) {
                try {
                    listener.childEvent(TreeCache.this.client, event);
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted(e);
                    TreeCache.this.handleException(e);
                }
                return null;
            }
        });
    }

    private void handleException(final Throwable e) {
        if (this.errorListeners.size() == 0) {
            LOG.error("", e);
        } else {
            this.errorListeners.forEach(new Function<UnhandledErrorListener, Void>(){

                @Override
                public Void apply(UnhandledErrorListener listener) {
                    try {
                        listener.unhandledError("", e);
                    }
                    catch (Exception e2) {
                        ThreadUtils.checkInterrupted(e2);
                        LOG.error("Exception handling exception", e2);
                    }
                    return null;
                }
            });
        }
    }

    private void handleStateChange(ConnectionState newState) {
        switch (newState) {
            case SUSPENDED: {
                this.publishEvent(TreeCacheEvent.Type.CONNECTION_SUSPENDED);
                break;
            }
            case LOST: {
                this.isInitialized.set(false);
                this.publishEvent(TreeCacheEvent.Type.CONNECTION_LOST);
                break;
            }
            case CONNECTED: {
                try {
                    this.root.wasCreated();
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted(e);
                    this.handleException(e);
                }
                break;
            }
            case RECONNECTED: {
                try {
                    this.root.wasReconnected();
                    this.publishEvent(TreeCacheEvent.Type.CONNECTION_RECONNECTED);
                    break;
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted(e);
                    this.handleException(e);
                }
            }
        }
    }

    private void publishEvent(TreeCacheEvent.Type type) {
        this.publishEvent(new TreeCacheEvent(type, null));
    }

    private void publishEvent(TreeCacheEvent.Type type, ChildData data) {
        this.publishEvent(new TreeCacheEvent(type, data));
    }

    private void publishEvent(final TreeCacheEvent event) {
        if (this.treeState.get() != TreeState.CLOSED) {
            LOG.debug("publishEvent: {}", (Object)event);
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        TreeCache.this.callListeners(event);
                    }
                    catch (Exception e) {
                        ThreadUtils.checkInterrupted(e);
                        TreeCache.this.handleException(e);
                    }
                }
            });
        }
    }

    private static enum TreeState {
        LATENT,
        STARTED,
        CLOSED;

    }

    private final class TreeNode
    implements Watcher,
    BackgroundCallback {
        volatile ChildData childData;
        final TreeNode parent;
        final String path;
        volatile ConcurrentMap<String, TreeNode> children;
        final int depth;

        TreeNode(String path, TreeNode parent) {
            this.path = path;
            this.parent = parent;
            this.depth = parent == null ? 0 : parent.depth + 1;
        }

        private void refresh() throws Exception {
            if (this.depth < TreeCache.this.maxDepth && TreeCache.this.selector.traverseChildren(this.path)) {
                TreeCache.this.outstandingOps.addAndGet(2L);
                this.doRefreshData();
                this.doRefreshChildren();
            } else {
                this.refreshData();
            }
        }

        private void refreshChildren() throws Exception {
            if (this.depth < TreeCache.this.maxDepth && TreeCache.this.selector.traverseChildren(this.path)) {
                TreeCache.this.outstandingOps.incrementAndGet();
                this.doRefreshChildren();
            }
        }

        private void refreshData() throws Exception {
            TreeCache.this.outstandingOps.incrementAndGet();
            this.doRefreshData();
        }

        private void doRefreshChildren() throws Exception {
            if (TreeCache.this.treeState.get() == TreeState.STARTED) {
                this.maybeWatch(TreeCache.this.client.getChildren()).forPath(this.path);
            }
        }

        private void doRefreshData() throws Exception {
            if (TreeCache.this.treeState.get() == TreeState.STARTED) {
                if (TreeCache.this.dataIsCompressed) {
                    this.maybeWatch((GetDataWatchBackgroundStatable)TreeCache.this.client.getData().decompressed()).forPath(this.path);
                } else {
                    this.maybeWatch(TreeCache.this.client.getData()).forPath(this.path);
                }
            }
        }

        private <T, P extends Watchable<BackgroundPathable<T>> & BackgroundPathable<T>> Pathable<T> maybeWatch(P dataBuilder) {
            if (TreeCache.this.disableZkWatches) {
                return (Pathable)((Backgroundable)dataBuilder).inBackground(this);
            }
            return (Pathable)dataBuilder.usingWatcher(this).inBackground(this);
        }

        void wasReconnected() throws Exception {
            this.refresh();
            ConcurrentMap<String, TreeNode> childMap = this.children;
            if (childMap != null) {
                for (TreeNode child : childMap.values()) {
                    child.wasReconnected();
                }
            }
        }

        void wasCreated() throws Exception {
            this.refresh();
        }

        void wasDeleted() throws Exception {
            ChildData oldChildData = childDataUpdater.getAndSet(this, DEAD);
            if (oldChildData == DEAD) {
                return;
            }
            ConcurrentMap childMap = childrenUpdater.getAndSet(this, null);
            if (childMap != null) {
                ArrayList childCopy = new ArrayList(childMap.values());
                childMap.clear();
                for (TreeNode child : childCopy) {
                    child.wasDeleted();
                }
            }
            if (TreeCache.this.treeState.get() == TreeState.CLOSED) {
                return;
            }
            if (TreeCache.isLive(oldChildData)) {
                TreeCache.this.publishEvent(TreeCacheEvent.Type.NODE_REMOVED, oldChildData);
            }
            if (this.parent == null) {
                this.maybeWatch(TreeCache.this.client.checkExists()).forPath(this.path);
            } else {
                ConcurrentMap<String, TreeNode> parentChildMap = this.parent.children;
                if (parentChildMap != null) {
                    parentChildMap.remove(ZKPaths.getNodeFromPath(this.path), this);
                }
            }
        }

        @Override
        public void process(WatchedEvent event) {
            LOG.debug("process: {}", (Object)event);
            try {
                switch (event.getType()) {
                    case NodeCreated: {
                        Preconditions.checkState(this.parent == null, "unexpected NodeCreated on non-root node");
                        this.wasCreated();
                        break;
                    }
                    case NodeChildrenChanged: {
                        this.refreshChildren();
                        break;
                    }
                    case NodeDataChanged: {
                        this.refreshData();
                        break;
                    }
                    case NodeDeleted: {
                        this.wasDeleted();
                    }
                }
            }
            catch (Exception e) {
                ThreadUtils.checkInterrupted(e);
                TreeCache.this.handleException(e);
            }
        }

        @Override
        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            LOG.debug("processResult: {}", (Object)event);
            Stat newStat = event.getStat();
            block0 : switch (event.getType()) {
                case EXISTS: {
                    Preconditions.checkState(this.parent == null, "unexpected EXISTS on non-root node");
                    if (event.getResultCode() != KeeperException.Code.OK.intValue()) break;
                    childDataUpdater.compareAndSet(this, DEAD, null);
                    this.wasCreated();
                    break;
                }
                case CHILDREN: {
                    if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                        ChildData oldChildData = this.childData;
                        if (TreeCache.isLive(oldChildData) && oldChildData.getStat().getMzxid() == newStat.getMzxid()) {
                            childDataUpdater.compareAndSet(this, oldChildData, new ChildData(oldChildData.getPath(), newStat, oldChildData.getData()));
                        }
                        if (event.getChildren().isEmpty()) break;
                        ConcurrentMap<String, TreeNode> childMap = this.children;
                        while (childMap == null) {
                            childMap = Maps.newConcurrentMap();
                            if (childrenUpdater.compareAndSet(this, null, childMap)) continue;
                            childMap = this.children;
                        }
                        ArrayList<String> newChildren = new ArrayList<String>();
                        for (String child : event.getChildren()) {
                            if (childMap.containsKey(child) || !TreeCache.this.selector.acceptChild(ZKPaths.makePath(this.path, child))) continue;
                            newChildren.add(child);
                        }
                        Collections.sort(newChildren);
                        for (String child : newChildren) {
                            String fullPath;
                            TreeNode node;
                            if (childMap.putIfAbsent(child, node = new TreeNode(fullPath = ZKPaths.makePath(this.path, child), this)) != null) continue;
                            node.wasCreated();
                        }
                        break;
                    }
                    if (event.getResultCode() != KeeperException.Code.NONODE.intValue()) break;
                    this.wasDeleted();
                    break;
                }
                case GET_DATA: {
                    if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                        ChildData oldChildData;
                        ChildData toUpdate;
                        String eventPath = event.getPath();
                        ChildData toPublish = new ChildData(eventPath, newStat, event.getData());
                        ChildData childData = toUpdate = TreeCache.this.cacheData ? toPublish : new ChildData(eventPath, newStat, null);
                        while (!(TreeCache.isLive(oldChildData = this.childData) && newStat.getMzxid() <= oldChildData.getStat().getMzxid() || this.parent != null && oldChildData == DEAD)) {
                            if (!childDataUpdater.compareAndSet(this, oldChildData, toUpdate)) continue;
                            TreeCache.this.publishEvent(TreeCache.isLive(oldChildData) ? TreeCacheEvent.Type.NODE_UPDATED : TreeCacheEvent.Type.NODE_ADDED, toPublish);
                            break block0;
                        }
                        break;
                    }
                    if (event.getResultCode() != KeeperException.Code.NONODE.intValue()) break;
                    this.wasDeleted();
                    break;
                }
                default: {
                    LOG.info(String.format("Unknown event %s", event));
                    TreeCache.this.outstandingOps.decrementAndGet();
                    return;
                }
            }
            if (TreeCache.this.outstandingOps.decrementAndGet() == 0L && TreeCache.this.isInitialized.compareAndSet(false, true)) {
                TreeCache.this.publishEvent(TreeCacheEvent.Type.INITIALIZED);
            }
        }
    }

    public static final class Builder {
        private final CuratorFramework client;
        private final String path;
        private boolean cacheData = true;
        private boolean dataIsCompressed = false;
        private ExecutorService executorService = null;
        private int maxDepth = Integer.MAX_VALUE;
        private boolean createParentNodes = false;
        private boolean disableZkWatches = false;
        private TreeCacheSelector selector = new DefaultTreeCacheSelector();

        private Builder(CuratorFramework client, String path) {
            this.client = Preconditions.checkNotNull(client);
            this.path = PathUtils.validatePath(path);
        }

        public TreeCache build() {
            ExecutorService executor = this.executorService;
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor(defaultThreadFactory);
            }
            return new TreeCache(this.client, this.path, this.cacheData, this.dataIsCompressed, this.maxDepth, executor, this.createParentNodes, this.disableZkWatches, this.selector);
        }

        public Builder setCacheData(boolean cacheData) {
            this.cacheData = cacheData;
            return this;
        }

        public Builder setDataIsCompressed(boolean dataIsCompressed) {
            this.dataIsCompressed = dataIsCompressed;
            return this;
        }

        public Builder setExecutor(ThreadFactory threadFactory) {
            return this.setExecutor(Executors.newSingleThreadExecutor(threadFactory));
        }

        public Builder setExecutor(ExecutorService executorService) {
            this.executorService = Preconditions.checkNotNull(executorService);
            return this;
        }

        public Builder setMaxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public Builder setCreateParentNodes(boolean createParentNodes) {
            this.createParentNodes = createParentNodes;
            return this;
        }

        public Builder disableZkWatches(boolean disableZkWatches) {
            this.disableZkWatches = disableZkWatches;
            return this;
        }

        public Builder setSelector(TreeCacheSelector selector) {
            this.selector = selector;
            return this;
        }
    }
}

