/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import oadd.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import oadd.org.apache.zookeeper.server.persistence.Util;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class PurgeTxnLog {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeTxnLog.class);
    private static final String COUNT_ERR_MSG = "count should be greater than or equal to 3";
    private static final String PREFIX_SNAPSHOT = "snapshot";
    private static final String PREFIX_LOG = "log";

    static void printUsage() {
        System.out.println("Usage:");
        System.out.println("PurgeTxnLog dataLogDir [snapDir] -n count");
        System.out.println("\tdataLogDir -- path to the txn log directory");
        System.out.println("\tsnapDir -- path to the snapshot directory");
        System.out.println("\tcount -- the number of old snaps/logs you want to keep, value should be greater than or equal to 3");
    }

    public static void purge(File dataDir, File snapDir, int num) throws IOException {
        if (num < 3) {
            throw new IllegalArgumentException(COUNT_ERR_MSG);
        }
        FileTxnSnapLog txnLog = new FileTxnSnapLog(dataDir, snapDir);
        List<File> snaps = txnLog.findNRecentSnapshots(num);
        int numSnaps = snaps.size();
        if (numSnaps > 0) {
            PurgeTxnLog.purgeOlderSnapshots(txnLog, snaps.get(numSnaps - 1));
        }
    }

    static void purgeOlderSnapshots(FileTxnSnapLog txnLog, File snapShot) {
        final long leastZxidToBeRetain = Util.getZxidFromName(snapShot.getName(), PREFIX_SNAPSHOT);
        final HashSet<File> retainedTxnLogs = new HashSet<File>();
        retainedTxnLogs.addAll(Arrays.asList(txnLog.getSnapshotLogs(leastZxidToBeRetain)));
        ArrayList<File> files = new ArrayList<File>();
        class MyFileFilter
        implements FileFilter {
            private final String prefix;

            MyFileFilter(String prefix) {
                this.prefix = prefix;
            }

            @Override
            public boolean accept(File f) {
                if (!f.getName().startsWith(this.prefix + ".")) {
                    return false;
                }
                if (retainedTxnLogs.contains(f)) {
                    return false;
                }
                long fZxid = Util.getZxidFromName(f.getName(), this.prefix);
                return fZxid < leastZxidToBeRetain;
            }
        }
        File[] fileArray = txnLog.getDataDir().listFiles(new MyFileFilter(PREFIX_LOG));
        if (fileArray != null) {
            files.addAll(Arrays.asList(fileArray));
        }
        if ((fileArray = txnLog.getSnapDir().listFiles(new MyFileFilter(PREFIX_SNAPSHOT))) != null) {
            files.addAll(Arrays.asList(fileArray));
        }
        for (File f : files) {
            String msg = "Removing file: " + DateFormat.getDateTimeInstance().format(f.lastModified()) + "\t" + f.getPath();
            LOG.info(msg);
            System.out.println(msg);
            if (f.delete()) continue;
            System.err.println("Failed to remove " + f.getPath());
        }
    }

    public static void main(String[] args) throws IOException {
        File dataDir;
        if (args.length < 3 || args.length > 4) {
            PurgeTxnLog.printUsageThenExit();
        }
        File snapDir = dataDir = PurgeTxnLog.validateAndGetFile(args[0]);
        int num = -1;
        String countOption = "";
        if (args.length == 3) {
            countOption = args[1];
            num = PurgeTxnLog.validateAndGetCount(args[2]);
        } else {
            snapDir = PurgeTxnLog.validateAndGetFile(args[1]);
            countOption = args[2];
            num = PurgeTxnLog.validateAndGetCount(args[3]);
        }
        if (!"-n".equals(countOption)) {
            PurgeTxnLog.printUsageThenExit();
        }
        PurgeTxnLog.purge(dataDir, snapDir, num);
    }

    private static File validateAndGetFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            System.err.println("Path '" + file.getAbsolutePath() + "' does not exist. ");
            PurgeTxnLog.printUsageThenExit();
        }
        return file;
    }

    private static int validateAndGetCount(String number) {
        int result = 0;
        try {
            result = Integer.parseInt(number);
            if (result < 3) {
                System.err.println(COUNT_ERR_MSG);
                PurgeTxnLog.printUsageThenExit();
            }
        }
        catch (NumberFormatException e) {
            System.err.println("'" + number + "' can not be parsed to integer.");
            PurgeTxnLog.printUsageThenExit();
        }
        return result;
    }

    private static void printUsageThenExit() {
        PurgeTxnLog.printUsage();
        System.exit(1);
    }
}

