/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.security.authorize;

import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import oadd.org.apache.hadoop.security.authorize.AuthorizationException;
import oadd.org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import oadd.org.apache.hadoop.security.authorize.ImpersonationProvider;
import oadd.org.apache.hadoop.security.authorize.ProxyServers;
import oadd.org.apache.hadoop.util.ReflectionUtils;

@InterfaceStability.Unstable
@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "HBase", "Hive"})
public class ProxyUsers {
    public static final String CONF_HADOOP_PROXYUSER = "hadoop.proxyuser";
    private static volatile ImpersonationProvider sip;

    private static ImpersonationProvider getInstance(Configuration conf) {
        Class<ImpersonationProvider> clazz = conf.getClass("hadoop.security.impersonation.provider.class", DefaultImpersonationProvider.class, ImpersonationProvider.class);
        return ReflectionUtils.newInstance(clazz, conf);
    }

    public static void refreshSuperUserGroupsConfiguration() {
        ProxyUsers.refreshSuperUserGroupsConfiguration(new Configuration());
    }

    public static void refreshSuperUserGroupsConfiguration(Configuration conf, String proxyUserPrefix) {
        Preconditions.checkArgument(proxyUserPrefix != null && !proxyUserPrefix.isEmpty(), "prefix cannot be NULL or empty");
        ImpersonationProvider ip = ProxyUsers.getInstance(conf);
        ip.init(proxyUserPrefix);
        sip = ip;
        ProxyServers.refresh(conf);
    }

    public static void refreshSuperUserGroupsConfiguration(Configuration conf) {
        ProxyUsers.refreshSuperUserGroupsConfiguration(conf, CONF_HADOOP_PROXYUSER);
    }

    public static void authorize(UserGroupInformation user, String remoteAddress) throws AuthorizationException {
        if (sip == null) {
            ProxyUsers.refreshSuperUserGroupsConfiguration();
        }
        sip.authorize(user, remoteAddress);
    }

    @Deprecated
    public static void authorize(UserGroupInformation user, String remoteAddress, Configuration conf) throws AuthorizationException {
        ProxyUsers.authorize(user, remoteAddress);
    }

    @VisibleForTesting
    public static DefaultImpersonationProvider getDefaultImpersonationProvider() {
        return (DefaultImpersonationProvider)sip;
    }
}

