/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.metrics2;

import java.util.StringJoiner;
import oadd.com.google.common.base.Objects;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.metrics2.MetricsInfo;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MetricsTag
implements MetricsInfo {
    private final MetricsInfo info;
    private final String value;

    public MetricsTag(MetricsInfo info, String value) {
        this.info = Preconditions.checkNotNull(info, "tag info");
        this.value = value;
    }

    @Override
    public String name() {
        return this.info.name();
    }

    @Override
    public String description() {
        return this.info.description();
    }

    public MetricsInfo info() {
        return this.info;
    }

    public String value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetricsTag) {
            MetricsTag other = (MetricsTag)obj;
            return Objects.equal(this.info, other.info()) && Objects.equal(this.value, other.value());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.info, this.value);
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("info=" + this.info).add("value=" + this.value()).toString();
    }
}

