/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.file.tfile;

import java.io.Serializable;
import java.util.Comparator;
import oadd.org.apache.hadoop.io.RawComparator;
import oadd.org.apache.hadoop.io.WritableComparator;
import oadd.org.apache.hadoop.io.file.tfile.RawComparable;

class CompareUtils {
    private CompareUtils() {
    }

    public static final class MemcmpRawComparator
    implements RawComparator<Object>,
    Serializable {
        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return WritableComparator.compareBytes(b1, s1, l1, b2, s2, l2);
        }

        @Override
        public int compare(Object o1, Object o2) {
            throw new RuntimeException("Object comparison not supported");
        }
    }

    public static final class ScalarComparator
    implements Comparator<Scalar>,
    Serializable {
        @Override
        public int compare(Scalar o1, Scalar o2) {
            long diff = o1.magnitude() - o2.magnitude();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }

    static final class ScalarLong
    implements Scalar {
        private long magnitude;

        public ScalarLong(long m) {
            this.magnitude = m;
        }

        @Override
        public long magnitude() {
            return this.magnitude;
        }
    }

    static interface Scalar {
        public long magnitude();
    }

    public static final class BytesComparator
    implements Comparator<RawComparable> {
        private RawComparator<Object> cmp;

        public BytesComparator(RawComparator<Object> cmp) {
            this.cmp = cmp;
        }

        @Override
        public int compare(RawComparable o1, RawComparable o2) {
            return this.compare(o1.buffer(), o1.offset(), o1.size(), o2.buffer(), o2.offset(), o2.size());
        }

        public int compare(byte[] a, int off1, int len1, byte[] b, int off2, int len2) {
            return this.cmp.compare(a, off1, len1, b, off2, len2);
        }
    }
}

