/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.compress.zlib;

import java.io.IOException;
import java.util.zip.Checksum;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import oadd.org.apache.hadoop.io.compress.Decompressor;
import oadd.org.apache.hadoop.io.compress.DoNotPool;
import oadd.org.apache.hadoop.util.DataChecksum;

@DoNotPool
public class BuiltInGzipDecompressor
implements Decompressor {
    private static final int GZIP_MAGIC_ID = 35615;
    private static final int GZIP_DEFLATE_METHOD = 8;
    private static final int GZIP_FLAGBIT_HEADER_CRC = 2;
    private static final int GZIP_FLAGBIT_EXTRA_FIELD = 4;
    private static final int GZIP_FLAGBIT_FILENAME = 8;
    private static final int GZIP_FLAGBIT_COMMENT = 16;
    private static final int GZIP_FLAGBITS_RESERVED = 224;
    private Inflater inflater = new Inflater(true);
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private byte[] localBuf = new byte[256];
    private int localBufOff = 0;
    private int headerBytesRead = 0;
    private int trailerBytesRead = 0;
    private int numExtraFieldBytesRemaining = -1;
    private Checksum crc = DataChecksum.newCrc32();
    private boolean hasExtraField = false;
    private boolean hasFilename = false;
    private boolean hasComment = false;
    private boolean hasHeaderCRC = false;
    private GzipStateLabel state = GzipStateLabel.HEADER_BASIC;

    public BuiltInGzipDecompressor() {
        this.crc.reset();
    }

    @Override
    public synchronized boolean needsInput() {
        if (this.state == GzipStateLabel.DEFLATE_STREAM) {
            return this.inflater.needsInput();
        }
        return this.state != GzipStateLabel.FINISHED;
    }

    @Override
    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
    }

    @Override
    public synchronized int decompress(byte[] b, int off, int len) throws IOException {
        int numAvailBytes = 0;
        if (this.state != GzipStateLabel.DEFLATE_STREAM) {
            this.executeHeaderState();
            if (this.userBufLen <= 0) {
                return numAvailBytes;
            }
        }
        if (this.state == GzipStateLabel.DEFLATE_STREAM) {
            if (this.userBufLen > 0) {
                this.inflater.setInput(this.userBuf, this.userBufOff, this.userBufLen);
                this.userBufOff += this.userBufLen;
                this.userBufLen = 0;
            }
            try {
                numAvailBytes = this.inflater.inflate(b, off, len);
            }
            catch (DataFormatException dfe) {
                throw new IOException(dfe.getMessage());
            }
            this.crc.update(b, off, numAvailBytes);
            if (this.inflater.finished()) {
                this.state = GzipStateLabel.TRAILER_CRC;
                int bytesRemaining = this.inflater.getRemaining();
                assert (bytesRemaining >= 0) : "logic error: Inflater finished; byte-count is inconsistent";
                this.userBufOff -= bytesRemaining;
                this.userBufLen = bytesRemaining;
            } else {
                return numAvailBytes;
            }
        }
        this.executeTrailerState();
        return numAvailBytes;
    }

    private void executeHeaderState() throws IOException {
        int n;
        if (this.userBufLen <= 0) {
            return;
        }
        if (this.state == GzipStateLabel.HEADER_BASIC) {
            n = Math.min(this.userBufLen, 10 - this.localBufOff);
            this.checkAndCopyBytesToLocal(n);
            if (this.localBufOff >= 10) {
                this.processBasicHeader();
                this.localBufOff = 0;
                this.state = GzipStateLabel.HEADER_EXTRA_FIELD;
            }
        }
        if (this.userBufLen <= 0) {
            return;
        }
        if (this.state == GzipStateLabel.HEADER_EXTRA_FIELD) {
            if (this.hasExtraField) {
                if (this.numExtraFieldBytesRemaining < 0) {
                    n = Math.min(this.userBufLen, 2 - this.localBufOff);
                    this.checkAndCopyBytesToLocal(n);
                    if (this.localBufOff >= 2) {
                        this.numExtraFieldBytesRemaining = this.readUShortLE(this.localBuf, 0);
                        this.localBufOff = 0;
                    }
                }
                if (this.numExtraFieldBytesRemaining > 0 && this.userBufLen > 0) {
                    n = Math.min(this.userBufLen, this.numExtraFieldBytesRemaining);
                    this.checkAndSkipBytes(n);
                    this.numExtraFieldBytesRemaining -= n;
                }
                if (this.numExtraFieldBytesRemaining == 0) {
                    this.state = GzipStateLabel.HEADER_FILENAME;
                }
            } else {
                this.state = GzipStateLabel.HEADER_FILENAME;
            }
        }
        if (this.userBufLen <= 0) {
            return;
        }
        if (this.state == GzipStateLabel.HEADER_FILENAME) {
            boolean doneWithFilename;
            if (this.hasFilename && !(doneWithFilename = this.checkAndSkipBytesUntilNull())) {
                return;
            }
            this.state = GzipStateLabel.HEADER_COMMENT;
        }
        if (this.userBufLen <= 0) {
            return;
        }
        if (this.state == GzipStateLabel.HEADER_COMMENT) {
            boolean doneWithComment;
            if (this.hasComment && !(doneWithComment = this.checkAndSkipBytesUntilNull())) {
                return;
            }
            this.state = GzipStateLabel.HEADER_CRC;
        }
        if (this.userBufLen <= 0) {
            return;
        }
        if (this.state == GzipStateLabel.HEADER_CRC) {
            if (this.hasHeaderCRC) {
                assert (this.localBufOff < 2);
                n = Math.min(this.userBufLen, 2 - this.localBufOff);
                this.copyBytesToLocal(n);
                if (this.localBufOff >= 2) {
                    long headerCRC = this.readUShortLE(this.localBuf, 0);
                    if (headerCRC != (this.crc.getValue() & 0xFFFFL)) {
                        throw new IOException("gzip header CRC failure");
                    }
                    this.localBufOff = 0;
                    this.crc.reset();
                    this.state = GzipStateLabel.DEFLATE_STREAM;
                }
            } else {
                this.crc.reset();
                this.state = GzipStateLabel.DEFLATE_STREAM;
            }
        }
    }

    private void executeTrailerState() throws IOException {
        int n;
        if (this.userBufLen <= 0) {
            return;
        }
        if (this.state == GzipStateLabel.TRAILER_CRC) {
            assert (this.localBufOff < 4);
            n = Math.min(this.userBufLen, 4 - this.localBufOff);
            this.copyBytesToLocal(n);
            if (this.localBufOff >= 4) {
                long streamCRC = this.readUIntLE(this.localBuf, 0);
                if (streamCRC != this.crc.getValue()) {
                    throw new IOException("gzip stream CRC failure");
                }
                this.localBufOff = 0;
                this.crc.reset();
                this.state = GzipStateLabel.TRAILER_SIZE;
            }
        }
        if (this.userBufLen <= 0) {
            return;
        }
        if (this.state == GzipStateLabel.TRAILER_SIZE) {
            assert (this.localBufOff < 4);
            n = Math.min(this.userBufLen, 4 - this.localBufOff);
            this.copyBytesToLocal(n);
            if (this.localBufOff >= 4) {
                long inputSize = this.readUIntLE(this.localBuf, 0);
                if (inputSize != (this.inflater.getBytesWritten() & 0xFFFFFFFFL)) {
                    throw new IOException("stored gzip size doesn't match decompressed size");
                }
                this.localBufOff = 0;
                this.state = GzipStateLabel.FINISHED;
            }
        }
        if (this.state == GzipStateLabel.FINISHED) {
            return;
        }
    }

    public synchronized long getBytesRead() {
        return (long)this.headerBytesRead + this.inflater.getBytesRead() + (long)this.trailerBytesRead;
    }

    @Override
    public synchronized int getRemaining() {
        return this.userBufLen;
    }

    @Override
    public synchronized boolean needsDictionary() {
        return this.inflater.needsDictionary();
    }

    @Override
    public synchronized void setDictionary(byte[] b, int off, int len) {
        this.inflater.setDictionary(b, off, len);
    }

    @Override
    public synchronized boolean finished() {
        return this.state == GzipStateLabel.FINISHED;
    }

    @Override
    public synchronized void reset() {
        this.inflater.reset();
        this.state = GzipStateLabel.HEADER_BASIC;
        this.crc.reset();
        this.userBufLen = 0;
        this.userBufOff = 0;
        this.localBufOff = 0;
        this.headerBytesRead = 0;
        this.trailerBytesRead = 0;
        this.numExtraFieldBytesRemaining = -1;
        this.hasExtraField = false;
        this.hasFilename = false;
        this.hasComment = false;
        this.hasHeaderCRC = false;
    }

    @Override
    public synchronized void end() {
        this.inflater.end();
    }

    private void processBasicHeader() throws IOException {
        if (this.readUShortLE(this.localBuf, 0) != 35615) {
            throw new IOException("not a gzip file");
        }
        if (this.readUByte(this.localBuf, 2) != 8) {
            throw new IOException("gzip data not compressed with deflate method");
        }
        int flg = this.readUByte(this.localBuf, 3);
        if ((flg & 0xE0) != 0) {
            throw new IOException("unknown gzip format (reserved flagbits set)");
        }
        this.hasExtraField = (flg & 4) != 0;
        this.hasFilename = (flg & 8) != 0;
        this.hasComment = (flg & 0x10) != 0;
        this.hasHeaderCRC = (flg & 2) != 0;
    }

    private void checkAndCopyBytesToLocal(int len) {
        System.arraycopy(this.userBuf, this.userBufOff, this.localBuf, this.localBufOff, len);
        this.localBufOff += len;
        this.crc.update(this.userBuf, this.userBufOff, len);
        this.userBufOff += len;
        this.userBufLen -= len;
        this.headerBytesRead += len;
    }

    private void checkAndSkipBytes(int len) {
        this.crc.update(this.userBuf, this.userBufOff, len);
        this.userBufOff += len;
        this.userBufLen -= len;
        this.headerBytesRead += len;
    }

    private boolean checkAndSkipBytesUntilNull() {
        boolean hitNull = false;
        if (this.userBufLen > 0) {
            do {
                hitNull = this.userBuf[this.userBufOff] == 0;
                this.crc.update(this.userBuf[this.userBufOff]);
                ++this.userBufOff;
                --this.userBufLen;
                ++this.headerBytesRead;
            } while (this.userBufLen > 0 && !hitNull);
        }
        return hitNull;
    }

    private void copyBytesToLocal(int len) {
        System.arraycopy(this.userBuf, this.userBufOff, this.localBuf, this.localBufOff, len);
        this.localBufOff += len;
        this.userBufOff += len;
        this.userBufLen -= len;
        if (this.state == GzipStateLabel.TRAILER_CRC || this.state == GzipStateLabel.TRAILER_SIZE) {
            this.trailerBytesRead += len;
        } else {
            this.headerBytesRead += len;
        }
    }

    private int readUByte(byte[] b, int off) {
        return b[off] & 0xFF;
    }

    private int readUShortLE(byte[] b, int off) {
        return ((b[off + 1] & 0xFF) << 8 | b[off] & 0xFF) & 0xFFFF;
    }

    private long readUIntLE(byte[] b, int off) {
        return ((long)(b[off + 3] & 0xFF) << 24 | (long)(b[off + 2] & 0xFF) << 16 | (long)(b[off + 1] & 0xFF) << 8 | (long)(b[off] & 0xFF)) & 0xFFFFFFFFL;
    }

    private static enum GzipStateLabel {
        HEADER_BASIC,
        HEADER_EXTRA_FIELD,
        HEADER_FILENAME,
        HEADER_COMMENT,
        HEADER_CRC,
        DEFLATE_STREAM,
        TRAILER_CRC,
        TRAILER_SIZE,
        FINISHED;

    }
}

