/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.shell.find;

public final class Result {
    public static final Result PASS = new Result(true, true);
    public static final Result FAIL = new Result(false, true);
    public static final Result STOP = new Result(true, false);
    private boolean descend;
    private boolean success;

    private Result(boolean success, boolean recurse) {
        this.success = success;
        this.descend = recurse;
    }

    public boolean isDescend() {
        return this.descend;
    }

    public boolean isPass() {
        return this.success;
    }

    public Result combine(Result other) {
        return new Result(this.isPass() && other.isPass(), this.isDescend() && other.isDescend());
    }

    public Result negate() {
        return new Result(!this.isPass(), this.isDescend());
    }

    public String toString() {
        return "success=" + this.isPass() + "; recurse=" + this.isDescend();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.descend ? 1231 : 1237);
        result = 31 * result + (this.success ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Result other = (Result)obj;
        if (this.descend != other.descend) {
            return false;
        }
        return this.success == other.success;
    }
}

