/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import oadd.org.apache.drill.exec.expr.holders.VarDecimalHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.RepeatedVarDecimalVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class RepeatedVarDecimalWriterImpl
extends AbstractFieldWriter {
    private final RepeatedVarDecimalVector.Mutator mutator;
    final RepeatedVarDecimalVector vector;

    public RepeatedVarDecimalWriterImpl(RepeatedVarDecimalVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(VarDecimalHolder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableVarDecimalHolder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeVarDecimal(int start, int end, DrillBuf buffer, int precision, int scale) {
        this.mutator.addSafe(this.idx(), start, end, buffer);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeVarDecimal(BigDecimal value) {
        this.mutator.addSafe(this.idx(), value.unscaledValue().toByteArray());
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void setPosition(int idx) {
        super.setPosition(idx);
        if (idx >= this.vector.getAccessor().getValueCount()) {
            this.mutator.startNewValue(idx);
        }
    }
}

