/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import oadd.org.apache.drill.exec.expr.holders.UInt8Holder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.RepeatedUInt8Vector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class RepeatedUInt8WriterImpl
extends AbstractFieldWriter {
    private final RepeatedUInt8Vector.Mutator mutator;
    final RepeatedUInt8Vector vector;

    public RepeatedUInt8WriterImpl(RepeatedUInt8Vector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(UInt8Holder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableUInt8Holder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeUInt8(long value) {
        this.mutator.addSafe(this.idx(), value);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void setPosition(int idx) {
        super.setPosition(idx);
        if (idx >= this.vector.getAccessor().getValueCount()) {
            this.mutator.startNewValue(idx);
        }
    }
}

